/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.google.common.base.Predicates;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.CapManipulationBehaviourBase;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class TankManipulationBehaviour
extends CapManipulationBehaviourBase<FluidVariant, TankManipulationBehaviour> {
    public static final BehaviourType<TankManipulationBehaviour> OBSERVE = new BehaviourType();
    private BehaviourType<TankManipulationBehaviour> behaviourType;

    public TankManipulationBehaviour(SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        this(OBSERVE, te, target);
    }

    private TankManipulationBehaviour(BehaviourType<TankManipulationBehaviour> type, SmartTileEntity te, CapManipulationBehaviourBase.InterfaceProvider target) {
        super(te, target);
        this.behaviourType = type;
    }

    public FluidStack extractAny() {
        if (!this.hasInventory()) {
            return FluidStack.EMPTY;
        }
        Storage inventory = this.getInventory();
        Predicate<FluidStack> filterTest = this.getFilterTest((Predicate<FluidStack>)Predicates.alwaysTrue());
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : inventory.iterable((TransactionContext)t)) {
                if (view.isResourceBlank()) continue;
                FluidStack stack = new FluidStack(view);
                if (!filterTest.test(stack)) continue;
                long extracted = view.extract((Object)((FluidVariant)view.getResource()), view.getAmount(), (TransactionContext)t);
                if (extracted == 0L) continue;
                if (!this.simulateNext) {
                    t.commit();
                }
                FluidStack fluidStack = stack.setAmount(extracted);
                return fluidStack;
            }
        }
        return FluidStack.EMPTY;
    }

    protected Predicate<FluidStack> getFilterTest(Predicate<FluidStack> customFilter) {
        Predicate<FluidStack> test = customFilter;
        FilteringBehaviour filter = this.tileEntity.getBehaviour(FilteringBehaviour.TYPE);
        if (filter != null) {
            test = customFilter.and(filter::test);
        }
        return test;
    }

    @Override
    protected Class<FluidVariant> capability() {
        return FluidVariant.class;
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }
}

