/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.block.chute.ChuteBlock;
import com.simibubi.create.content.logistics.block.chute.SmartChuteTileEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.EntityElement;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class ChuteScenes {
    public static void downward(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("chute", "Transporting Items downward via Chutes");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.9f);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        ElementLink<WorldSectionElement> top = scene.world.showIndependentSection(util.select.fromTo(3, 3, 3, 3, 4, 3), class_2350.field_11033);
        ElementLink<WorldSectionElement> bottom = scene.world.showIndependentSection(util.select.fromTo(3, 2, 3, 3, 1, 3), class_2350.field_11033);
        scene.world.moveSection(bottom, util.vector.of(-2.0, 0.0, -1.0), 0);
        scene.world.moveSection(top, util.vector.of(0.0, 0.0, -1.0), 0);
        scene.idle(20);
        class_1799 stack = new class_1799((class_1935)class_1802.field_27071);
        scene.world.createItemEntity(util.vector.centerOf(util.grid.at(3, 3, 2)), util.vector.of(0.0, -0.1, 0.0), stack);
        scene.idle(20);
        ElementLink<EntityElement> remove = scene.world.createItemEntity(util.vector.centerOf(util.grid.at(1, 5, 2)), util.vector.of(0.0, 0.1, 0.0), stack);
        scene.idle(15);
        scene.world.modifyEntity(remove, class_1297::method_31472);
        scene.overlay.showText(60).attachKeyFrame().pointAt(util.vector.topOf(util.grid.at(1, 2, 2))).placeNearTarget().text("Chutes can transport items vertically from and to inventories");
        scene.idle(70);
        scene.world.modifyEntities(class_1542.class, class_1297::method_31472);
        scene.world.moveSection(bottom, util.vector.of(1.0, 0.0, 0.0), 10);
        scene.world.moveSection(top, util.vector.of(-1.0, 0.0, 0.0), 10);
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(2, 3, 2), class_2350.field_11043), Pointing.RIGHT).rightClick().withWrench(), 40);
        scene.idle(7);
        scene.world.modifyBlock(util.grid.at(3, 3, 3), s -> (class_2680)s.method_11657(ChuteBlock.SHAPE, (Comparable)((Object)ChuteBlock.Shape.WINDOW)), false);
        scene.overlay.showText(50).attachKeyFrame().pointAt(util.vector.blockSurface(util.grid.at(2, 3, 2), class_2350.field_11039)).placeNearTarget().text("Using the Wrench, a window can be created");
        scene.idle(10);
        scene.world.modifyBlock(util.grid.at(3, 2, 3), s -> (class_2680)s.method_11657(ChuteBlock.SHAPE, (Comparable)((Object)ChuteBlock.Shape.WINDOW)), false);
        for (int i = 0; i < 8; ++i) {
            scene.idle(10);
            scene.world.createItemOnBeltLike(util.grid.at(3, 3, 3), class_2350.field_11036, stack);
        }
        scene.idle(20);
        scene.world.hideIndependentSection(bottom, class_2350.field_11034);
        scene.world.hideIndependentSection(top, class_2350.field_11034);
        scene.idle(15);
        scene.rotateCameraY(-90.0f);
        scene.world.modifyBlock(util.grid.at(2, 2, 1), s -> (class_2680)s.method_11657(ChuteBlock.SHAPE, (Comparable)((Object)ChuteBlock.Shape.NORMAL)), false);
        scene.world.showSection(util.select.fromTo(2, 1, 1, 2, 2, 1), class_2350.field_11033);
        scene.idle(30);
        class_1799 chuteItem = AllBlocks.CHUTE.asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(2, 2, 1), class_2350.field_11035), Pointing.LEFT).rightClick().withItem(chuteItem), 30);
        scene.idle(7);
        scene.world.showSection(util.select.position(2, 3, 2), class_2350.field_11043);
        scene.world.restoreBlocks(util.select.position(2, 2, 1));
        scene.idle(35);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(2, 3, 2), class_2350.field_11035), Pointing.LEFT).rightClick().withItem(chuteItem), 30);
        scene.idle(7);
        scene.world.showSection(util.select.position(2, 4, 3), class_2350.field_11043);
        scene.idle(35);
        scene.overlay.showText(70).attachKeyFrame().pointAt(util.vector.blockSurface(util.grid.at(2, 4, 3), class_2350.field_11039)).placeNearTarget().text("Placing chutes targeting the side faces of another will make it diagonal");
        scene.idle(15);
        scene.rotateCameraY(90.0f);
        scene.idle(35);
        class_2350 offset = class_2350.field_11043;
        for (int i = 0; i < 3; ++i) {
            remove = scene.world.createItemEntity(util.vector.centerOf(util.grid.at(2, 6, 3).method_10093(offset)), util.vector.of(0.0, 0.1, 0.0).method_1019(class_243.method_24954((class_2382)offset.method_10163()).method_1021(-0.1)), stack);
            scene.idle(12);
            scene.world.createItemOnBeltLike(util.grid.at(2, 4, 3), class_2350.field_11036, stack);
            scene.world.modifyEntity(remove, class_1297::method_31472);
            scene.idle(3);
            offset = offset.method_10170();
        }
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(2, 1, 1), class_2350.field_11043), Pointing.RIGHT).withItem(stack), 50);
        scene.markAsFinished();
    }

    public static void upward(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("chute_upward", "Transporting Items upward via Chutes");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.9f);
        scene.showBasePlate();
        Selection chute = util.select.fromTo(1, 2, 2, 1, 4, 2);
        scene.world.setBlocks(chute, class_2246.field_10124.method_9564(), false);
        scene.world.showSection(util.select.position(1, 1, 2), class_2350.field_11036);
        scene.idle(20);
        scene.world.restoreBlocks(chute);
        scene.world.showSection(chute, class_2350.field_11033);
        scene.idle(20);
        scene.world.setKineticSpeed(util.select.position(1, 1, 2), 0.0f);
        class_243 surface = util.vector.blockSurface(util.grid.at(1, 2, 2), class_2350.field_11039);
        scene.overlay.showText(70).text("Using Encased Fans at the top or bottom, a Chute can move items upward").attachKeyFrame().pointAt(surface).placeNearTarget();
        scene.idle(80);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(1, 2, 2), class_2350.field_11043), Pointing.RIGHT).withItem(AllItems.GOGGLES.asStack()), 50);
        scene.overlay.showText(70).text("Inspecting chutes with Engineers' Goggles reveals information about the movement direction").attachKeyFrame().pointAt(surface).placeNearTarget();
        scene.idle(80);
        scene.world.showSection(util.select.fromTo(2, 2, 2, 4, 1, 5).add(util.select.position(3, 0, 5)), class_2350.field_11033);
        class_1799 stack = new class_1799((class_1935)class_1802.field_27071);
        scene.world.createItemOnBelt(util.grid.at(4, 1, 2), class_2350.field_11034, stack);
        scene.idle(10);
        scene.rotateCameraY(60.0f);
        scene.overlay.showText(70).text("On the 'blocked' end, items will have to be inserted/taken from the sides").attachKeyFrame().pointAt(util.vector.centerOf(util.grid.at(3, 1, 2)).method_1031(0.0, 0.1875, 0.0)).placeNearTarget();
        scene.idle(32);
        scene.world.flapFunnel(util.grid.at(2, 2, 2), false);
        scene.world.removeItemsFromBelt(util.grid.at(2, 1, 2));
        scene.world.createItemOnBeltLike(util.grid.at(1, 2, 2), class_2350.field_11034, stack);
    }

    public static void smart(SceneBuilder scene, SceneBuildingUtil util) {
        int i;
        scene.title("smart_chute", "Filtering Items using Smart Chutes");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.9f);
        Selection lever = util.select.fromTo(0, 1, 2, 1, 3, 2);
        class_2338 smarty = util.grid.at(2, 3, 2);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(2, 1, 2, 2, 2, 2), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.position(2, 3, 2), class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(util.select.position(2, 4, 2), class_2350.field_11033);
        scene.overlay.showText(60).text("Smart Chutes are vertical chutes with additional control").attachKeyFrame().pointAt(util.vector.blockSurface(smarty, class_2350.field_11039)).placeNearTarget();
        scene.idle(70);
        class_243 filter = util.vector.blockSurface(smarty, class_2350.field_11043).method_1031(0.0, 0.25, 0.0);
        scene.overlay.showFilterSlotInput(filter, 60);
        class_1799 copper = new class_1799((class_1935)class_1802.field_8620);
        scene.overlay.showControls(new InputWindowElement(filter, Pointing.DOWN).rightClick().withItem(copper), 40);
        scene.idle(7);
        scene.world.setFilterData(util.select.position(smarty), SmartChuteTileEntity.class, copper);
        scene.idle(10);
        scene.rotateCameraY(20.0f);
        scene.overlay.showText(60).text("Items in the filter slot specify what exactly they can extract and transfer").attachKeyFrame().pointAt(filter).placeNearTarget();
        scene.idle(10);
        for (i = 0; i < 18; ++i) {
            scene.idle(10);
            scene.world.createItemOnBeltLike(util.grid.at(2, 2, 2), class_2350.field_11036, copper);
            if (i == 8) {
                scene.rotateCameraY(-20.0f);
                scene.overlay.showControls(new InputWindowElement(filter, Pointing.DOWN).scroll(), 40);
                scene.overlay.showText(50).text("Use the Mouse Wheel to specify the extracted stack size").attachKeyFrame().pointAt(filter).placeNearTarget();
            }
            if (i != 13) continue;
            scene.world.showSection(lever, class_2350.field_11043);
        }
        scene.world.toggleRedstonePower(lever.add(util.select.position(smarty)));
        scene.effects.indicateRedstone(util.grid.at(0, 3, 2));
        scene.overlay.showText(50).text("Redstone power will prevent Smart Chutes from acting.").attachKeyFrame().colored(PonderPalette.RED).pointAt(util.vector.blockSurface(util.grid.at(0, 2, 2), class_2350.field_11036)).placeNearTarget();
        scene.idle(70);
        scene.world.toggleRedstonePower(lever.add(util.select.position(smarty)));
        scene.markAsFinished();
        for (i = 0; i < 8; ++i) {
            scene.idle(10);
            scene.world.createItemOnBeltLike(util.grid.at(2, 2, 2), class_2350.field_11036, copper);
        }
    }
}

