/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.goggles.GogglesItem;
import com.simibubi.create.foundation.block.BlockStressValues;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CKinetics;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ItemDescription {
    public static final ItemDescription MISSING = new ItemDescription(null);
    public static class_2561 trim = Components.literal("                          ").method_27695(new class_124[]{class_124.field_1068, class_124.field_1055});
    private List<class_2561> lines;
    private List<class_2561> linesOnShift;
    private List<class_2561> linesOnCtrl;
    private Palette palette;

    public ItemDescription(Palette palette) {
        this.palette = palette;
        this.lines = new ArrayList<class_2561>();
        this.linesOnShift = new ArrayList<class_2561>();
        this.linesOnCtrl = new ArrayList<class_2561>();
    }

    public ItemDescription withSummary(class_2561 summary) {
        ItemDescription.addStrings(this.linesOnShift, TooltipHelper.cutTextComponent(summary, this.palette.color, this.palette.hColor));
        return this;
    }

    public static List<class_2561> getKineticStats(class_2248 block) {
        boolean hasStressCapacity;
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        CKinetics config = AllConfigs.SERVER.kinetics;
        LangBuilder rpmUnit = Lang.translate("generic.unit.rpm", new Object[0]);
        LangBuilder suUnit = Lang.translate("generic.unit.stress", new Object[0]);
        boolean hasGoggles = GogglesItem.isWearingGoggles((class_1657)class_310.method_1551().field_1724);
        boolean showStressImpact = !(block instanceof IRotate) ? true : !((IRotate)block).hideStressImpact();
        boolean hasStressImpact = IRotate.StressImpact.isEnabled() && showStressImpact && BlockStressValues.getImpact(block) > 0.0;
        boolean bl = hasStressCapacity = IRotate.StressImpact.isEnabled() && BlockStressValues.hasCapacity(block);
        if (hasStressImpact) {
            Lang.translate("tooltip.stressImpact", new Object[0]).style(class_124.field_1080).addTo(list);
            double impact = BlockStressValues.getImpact(block);
            IRotate.StressImpact impactId = impact >= (Double)config.highStressImpact.get() ? IRotate.StressImpact.HIGH : (impact >= (Double)config.mediumStressImpact.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
            LangBuilder builder = Lang.builder().add(Lang.text(ItemDescription.makeProgressBar(3, impactId.ordinal() + 1)).style(impactId.getAbsoluteColor()));
            if (hasGoggles) {
                builder.add(Lang.number(impact)).text("x ").add(rpmUnit).addTo(list);
            } else {
                builder.translate("tooltip.stressImpact." + Lang.asId(impactId.name()), new Object[0]).addTo(list);
            }
        }
        if (hasStressCapacity) {
            Couple<Integer> generatedRPM;
            Lang.translate("tooltip.capacityProvided", new Object[0]).style(class_124.field_1080).addTo(list);
            double capacity = BlockStressValues.getCapacity(block);
            BlockStressValues.IStressValueProvider stressProvider = BlockStressValues.getProvider(block);
            Couple<Integer> couple = generatedRPM = stressProvider != null ? stressProvider.getGeneratedRPM(block) : null;
            IRotate.StressImpact impactId = capacity >= (Double)config.highCapacity.get() ? IRotate.StressImpact.HIGH : (capacity >= (Double)config.mediumCapacity.get() ? IRotate.StressImpact.MEDIUM : IRotate.StressImpact.LOW);
            IRotate.StressImpact opposite = IRotate.StressImpact.values()[IRotate.StressImpact.values().length - 2 - impactId.ordinal()];
            LangBuilder builder = Lang.builder().add(Lang.text(ItemDescription.makeProgressBar(3, impactId.ordinal() + 1)).style(opposite.getAbsoluteColor()));
            if (hasGoggles) {
                builder.add(Lang.number(capacity)).text("x ").add(rpmUnit).addTo(list);
                if (generatedRPM != null) {
                    LangBuilder amount = Lang.number(capacity * (double)((Integer)generatedRPM.getSecond()).intValue()).add(suUnit);
                    Lang.text(" -> ").add(!((Integer)generatedRPM.getFirst()).equals(generatedRPM.getSecond()) ? Lang.translate("tooltip.up_to", amount) : amount).style(class_124.field_1063).addTo(list);
                }
            } else {
                builder.translate("tooltip.capacityProvided." + Lang.asId(impactId.name()), new Object[0]).addTo(list);
            }
        }
        return list;
    }

    public static String makeProgressBar(int length, int filledLength) {
        int i;
        Object bar = " ";
        int emptySpaces = length - filledLength;
        for (i = 0; i < filledLength; ++i) {
            bar = (String)bar + "\u2588";
        }
        for (i = 0; i < emptySpaces; ++i) {
            bar = (String)bar + "\u2592";
        }
        return (String)bar + " ";
    }

    public ItemDescription withBehaviour(String condition, String behaviour) {
        ItemDescription.add(this.linesOnShift, (class_2561)Components.literal(condition).method_27692(class_124.field_1080));
        ItemDescription.addStrings(this.linesOnShift, TooltipHelper.cutStringTextComponent(behaviour, this.palette.color, this.palette.hColor, 1));
        return this;
    }

    public ItemDescription withControl(String condition, String action) {
        ItemDescription.add(this.linesOnCtrl, (class_2561)Components.literal(condition).method_27692(class_124.field_1080));
        ItemDescription.addStrings(this.linesOnCtrl, TooltipHelper.cutStringTextComponent(action, this.palette.color, this.palette.hColor, 1));
        return this;
    }

    public ItemDescription createTabs() {
        boolean hasControls;
        boolean hasDescription = !this.linesOnShift.isEmpty();
        boolean bl = hasControls = !this.linesOnCtrl.isEmpty();
        if (hasDescription || hasControls) {
            String[] holdDesc = Lang.translateDirect("tooltip.holdForDescription", "$").getString().split("\\$");
            String[] holdCtrl = Lang.translateDirect("tooltip.holdForControls", "$").getString().split("\\$");
            class_5250 keyShift = Lang.translateDirect("tooltip.keyShift", new Object[0]);
            class_5250 keyCtrl = Lang.translateDirect("tooltip.keyCtrl", new Object[0]);
            for (List list : Arrays.asList(this.lines, this.linesOnShift, this.linesOnCtrl)) {
                class_5250 tabBuilder;
                boolean ctrl;
                boolean shift = list == this.linesOnShift;
                boolean bl2 = ctrl = list == this.linesOnCtrl;
                if (holdDesc.length != 2 || holdCtrl.length != 2) {
                    list.add(0, Components.literal("Invalid lang formatting!"));
                    continue;
                }
                if (hasControls) {
                    tabBuilder = Components.empty();
                    tabBuilder.method_10852((class_2561)Components.literal(holdCtrl[0]).method_27692(class_124.field_1063));
                    tabBuilder.method_10852((class_2561)keyCtrl.method_27662().method_27692(ctrl ? class_124.field_1068 : class_124.field_1080));
                    tabBuilder.method_10852((class_2561)Components.literal(holdCtrl[1]).method_27692(class_124.field_1063));
                    list.add(0, tabBuilder);
                }
                if (hasDescription) {
                    tabBuilder = Components.empty();
                    tabBuilder.method_10852((class_2561)Components.literal(holdDesc[0]).method_27692(class_124.field_1063));
                    tabBuilder.method_10852((class_2561)keyShift.method_27662().method_27692(shift ? class_124.field_1068 : class_124.field_1080));
                    tabBuilder.method_10852((class_2561)Components.literal(holdDesc[1]).method_27692(class_124.field_1063));
                    list.add(0, tabBuilder);
                }
                if (!shift && !ctrl) continue;
                list.add(hasDescription && hasControls ? 2 : 1, Components.immutableEmpty());
            }
        }
        if (!hasDescription) {
            this.linesOnShift = this.lines;
        }
        if (!hasControls) {
            this.linesOnCtrl = this.lines;
        }
        return this;
    }

    public static String hightlight(String s, Palette palette) {
        return palette.hColor + s + palette.color;
    }

    public static void addStrings(List<class_2561> infoList, List<class_2561> textLines) {
        textLines.forEach(s -> ItemDescription.add(infoList, s));
    }

    public static void add(List<class_2561> infoList, List<class_2561> textLines) {
        infoList.addAll(textLines);
    }

    public static void add(List<class_2561> infoList, class_2561 line) {
        infoList.add(line);
    }

    public Palette getPalette() {
        return this.palette;
    }

    public List<class_2561> addInformation(List<class_2561> tooltip) {
        if (class_437.method_25442()) {
            tooltip.addAll(this.linesOnShift);
            return tooltip;
        }
        if (class_437.method_25441()) {
            tooltip.addAll(this.linesOnCtrl);
            return tooltip;
        }
        tooltip.addAll(this.lines);
        return tooltip;
    }

    public List<class_2561> getLines() {
        return this.lines;
    }

    public List<class_2561> getLinesOnCtrl() {
        return this.linesOnCtrl;
    }

    public List<class_2561> getLinesOnShift() {
        return this.linesOnShift;
    }

    public static enum Palette {
        Blue(class_124.field_1078, class_124.field_1075),
        Green(class_124.field_1077, class_124.field_1060),
        Yellow(class_124.field_1065, class_124.field_1054),
        Red(class_124.field_1079, class_124.field_1061),
        Purple(class_124.field_1064, class_124.field_1076),
        Gray(class_124.field_1063, class_124.field_1080);

        public class_124 color;
        public class_124 hColor;

        private Palette(class_124 primary, class_124 highlight) {
            this.color = primary;
            this.hColor = highlight;
        }
    }
}

