/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.track;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.TrackPropagator;
import com.simibubi.create.content.logistics.trains.track.TrackTileEntity;
import com.simibubi.create.foundation.networking.TileEntityConfigurationPacket;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2498;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public class CurvedTrackDestroyPacket
extends TileEntityConfigurationPacket<TrackTileEntity> {
    private class_2338 targetPos;
    private class_2338 soundSource;
    private boolean wrench;

    public CurvedTrackDestroyPacket(class_2338 pos, class_2338 targetPos, class_2338 soundSource, boolean wrench) {
        super(pos);
        this.targetPos = targetPos;
        this.soundSource = soundSource;
        this.wrench = wrench;
    }

    public CurvedTrackDestroyPacket(class_2540 buffer) {
        super(buffer);
    }

    @Override
    protected void writeSettings(class_2540 buffer) {
        buffer.method_10807(this.targetPos);
        buffer.method_10807(this.soundSource);
        buffer.writeBoolean(this.wrench);
    }

    @Override
    protected void readSettings(class_2540 buffer) {
        this.targetPos = buffer.method_10811();
        this.soundSource = buffer.method_10811();
        this.wrench = buffer.readBoolean();
    }

    @Override
    protected void applySettings(class_3222 player, TrackTileEntity te) {
        if (!te.method_11016().method_19771((class_2382)player.method_24515(), 128.0)) {
            Create.LOGGER.warn(player.method_5820() + " too far away from destroyed Curve track");
            return;
        }
        class_1937 level = te.method_10997();
        BezierConnection bezierConnection = te.getConnections().get(this.targetPos);
        te.removeConnection(this.targetPos);
        class_2586 class_25862 = level.method_8321(this.targetPos);
        if (class_25862 instanceof TrackTileEntity) {
            TrackTileEntity other = (TrackTileEntity)class_25862;
            other.removeConnection(this.pos);
        }
        class_2680 blockState = te.method_11010();
        TrackPropagator.onRailRemoved((class_1936)level, this.pos, blockState);
        if (this.wrench) {
            AllSoundEvents.WRENCH_REMOVE.playOnServer(player.field_6002, (class_2382)this.soundSource, 1.0f, Create.RANDOM.nextFloat() * 0.5f + 0.5f);
            if (!player.method_7337() && bezierConnection != null) {
                bezierConnection.addItemsToPlayer((class_1657)player);
            }
        } else if (!player.method_7337() && bezierConnection != null) {
            bezierConnection.spawnItems(level);
        }
        bezierConnection.spawnDestroyParticles(level);
        class_2498 soundtype = blockState.method_26231();
        if (soundtype == null) {
            return;
        }
        level.method_8396(null, this.soundSource, soundtype.method_10595(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
    }

    @Override
    protected int maxRange() {
        return 64;
    }

    @Override
    protected void applySettings(TrackTileEntity te) {
    }
}

