/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.jozufozu.flywheel.api.MaterialManager;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.DimensionPalette;
import com.simibubi.create.content.logistics.trains.IBogeyBlock;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.entity.BogeyInstance;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;

public class CarriageBogey {
    public Carriage carriage;
    boolean isLeading;
    IBogeyBlock type;
    Couple<TravellingPoint> points;
    LerpedFloat wheelAngle;
    LerpedFloat yaw;
    LerpedFloat pitch;
    public Couple<class_243> couplingAnchors;
    int derailAngle;

    public CarriageBogey(IBogeyBlock type, TravellingPoint point, TravellingPoint point2) {
        this.type = type;
        this.points = Couple.create(point, point2);
        this.wheelAngle = LerpedFloat.angular();
        this.yaw = LerpedFloat.angular();
        this.pitch = LerpedFloat.angular();
        this.derailAngle = Create.RANDOM.nextInt(60) - 30;
        this.couplingAnchors = Couple.create(null, null);
    }

    public class_5321<class_1937> getDimension() {
        TravellingPoint leading = this.leading();
        TravellingPoint trailing = this.trailing();
        if (leading.edge == null || trailing.edge == null) {
            return null;
        }
        if (leading.edge.isInterDimensional() || trailing.edge.isInterDimensional()) {
            return null;
        }
        class_5321<class_1937> dimension1 = leading.node1.getLocation().dimension;
        class_5321<class_1937> dimension2 = trailing.node1.getLocation().dimension;
        if (dimension1.equals(dimension2)) {
            return dimension1;
        }
        return null;
    }

    public void updateAngles(CarriageContraptionEntity entity, double distanceMoved) {
        double angleDiff = 360.0 * distanceMoved / (Math.PI * 2 * this.type.getWheelRadius());
        float xRot = 0.0f;
        float yRot = 0.0f;
        if (this.leading().edge == null || this.carriage.train.derailed) {
            yRot = -90.0f + entity.yaw - (float)this.derailAngle;
        } else if (!entity.field_6002.method_27983().equals(this.getDimension())) {
            yRot = -90.0f + entity.yaw;
            xRot = 0.0f;
        } else {
            class_243 positionVec = this.leading().getPosition();
            class_243 coupledVec = this.trailing().getPosition();
            double diffX = positionVec.field_1352 - coupledVec.field_1352;
            double diffY = positionVec.field_1351 - coupledVec.field_1351;
            double diffZ = positionVec.field_1350 - coupledVec.field_1350;
            yRot = AngleHelper.deg(class_3532.method_15349((double)diffZ, (double)diffX)) + 90.0f;
            xRot = AngleHelper.deg(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)));
        }
        double newWheelAngle = ((double)this.wheelAngle.getValue() - angleDiff) % 360.0;
        for (boolean twice : Iterate.trueAndFalse) {
            if (twice && !entity.firstPositionUpdate) continue;
            this.wheelAngle.setValue(newWheelAngle);
            this.pitch.setValue(xRot);
            this.yaw.setValue(-yRot);
        }
    }

    public TravellingPoint leading() {
        return (TravellingPoint)this.points.getFirst();
    }

    public TravellingPoint trailing() {
        return (TravellingPoint)this.points.getSecond();
    }

    public double getStress() {
        if (this.getDimension() == null) {
            return 0.0;
        }
        if (this.carriage.train.derailed) {
            return 0.0;
        }
        return this.type.getWheelPointSpacing() - this.leading().getPosition().method_1022(this.trailing().getPosition());
    }

    @Nullable
    public class_243 getAnchorPosition() {
        if (this.leading().edge == null) {
            return null;
        }
        return ((TravellingPoint)this.points.getFirst()).getPosition().method_1019(((TravellingPoint)this.points.getSecond()).getPosition()).method_1021(0.5);
    }

    public void updateCouplingAnchor(class_243 entityPos, float entityXRot, float entityYRot, int bogeySpacing, float partialTicks, boolean leading) {
        class_243 thisOffset = this.type.getConnectorAnchorOffset();
        thisOffset = thisOffset.method_18805(1.0, 1.0, leading ? -1.0 : 1.0);
        thisOffset = VecHelper.rotate(thisOffset, this.pitch.getValue(partialTicks), class_2350.class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, this.yaw.getValue(partialTicks), class_2350.class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, -entityYRot - 90.0f, class_2350.class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, entityXRot, class_2350.class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, -180.0, class_2350.class_2351.field_11052);
        thisOffset = thisOffset.method_1031(0.0, 0.0, leading ? 0.0 : (double)(-bogeySpacing));
        thisOffset = VecHelper.rotate(thisOffset, 180.0, class_2350.class_2351.field_11052);
        thisOffset = VecHelper.rotate(thisOffset, -entityXRot, class_2350.class_2351.field_11048);
        thisOffset = VecHelper.rotate(thisOffset, entityYRot + 90.0f, class_2350.class_2351.field_11052);
        this.couplingAnchors.set(leading, entityPos.method_1019(thisOffset));
    }

    public class_2487 write(DimensionPalette dimensions) {
        class_2487 tag = new class_2487();
        tag.method_10582("Type", RegisteredObjects.getKeyOrThrow((class_2248)this.type).toString());
        tag.method_10566("Points", (class_2520)this.points.serializeEach(tp -> tp.write(dimensions)));
        return tag;
    }

    public static CarriageBogey read(class_2487 tag, TrackGraph graph, DimensionPalette dimensions) {
        class_2960 location = new class_2960(tag.method_10558("Type"));
        IBogeyBlock type = (IBogeyBlock)class_2378.field_11146.method_10223(location);
        Couple<TravellingPoint> points = Couple.deserializeEach(tag.method_10554("Points", 10), c -> TravellingPoint.read(c, graph, dimensions));
        CarriageBogey carriageBogey = new CarriageBogey(type, (TravellingPoint)points.getFirst(), (TravellingPoint)points.getSecond());
        return carriageBogey;
    }

    public BogeyInstance createInstance(MaterialManager materialManager) {
        return this.type.createInstance(materialManager, this);
    }

    void setLeading() {
        this.isLeading = true;
    }
}

