/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.simibubi.create.AllKeys;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.TrackEdge;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackNode;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgeData;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalBoundary;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalEdgeGroup;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.TrackEdgePoint;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class TrackGraphVisualizer {
    public static void visualiseSignalEdgeGroups(TrackGraph graph) {
        class_310 mc = class_310.method_1551();
        class_1297 cameraEntity = mc.field_1719;
        if (cameraEntity == null) {
            return;
        }
        class_238 box = graph.getBounds((class_1937)mc.field_1687).box;
        if (box == null || !box.method_994(cameraEntity.method_5829().method_1014(50.0))) {
            return;
        }
        class_243 camera = cameraEntity.method_33571();
        Outliner outliner = CreateClient.OUTLINER;
        boolean ctrl = false;
        Map<UUID, SignalEdgeGroup> allGroups = Create.RAILWAYS.sided(null).signalEdgeGroups;
        float width = 0.125f;
        for (Map.Entry<TrackNodeLocation, TrackNode> nodeEntry : graph.nodes.entrySet()) {
            Map<TrackNode, TrackEdge> map;
            class_243 location;
            TrackNodeLocation nodeLocation = nodeEntry.getKey();
            TrackNode node = nodeEntry.getValue();
            if (nodeLocation == null || (location = nodeLocation.getLocation()).method_1022(camera) > 50.0 || !mc.field_1687.method_27983().equals(nodeLocation.dimension) || (map = graph.connectionsByNode.get(node)) == null) continue;
            int hashCode = node.hashCode();
            for (Map.Entry<TrackNode, TrackEdge> entry : map.entrySet()) {
                UUID singleGroup;
                SignalEdgeGroup singleEdgeGroup;
                TrackNode other = entry.getKey();
                TrackEdge edge = entry.getValue();
                EdgeData signalData = edge.getEdgeData();
                if (!edge.node1.location.dimension.equals(edge.node2.location.dimension) || other.hashCode() > hashCode && !ctrl) continue;
                class_243 yOffset = new class_243(0.0, (double)((float)(other.hashCode() > hashCode ? 6 : 5) / 64.0f), 0.0);
                class_243 startPoint = edge.getPosition(0.0);
                class_243 endPoint = edge.getPosition(1.0);
                if (!edge.isTurn()) {
                    if (signalData.hasSignalBoundaries()) {
                        double prev = 0.0;
                        double length = edge.getLength();
                        SignalBoundary prevBoundary = null;
                        SignalEdgeGroup group = null;
                        for (TrackEdgePoint trackEdgePoint : signalData.getPoints()) {
                            SignalBoundary boundary;
                            if (!(trackEdgePoint instanceof SignalBoundary)) continue;
                            prevBoundary = boundary = (SignalBoundary)trackEdgePoint;
                            group = allGroups.get(boundary.getGroup(node));
                            if (group == null) continue;
                            class_243 class_2432 = edge.getPosition(prev + (prev == 0.0 ? 0.0 : 0.0625 / length)).method_1019(yOffset);
                            prev = boundary.getLocationOn(edge) / length;
                            outliner.showLine(Pair.of(boundary, edge), class_2432, edge.getPosition(prev - 0.0625 / length).method_1019(yOffset)).colored(group.color.get()).lineWidth(width);
                        }
                        if (prevBoundary != null) {
                            group = allGroups.get(prevBoundary.getGroup(other));
                            if (group == null) continue;
                            outliner.showLine(edge, edge.getPosition(prev + 0.0625 / length).method_1019(yOffset), endPoint.method_1019(yOffset)).colored(group.color.get()).lineWidth(width);
                            continue;
                        }
                    }
                    SignalEdgeGroup signalEdgeGroup = singleEdgeGroup = (singleGroup = signalData.getEffectiveEdgeGroupId(graph)) == null ? null : allGroups.get(singleGroup);
                    if (singleEdgeGroup == null) continue;
                    outliner.showLine(edge, startPoint.method_1019(yOffset), endPoint.method_1019(yOffset)).colored(singleEdgeGroup.color.get()).lineWidth(width);
                    continue;
                }
                if (signalData.hasSignalBoundaries()) {
                    SignalEdgeGroup initialGroup;
                    UUID initialGroupId;
                    Iterator<TrackEdgePoint> points = signalData.getPoints().iterator();
                    SignalBoundary currentBoundary = null;
                    double currentBoundaryPosition = 0.0;
                    while (points.hasNext()) {
                        SignalBoundary signal;
                        TrackEdgePoint next = points.next();
                        if (!(next instanceof SignalBoundary)) continue;
                        currentBoundary = signal = (SignalBoundary)next;
                        currentBoundaryPosition = signal.getLocationOn(edge);
                        break;
                    }
                    if (currentBoundary == null || (initialGroupId = currentBoundary.getGroup(node)) == null || (initialGroup = allGroups.get(initialGroupId)) == null) continue;
                    Color currentColour = initialGroup.color.get();
                    class_243 previous = null;
                    BezierConnection turn = edge.getTurn();
                    for (int i = 0; i <= turn.getSegmentCount(); ++i) {
                        double f = (float)i * 1.0f / (float)turn.getSegmentCount();
                        double position = f * turn.getLength();
                        class_243 current = edge.getPosition(f);
                        if (previous != null) {
                            if (currentBoundary != null && position > currentBoundaryPosition) {
                                current = edge.getPosition((currentBoundaryPosition - (double)width) / turn.getLength());
                                outliner.showLine(Pair.of(edge, previous), previous.method_1019(yOffset), current.method_1019(yOffset)).colored(currentColour).lineWidth(width);
                                previous = current = edge.getPosition((currentBoundaryPosition + (double)width) / turn.getLength());
                                UUID newId = currentBoundary.getGroup(other);
                                if (newId != null && allGroups.containsKey(newId)) {
                                    currentColour = allGroups.get((Object)newId).color.get();
                                }
                                currentBoundary = null;
                                while (points.hasNext()) {
                                    SignalBoundary signal;
                                    TrackEdgePoint next = points.next();
                                    if (!(next instanceof SignalBoundary)) continue;
                                    currentBoundary = signal = (SignalBoundary)next;
                                    currentBoundaryPosition = signal.getLocationOn(edge);
                                    break;
                                }
                            }
                            outliner.showLine(Pair.of(edge, previous), previous.method_1019(yOffset), current.method_1019(yOffset)).colored(currentColour).lineWidth(width);
                        }
                        previous = current;
                    }
                }
                SignalEdgeGroup signalEdgeGroup = singleEdgeGroup = (singleGroup = signalData.getEffectiveEdgeGroupId(graph)) == null ? null : allGroups.get(singleGroup);
                if (singleEdgeGroup == null) continue;
                class_243 previous = null;
                BezierConnection turn = edge.getTurn();
                for (int i = 0; i <= turn.getSegmentCount(); ++i) {
                    class_243 current = edge.getPosition((float)i * 1.0f / (float)turn.getSegmentCount());
                    if (previous != null) {
                        outliner.showLine(Pair.of(edge, previous), previous.method_1019(yOffset), current.method_1019(yOffset)).colored(singleEdgeGroup.color.get()).lineWidth(width);
                    }
                    previous = current;
                }
            }
        }
    }

    public static void debugViewGraph(TrackGraph graph) {
        class_310 mc = class_310.method_1551();
        class_1297 cameraEntity = mc.field_1719;
        if (cameraEntity == null) {
            return;
        }
        class_238 box = graph.getBounds((class_1937)mc.field_1687).box;
        if (box == null || !box.method_994(cameraEntity.method_5829().method_1014(50.0))) {
            return;
        }
        class_243 camera = cameraEntity.method_33571();
        for (Map.Entry<TrackNodeLocation, TrackNode> nodeEntry : graph.nodes.entrySet()) {
            class_243 location;
            TrackNodeLocation nodeLocation = nodeEntry.getKey();
            TrackNode node = nodeEntry.getValue();
            if (nodeLocation == null || (location = nodeLocation.getLocation()).method_1022(camera) > 50.0 || !mc.field_1687.method_27983().equals(nodeLocation.dimension)) continue;
            class_243 yOffset = new class_243(0.0, 0.1875, 0.0);
            class_243 v1 = location.method_1019(yOffset);
            class_243 v2 = v1.method_1019(node.normal.method_1021(0.1875));
            CreateClient.OUTLINER.showLine(node.netId, v1, v2).colored(Color.mixColors(Color.WHITE, graph.color, 1.0f)).lineWidth(0.125f);
            Map<TrackNode, TrackEdge> map = graph.connectionsByNode.get(node);
            if (map == null) continue;
            int hashCode = node.hashCode();
            for (Map.Entry<TrackNode, TrackEdge> entry : map.entrySet()) {
                TrackNode other = entry.getKey();
                TrackEdge edge = entry.getValue();
                if (!edge.node1.location.dimension.equals(edge.node2.location.dimension)) {
                    v1 = location.method_1019(yOffset);
                    v2 = v1.method_1019(node.normal.method_1021(0.1875));
                    CreateClient.OUTLINER.showLine(node.netId, v1, v2).colored(Color.mixColors(Color.WHITE, graph.color, 1.0f)).lineWidth(0.25f);
                    continue;
                }
                if (other.hashCode() > hashCode && !AllKeys.isKeyDown(341)) continue;
                yOffset = new class_243(0.0, (double)((float)(other.hashCode() > hashCode ? 6 : 4) / 16.0f), 0.0);
                if (!edge.isTurn()) {
                    CreateClient.OUTLINER.showLine(edge, edge.getPosition(0.0).method_1019(yOffset), edge.getPosition(1.0).method_1019(yOffset)).colored(graph.color).lineWidth(0.0625f);
                    continue;
                }
                class_243 previous = null;
                BezierConnection turn = edge.getTurn();
                for (int i = 0; i <= turn.getSegmentCount(); ++i) {
                    class_243 current = edge.getPosition((float)i * 1.0f / (float)turn.getSegmentCount());
                    if (previous != null) {
                        CreateClient.OUTLINER.showLine(Pair.of(edge, previous), previous.method_1019(yOffset), current.method_1019(yOffset)).colored(graph.color).lineWidth(0.0625f);
                    }
                    previous = current;
                }
            }
        }
    }
}

