/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.content.logistics.trains.RailwaySavedData;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.TrackGraphSync;
import com.simibubi.create.content.logistics.trains.TrackGraphVisualizer;
import com.simibubi.create.content.logistics.trains.TrackNodeLocation;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TrainPacket;
import com.simibubi.create.content.logistics.trains.management.display.GlobalTrainDisplayData;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalEdgeGroup;
import com.simibubi.create.foundation.networking.AllPackets;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.mutable.MutableObject;

public class GlobalRailwayManager {
    public Map<UUID, TrackGraph> trackNetworks;
    public Map<UUID, SignalEdgeGroup> signalEdgeGroups;
    public Map<UUID, Train> trains;
    public TrackGraphSync sync;
    private List<Train> movingTrains;
    private List<Train> waitingTrains;
    private RailwaySavedData savedData;

    public GlobalRailwayManager() {
        this.cleanUp();
    }

    public void playerLogin(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.loadTrackData(serverPlayer.method_5682());
            this.trackNetworks.values().forEach(g -> this.sync.sendFullGraphTo((TrackGraph)g, serverPlayer));
            ArrayList<SignalEdgeGroup> asList = new ArrayList<SignalEdgeGroup>(this.signalEdgeGroups.values());
            this.sync.sendEdgeGroups(asList.stream().map(g -> g.id).toList(), asList.stream().map(g -> g.color).toList(), serverPlayer);
            for (Train train : this.trains.values()) {
                AllPackets.channel.sendToClient((S2CPacket)new TrainPacket(train, true), serverPlayer);
            }
        }
    }

    public void playerLogout(class_1657 player) {
    }

    public void levelLoaded(class_1936 level) {
        MinecraftServer server = level.method_8503();
        if (server == null || server.method_30002() != level) {
            return;
        }
        this.cleanUp();
        this.savedData = null;
        this.loadTrackData(server);
    }

    private void loadTrackData(MinecraftServer server) {
        if (this.savedData != null) {
            return;
        }
        this.savedData = RailwaySavedData.load(server);
        this.trains = this.savedData.getTrains();
        this.trackNetworks = this.savedData.getTrackNetworks();
        this.signalEdgeGroups = this.savedData.getSignalBlocks();
        this.trains.values().forEach(this.movingTrains::add);
    }

    public void cleanUp() {
        this.trackNetworks = new HashMap<UUID, TrackGraph>();
        this.signalEdgeGroups = new HashMap<UUID, SignalEdgeGroup>();
        this.trains = new HashMap<UUID, Train>();
        this.sync = new TrackGraphSync();
        this.movingTrains = new LinkedList<Train>();
        this.waitingTrains = new LinkedList<Train>();
        GlobalTrainDisplayData.statusByDestination.clear();
    }

    public void markTracksDirty() {
        if (this.savedData != null) {
            this.savedData.method_80();
        }
    }

    public void addTrain(Train train) {
        this.trains.put(train.id, train);
        this.movingTrains.add(train);
    }

    public void removeTrain(UUID id) {
        Train removed = this.trains.remove(id);
        if (removed == null) {
            return;
        }
        this.movingTrains.remove(removed);
        this.waitingTrains.remove(removed);
    }

    public TrackGraph getOrCreateGraph(UUID graphID, int netId) {
        return this.trackNetworks.computeIfAbsent(graphID, uid -> {
            TrackGraph trackGraph = new TrackGraph(graphID);
            trackGraph.netId = netId;
            return trackGraph;
        });
    }

    public void putGraphWithDefaultGroup(TrackGraph graph) {
        SignalEdgeGroup group = new SignalEdgeGroup(graph.id);
        this.signalEdgeGroups.put(graph.id, group.asFallback());
        this.sync.edgeGroupCreated(graph.id, group.color);
        this.putGraph(graph);
    }

    public void putGraph(TrackGraph graph) {
        this.trackNetworks.put(graph.id, graph);
        this.markTracksDirty();
    }

    public void removeGraphAndGroup(TrackGraph graph) {
        this.signalEdgeGroups.remove(graph.id);
        this.sync.edgeGroupRemoved(graph.id);
        this.removeGraph(graph);
    }

    public void removeGraph(TrackGraph graph) {
        this.trackNetworks.remove(graph.id);
        this.markTracksDirty();
    }

    public void updateSplitGraph(class_1936 level, TrackGraph graph) {
        Set<TrackGraph> disconnected = graph.findDisconnectedGraphs(level, null);
        disconnected.forEach(this::putGraphWithDefaultGroup);
        if (!disconnected.isEmpty()) {
            this.sync.graphSplit(graph, disconnected);
            this.markTracksDirty();
        }
    }

    @Nullable
    public TrackGraph getGraph(class_1936 level, TrackNodeLocation vertex) {
        if (this.trackNetworks == null) {
            return null;
        }
        for (TrackGraph railGraph : this.trackNetworks.values()) {
            if (railGraph.locateNode(vertex) == null) continue;
            return railGraph;
        }
        return null;
    }

    public List<TrackGraph> getGraphs(class_1936 level, TrackNodeLocation vertex) {
        if (this.trackNetworks == null) {
            return Collections.emptyList();
        }
        ArrayList<TrackGraph> intersecting = new ArrayList<TrackGraph>();
        for (TrackGraph railGraph : this.trackNetworks.values()) {
            if (railGraph.locateNode(vertex) == null) continue;
            intersecting.add(railGraph);
        }
        return intersecting;
    }

    public void tick(class_1937 level) {
        if (level.method_27983() != class_1937.field_25179) {
            return;
        }
        for (SignalEdgeGroup group : this.signalEdgeGroups.values()) {
            group.trains.clear();
            group.reserved = null;
        }
        for (TrackGraph graph : this.trackNetworks.values()) {
            graph.tickPoints(true);
            graph.resolveIntersectingEdgeGroups(level);
        }
        this.tickTrains(level);
        for (TrackGraph graph : this.trackNetworks.values()) {
            graph.tickPoints(false);
        }
        boolean bl = GlobalTrainDisplayData.updateTick = level.method_8510() % 100L == 0L;
        if (GlobalTrainDisplayData.updateTick) {
            GlobalTrainDisplayData.refresh();
        }
    }

    private void tickTrains(class_1937 level) {
        Train train2;
        for (Train train2 : this.waitingTrains) {
            train2.earlyTick(level);
        }
        for (Train train2 : this.movingTrains) {
            train2.earlyTick(level);
        }
        for (Train train2 : this.waitingTrains) {
            train2.tick(level);
        }
        for (Train train2 : this.movingTrains) {
            train2.tick(level);
        }
        Iterator<Train> iterator = this.waitingTrains.iterator();
        while (iterator.hasNext()) {
            train2 = iterator.next();
            if (train2.invalid) {
                iterator.remove();
                this.trains.remove(train2.id);
                AllPackets.channel.sendToClientsInCurrentServer((S2CPacket)new TrainPacket(train2, false));
                continue;
            }
            if (train2.navigation.waitingForSignal != null) continue;
            this.movingTrains.add(train2);
            iterator.remove();
        }
        iterator = this.movingTrains.iterator();
        while (iterator.hasNext()) {
            train2 = iterator.next();
            if (train2.invalid) {
                iterator.remove();
                this.trains.remove(train2.id);
                AllPackets.channel.sendToClientsInCurrentServer((S2CPacket)new TrainPacket(train2, false));
                continue;
            }
            if (train2.navigation.waitingForSignal == null) continue;
            this.waitingTrains.add(train2);
            iterator.remove();
        }
    }

    public void tickSignalOverlay() {
        if (!KineticDebugger.isActive()) {
            for (TrackGraph trackGraph : this.trackNetworks.values()) {
                TrackGraphVisualizer.visualiseSignalEdgeGroups(trackGraph);
            }
        }
    }

    public void clientTick() {
        if (KineticDebugger.isActive()) {
            for (TrackGraph trackGraph : this.trackNetworks.values()) {
                TrackGraphVisualizer.debugViewGraph(trackGraph);
            }
        }
    }

    public GlobalRailwayManager sided(class_1936 level) {
        if (level != null && !level.method_8608()) {
            return this;
        }
        MutableObject m = new MutableObject();
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.clientManager((MutableObject<GlobalRailwayManager>)m));
        return (GlobalRailwayManager)m.getValue();
    }

    @Environment(value=EnvType.CLIENT)
    private void clientManager(MutableObject<GlobalRailwayManager> m) {
        m.setValue((Object)CreateClient.RAILWAYS);
    }
}

