/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.google.gson.JsonParseException;
import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ItemNameAttribute
implements ItemAttribute {
    String itemName;

    public ItemNameAttribute(String itemName) {
        this.itemName = itemName;
    }

    @Override
    public boolean appliesTo(class_1799 itemStack) {
        return this.extractCustomName(itemStack).equals(this.itemName);
    }

    @Override
    public List<ItemAttribute> listAttributesOf(class_1799 itemStack) {
        String name = this.extractCustomName(itemStack);
        ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
        if (name.length() > 0) {
            atts.add(new ItemNameAttribute(name));
        }
        return atts;
    }

    @Override
    public String getTranslationKey() {
        return "has_name";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{this.itemName};
    }

    @Override
    public void writeNBT(class_2487 nbt) {
        nbt.method_10582("name", this.itemName);
    }

    @Override
    public ItemAttribute readNBT(class_2487 nbt) {
        return new ItemNameAttribute(nbt.method_10558("name"));
    }

    private String extractCustomName(class_1799 stack) {
        class_2487 compoundnbt = stack.method_7941("display");
        if (compoundnbt != null && compoundnbt.method_10573("Name", 8)) {
            try {
                class_5250 itextcomponent = class_2561.class_2562.method_10877((String)compoundnbt.method_10558("Name"));
                if (itextcomponent != null) {
                    return itextcomponent.getString();
                }
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        return "";
    }
}

