/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.MountedFluidStorage;
import com.simibubi.create.content.contraptions.components.structureMovement.MountedStorage;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.utility.NBTHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3499;

public class MountedStorageManager {
    protected Contraption.ContraptionInvWrapper inventory;
    protected Contraption.ContraptionInvWrapper fuelInventory;
    protected CombinedTankWrapper fluidInventory;
    protected Map<class_2338, MountedStorage> storage = new HashMap<class_2338, MountedStorage>();
    protected Map<class_2338, MountedFluidStorage> fluidStorage = new HashMap<class_2338, MountedFluidStorage>();

    public void entityTick(AbstractContraptionEntity entity) {
        this.fluidStorage.forEach((pos, mfs) -> mfs.tick(entity, (class_2338)pos, entity.field_6002.field_9236));
    }

    public void createHandlers() {
        Collection<MountedStorage> itemHandlers = this.storage.values();
        this.inventory = this.wrapItems(itemHandlers.stream().map(MountedStorage::getItemHandler).toList(), false);
        this.fuelInventory = this.wrapItems(itemHandlers.stream().filter(MountedStorage::canUseForFuel).map(MountedStorage::getItemHandler).toList(), true);
        this.fluidInventory = this.wrapFluids(this.fluidStorage.values().stream().map(MountedFluidStorage::getFluidHandler).collect(Collectors.toList()));
    }

    protected Contraption.ContraptionInvWrapper wrapItems(Collection<Storage<ItemVariant>> list, boolean fuel) {
        return new Contraption.ContraptionInvWrapper((Storage[])Arrays.copyOf(list.toArray(), list.size(), Storage[].class));
    }

    protected CombinedTankWrapper wrapFluids(Collection<Storage<FluidVariant>> list) {
        return new CombinedTankWrapper((Storage[])Arrays.copyOf(list.toArray(), list.size(), SmartFluidTank[].class));
    }

    public void addBlock(class_2338 localPos, class_2586 te) {
        if (te != null && MountedStorage.canUseAsStorage(te)) {
            this.storage.put(localPos, new MountedStorage(te));
        }
        if (te != null && MountedFluidStorage.canUseAsStorage(te)) {
            this.fluidStorage.put(localPos, new MountedFluidStorage(te));
        }
    }

    public void read(class_2487 nbt, Map<class_2338, class_2586> presentTileEntities, boolean clientPacket) {
        this.storage.clear();
        NBTHelper.iterateCompoundList(nbt.method_10554("Storage", 10), c -> this.storage.put(class_2512.method_10691((class_2487)c.method_10562("Pos")), MountedStorage.deserialize(c.method_10562("Data"))));
        this.fluidStorage.clear();
        NBTHelper.iterateCompoundList(nbt.method_10554("FluidStorage", 10), c -> this.fluidStorage.put(class_2512.method_10691((class_2487)c.method_10562("Pos")), MountedFluidStorage.deserialize(c.method_10562("Data"))));
        if (clientPacket && presentTileEntities != null) {
            this.bindTanks(presentTileEntities);
        }
        ArrayList<Storage<ItemVariant>> handlers = new ArrayList<Storage<ItemVariant>>();
        ArrayList<Storage<ItemVariant>> fuelHandlers = new ArrayList<Storage<ItemVariant>>();
        for (MountedStorage mountedStorage : this.storage.values()) {
            Storage<ItemVariant> itemHandler = mountedStorage.getItemHandler();
            handlers.add(itemHandler);
            if (!mountedStorage.canUseForFuel()) continue;
            fuelHandlers.add(itemHandler);
        }
        this.inventory = this.wrapItems(handlers, false);
        this.fuelInventory = this.wrapItems(fuelHandlers, true);
        this.fluidInventory = this.wrapFluids(this.fluidStorage.values().stream().map(MountedFluidStorage::getFluidHandler).map(tank -> tank).toList());
    }

    public void bindTanks(Map<class_2338, class_2586> presentTileEntities) {
        this.fluidStorage.forEach((pos, mfs) -> {
            class_2586 tileEntity = (class_2586)presentTileEntities.get(pos);
            if (!(tileEntity instanceof FluidTankTileEntity)) {
                return;
            }
            FluidTankTileEntity tank = (FluidTankTileEntity)tileEntity;
            FluidTank tankInventory = tank.getTankInventory();
            if (tankInventory instanceof FluidTank) {
                tankInventory.setFluid(mfs.tank.getFluid());
            }
            tank.getFluidLevel().startWithValue(tank.getFillState());
            mfs.assignTileEntity(tank);
        });
    }

    public void write(class_2487 nbt, boolean clientPacket) {
        class_2499 storageNBT = new class_2499();
        if (!clientPacket) {
            for (class_2338 pos : this.storage.keySet()) {
                class_2487 c = new class_2487();
                MountedStorage mountedStorage = this.storage.get(pos);
                if (!mountedStorage.isValid()) continue;
                c.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)pos));
                c.method_10566("Data", (class_2520)mountedStorage.serialize());
                storageNBT.add((Object)c);
            }
        }
        class_2499 fluidStorageNBT = new class_2499();
        for (class_2338 pos : this.fluidStorage.keySet()) {
            class_2487 c = new class_2487();
            MountedFluidStorage mountedStorage = this.fluidStorage.get(pos);
            if (!mountedStorage.isValid()) continue;
            c.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)pos));
            c.method_10566("Data", (class_2520)mountedStorage.serialize());
            fluidStorageNBT.add((Object)c);
        }
        nbt.method_10566("Storage", (class_2520)storageNBT);
        nbt.method_10566("FluidStorage", (class_2520)fluidStorageNBT);
    }

    public void removeStorageFromWorld() {
        this.storage.values().forEach(MountedStorage::removeStorageFromWorld);
        this.fluidStorage.values().forEach(MountedFluidStorage::removeStorageFromWorld);
    }

    public void addStorageToWorld(class_3499.class_3501 block, class_2586 tileEntity) {
        Object mountedStorage;
        if (this.storage.containsKey(block.field_15597) && ((MountedStorage)(mountedStorage = this.storage.get(block.field_15597))).isValid()) {
            ((MountedStorage)mountedStorage).addStorageToWorld(tileEntity);
        }
        if (this.fluidStorage.containsKey(block.field_15597) && ((MountedFluidStorage)(mountedStorage = this.fluidStorage.get(block.field_15597))).isValid()) {
            ((MountedFluidStorage)mountedStorage).addStorageToWorld(tileEntity);
        }
    }

    public void clear() {
        for (Storage storage : this.inventory.parts) {
            if (storage instanceof Contraption.ContraptionInvWrapper) {
                Contraption.ContraptionInvWrapper wrapper = (Contraption.ContraptionInvWrapper)storage;
                if (wrapper.isExternal) continue;
            }
            TransferUtil.clearStorage((Storage)storage);
        }
        TransferUtil.clearStorage((Storage)this.fluidInventory);
    }

    public void updateContainedFluid(class_2338 localPos, FluidStack containedFluid) {
        MountedFluidStorage mountedFluidStorage = this.fluidStorage.get(localPos);
        if (mountedFluidStorage != null) {
            mountedFluidStorage.updateFluid(containedFluid);
        }
    }

    public void attachExternal(Storage<ItemVariant> externalStorage) {
        this.inventory = new Contraption.ContraptionInvWrapper(new Storage[]{externalStorage, this.inventory});
        this.fuelInventory = new Contraption.ContraptionInvWrapper(new Storage[]{externalStorage, this.fuelInventory});
    }

    public Contraption.ContraptionInvWrapper getItems() {
        return this.inventory;
    }

    public Contraption.ContraptionInvWrapper getFuelItems() {
        return this.fuelInventory;
    }

    public CombinedTankWrapper getFluids() {
        return this.fluidInventory;
    }
}

