/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.steam;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.content.contraptions.components.steam.PoweredShaftTileEntity;
import com.simibubi.create.content.contraptions.components.steam.SteamEngineBlock;
import com.simibubi.create.content.contraptions.components.steam.SteamEngineValueBox;
import com.simibubi.create.content.contraptions.components.steam.SteamJetParticleData;
import com.simibubi.create.content.contraptions.components.structureMovement.bearing.WindmillBearingTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.tterrag.registrate.fabric.EnvExecutor;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class SteamEngineTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation {
    protected ScrollOptionBehaviour<WindmillBearingTileEntity.RotationDirection> movementDirection;
    public WeakReference<PoweredShaftTileEntity> target;
    public WeakReference<FluidTankTileEntity> source = new WeakReference<Object>(null);
    float prevAngle = 0.0f;

    public SteamEngineTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.target = new WeakReference<Object>(null);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.movementDirection = new ScrollOptionBehaviour<WindmillBearingTileEntity.RotationDirection>(WindmillBearingTileEntity.RotationDirection.class, (class_2561)Lang.translateDirect("contraptions.windmill.rotation_direction", new Object[0]), this, new SteamEngineValueBox());
        this.movementDirection.requiresWrench();
        this.movementDirection.onlyActiveWhen(() -> {
            PoweredShaftTileEntity shaft = this.getShaft();
            return shaft == null || !shaft.hasSource();
        });
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add(this.movementDirection);
        this.registerAwardables(behaviours, AllAdvancements.STEAM_ENGINE);
    }

    private void onDirectionChanged() {
    }

    @Override
    public void tick() {
        int conveyedSpeedLevel;
        float efficiency;
        super.tick();
        FluidTankTileEntity tank = this.getTank();
        PoweredShaftTileEntity shaft = this.getShaft();
        if (tank == null || shaft == null) {
            if (this.field_11863.method_8608()) {
                return;
            }
            if (shaft == null) {
                return;
            }
            if (!shaft.method_11016().method_10059((class_2382)this.field_11867).equals((Object)shaft.enginePos)) {
                return;
            }
            if (shaft.engineEfficiency == 0.0f) {
                return;
            }
            class_2350 facing = SteamEngineBlock.getFacing(this.method_11010());
            if (this.field_11863.method_8477(this.field_11867.method_10093(facing.method_10153()))) {
                shaft.update(this.field_11867, 0, 0.0f);
            }
            return;
        }
        boolean verticalTarget = false;
        class_2680 shaftState = shaft.method_11010();
        class_2350.class_2351 targetAxis = class_2350.class_2351.field_11048;
        class_2248 class_22482 = shaftState.method_26204();
        if (class_22482 instanceof IRotate) {
            IRotate ir = (IRotate)class_22482;
            targetAxis = ir.getRotationAxis(shaftState);
        }
        verticalTarget = targetAxis == class_2350.class_2351.field_11052;
        class_2680 blockState = this.method_11010();
        if (!AllBlocks.STEAM_ENGINE.has(blockState)) {
            return;
        }
        class_2350 facing = SteamEngineBlock.getFacing(blockState);
        if (facing.method_10166() == class_2350.class_2351.field_11052) {
            facing = (class_2350)blockState.method_11654((class_2769)SteamEngineBlock.field_11177);
        }
        if ((efficiency = class_3532.method_15363((float)tank.boiler.getEngineEfficiency(tank.getTotalTankSize()), (float)0.0f, (float)1.0f)) > 0.0f) {
            this.award(AllAdvancements.STEAM_ENGINE);
        }
        int n = efficiency == 0.0f ? 1 : (conveyedSpeedLevel = verticalTarget ? 1 : (int)GeneratingKineticTileEntity.convertToDirection(1.0f, facing));
        if (targetAxis == class_2350.class_2351.field_11051) {
            conveyedSpeedLevel *= -1;
        }
        if (this.movementDirection.get() == WindmillBearingTileEntity.RotationDirection.COUNTER_CLOCKWISE) {
            conveyedSpeedLevel *= -1;
        }
        float shaftSpeed = shaft.getTheoreticalSpeed();
        if (shaft.hasSource() && shaftSpeed != 0.0f && conveyedSpeedLevel != 0 && shaftSpeed > 0.0f != conveyedSpeedLevel > 0) {
            this.movementDirection.setValue(1 - this.movementDirection.get().ordinal());
            conveyedSpeedLevel *= -1;
        }
        shaft.update(this.field_11867, conveyedSpeedLevel, efficiency);
        if (!this.field_11863.field_9236) {
            return;
        }
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> this::spawnParticles);
    }

    @Override
    protected void setRemovedNotDueToChunkUnload() {
        PoweredShaftTileEntity shaft = this.getShaft();
        if (shaft != null) {
            shaft.remove(this.field_11867);
        }
        super.setRemovedNotDueToChunkUnload();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(2.0);
    }

    public PoweredShaftTileEntity getShaft() {
        PoweredShaftTileEntity shaft = (PoweredShaftTileEntity)this.target.get();
        if (shaft == null || shaft.method_11015() || !shaft.canBePoweredBy(this.field_11867)) {
            PoweredShaftTileEntity ps;
            class_2350 facing;
            class_2586 anyShaftAt;
            if (shaft != null) {
                this.target = new WeakReference<Object>(null);
            }
            if ((anyShaftAt = this.field_11863.method_8321(this.field_11867.method_10079(facing = SteamEngineBlock.getFacing(this.method_11010()), 2))) instanceof PoweredShaftTileEntity && (ps = (PoweredShaftTileEntity)anyShaftAt).canBePoweredBy(this.field_11867)) {
                shaft = ps;
                this.target = new WeakReference<PoweredShaftTileEntity>(shaft);
            }
        }
        return shaft;
    }

    public FluidTankTileEntity getTank() {
        FluidTankTileEntity tank = (FluidTankTileEntity)this.source.get();
        if (tank == null || tank.method_11015()) {
            class_2350 facing;
            class_2586 be;
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.field_11863.method_8321(this.field_11867.method_10093((facing = SteamEngineBlock.getFacing(this.method_11010())).method_10153()))) instanceof FluidTankTileEntity) {
                FluidTankTileEntity tankTe;
                tank = tankTe = (FluidTankTileEntity)be;
                this.source = new WeakReference<FluidTankTileEntity>(tank);
            }
        }
        if (tank == null) {
            return null;
        }
        return tank.getControllerTE();
    }

    @Environment(value=EnvType.CLIENT)
    private void spawnParticles() {
        FluidTankTileEntity controller;
        float angle;
        Float targetAngle = this.getTargetAngle();
        PoweredShaftTileEntity ste = (PoweredShaftTileEntity)this.target.get();
        if (ste == null) {
            return;
        }
        if (!ste.isPoweredBy(this.field_11867) || ste.engineEfficiency == 0.0f) {
            return;
        }
        if (targetAngle == null) {
            return;
        }
        angle += (angle = AngleHelper.deg(targetAngle.floatValue())) < 0.0f ? -105.0f : 285.0f;
        angle %= 360.0f;
        PoweredShaftTileEntity shaft = this.getShaft();
        if (shaft == null || shaft.getSpeed() == 0.0f) {
            return;
        }
        if (!(!(angle >= 0.0f) || this.prevAngle > 180.0f && angle < 180.0f)) {
            this.prevAngle = angle;
            return;
        }
        if (!(!(angle < 0.0f) || this.prevAngle < -180.0f && angle > -180.0f)) {
            this.prevAngle = angle;
            return;
        }
        FluidTankTileEntity sourceTE = (FluidTankTileEntity)this.source.get();
        if (sourceTE != null && (controller = sourceTE.getControllerTE()) != null && controller.boiler != null) {
            float volume = 3.0f / (float)Math.max(2, controller.boiler.attachedEngines / 6);
            float pitch = 1.18f - this.field_11863.field_9229.nextFloat() * 0.25f;
            this.field_11863.method_8486((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), class_3417.field_26955, class_3419.field_15245, volume, pitch, false);
            AllSoundEvents.STEAM.playAt(this.field_11863, (class_2382)this.field_11867, volume / 16.0f, 0.8f, false);
        }
        class_2350 facing = SteamEngineBlock.getFacing(this.method_11010());
        for (int i = 0; i < 2; ++i) {
            class_243 offset = VecHelper.rotate(new class_243(0.0, 0.0, 1.0).method_1019(VecHelper.offsetRandomly(class_243.field_1353, this.field_11863.field_9229, 1.0f).method_18805(1.0, 1.0, 0.0).method_1029().method_1021(0.5)), AngleHelper.verticalAngle(facing), class_2350.class_2351.field_11048);
            offset = VecHelper.rotate(offset, AngleHelper.horizontalAngle(facing), class_2350.class_2351.field_11052);
            class_243 v = offset.method_1021(0.5).method_1019(class_243.method_24953((class_2382)this.field_11867));
            class_243 m = offset.method_1020(class_243.method_24954((class_2382)facing.method_10163()).method_1021(0.75));
            this.field_11863.method_8406((class_2394)new SteamJetParticleData(1.0f), v.field_1352, v.field_1351, v.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
        this.prevAngle = angle;
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public Float getTargetAngle() {
        float angle = 0.0f;
        class_2680 blockState = this.method_11010();
        if (!AllBlocks.STEAM_ENGINE.has(blockState)) {
            return null;
        }
        class_2350 facing = SteamEngineBlock.getFacing(blockState);
        PoweredShaftTileEntity shaft = this.getShaft();
        class_2350.class_2351 facingAxis = facing.method_10166();
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        if (shaft == null) {
            return null;
        }
        axis = KineticTileEntityRenderer.getRotationAxisOf(shaft);
        angle = KineticTileEntityRenderer.getAngleForTe(shaft, shaft.method_11016(), axis);
        if (axis == facingAxis) {
            return null;
        }
        if (axis.method_10179() && facingAxis == class_2350.class_2351.field_11048 ^ facing.method_10171() == class_2350.class_2352.field_11056) {
            angle *= -1.0f;
        }
        if (axis == class_2350.class_2351.field_11048 && facing == class_2350.field_11033) {
            angle *= -1.0f;
        }
        return Float.valueOf(angle);
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        PoweredShaftTileEntity shaft = this.getShaft();
        return shaft == null ? false : shaft.addToEngineTooltip(tooltip, isPlayerSneaking);
    }
}

