/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.press;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressBlock;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.components.press.PressingBehaviour;
import com.simibubi.create.content.contraptions.relays.encased.ShaftInstance;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_2350;

public class PressInstance
extends ShaftInstance
implements DynamicInstance {
    private final OrientedData pressHead;
    private final MechanicalPressTileEntity press;

    public PressInstance(MaterialManager dispatcher, MechanicalPressTileEntity tile) {
        super(dispatcher, tile);
        this.press = tile;
        this.pressHead = (OrientedData)dispatcher.defaultSolid().material(Materials.ORIENTED).getModel(AllBlockPartials.MECHANICAL_PRESS_HEAD, this.blockState).createInstance();
        class_1158 q = class_1160.field_20705.method_23214(AngleHelper.horizontalAngle((class_2350)this.blockState.method_11654(MechanicalPressBlock.HORIZONTAL_FACING)));
        this.pressHead.setRotation(q);
        this.transformModels();
    }

    public void beginFrame() {
        this.transformModels();
    }

    private void transformModels() {
        float renderedHeadOffset = this.getRenderedHeadOffset(this.press);
        this.pressHead.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    private float getRenderedHeadOffset(MechanicalPressTileEntity press) {
        PressingBehaviour pressingBehaviour = press.getPressingBehaviour();
        return pressingBehaviour.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks()) * pressingBehaviour.mode.headOffset;
    }

    @Override
    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.pressHead});
    }

    @Override
    public void remove() {
        super.remove();
        this.pressHead.delete();
    }
}

