/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.mixer;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.components.mixer.MixingRecipe;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.fluids.FluidFX;
import com.simibubi.create.content.contraptions.fluids.recipe.PotionMixingRecipes;
import com.simibubi.create.content.contraptions.processing.BasinOperatingTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3955;

public class MechanicalMixerTileEntity
extends BasinOperatingTileEntity {
    private static final Object shapelessOrMixingRecipesKey = new Object();
    public int runningTicks;
    public int processingTicks;
    public boolean running;

    public MechanicalMixerTileEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.running) {
            if (this.runningTicks < 20) {
                int localTick = this.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - class_3532.method_15362((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.runningTicks <= 20) {
                offset = 1.0f;
            } else {
                int localTick = 40 - this.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - class_3532.method_15362((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    public float getRenderedHeadRotationSpeed(float partialTicks) {
        float speed = this.getSpeed();
        if (this.running) {
            if (this.runningTicks < 15) {
                return speed;
            }
            if (this.runningTicks <= 20) {
                return speed * 2.0f;
            }
            return speed;
        }
        return speed / 2.0f;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.MIXER);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1012(0.0, -1.5, 0.0);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.running = compound.method_10577("Running");
        this.runningTicks = compound.method_10550("Ticks");
        super.read(compound, clientPacket);
        if (clientPacket && this.method_11002()) {
            this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(this.running && this.runningTicks <= 20));
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10556("Running", this.running);
        compound.method_10569("Ticks", this.runningTicks);
        super.write(compound, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.runningTicks >= 40) {
            this.running = false;
            this.runningTicks = 0;
            this.basinChecker.scheduleUpdate();
            return;
        }
        float speed = Math.abs(this.getSpeed());
        if (this.running && this.field_11863 != null) {
            if (this.field_11863.field_9236 && this.runningTicks == 20) {
                this.renderParticles();
            }
            if ((!this.field_11863.field_9236 || this.isVirtual()) && this.runningTicks == 20) {
                if (this.processingTicks < 0) {
                    Couple<SmartFluidTankBehaviour> tanks;
                    int t;
                    float recipeSpeed = 1.0f;
                    if (this.currentRecipe instanceof ProcessingRecipe && (t = ((ProcessingRecipe)this.currentRecipe).getProcessingDuration()) != 0) {
                        recipeSpeed = (float)t / 100.0f;
                    }
                    this.processingTicks = class_3532.method_15340((int)(class_3532.method_15351((int)((int)(512.0f / speed))) * class_3532.method_15386((float)(recipeSpeed * 15.0f)) + 1), (int)1, (int)512);
                    Optional<BasinTileEntity> basin = this.getBasin();
                    if (!(!basin.isPresent() || ((SmartFluidTankBehaviour)(tanks = basin.get().getTanks()).getFirst()).isEmpty() && ((SmartFluidTankBehaviour)tanks.getSecond()).isEmpty())) {
                        this.field_11863.method_8396(null, this.field_11867, class_3417.field_14650, class_3419.field_15245, 0.75f, speed < 65.0f ? 0.75f : 1.5f);
                    }
                } else {
                    --this.processingTicks;
                    if (this.processingTicks == 0) {
                        ++this.runningTicks;
                        this.processingTicks = -1;
                        this.applyBasinRecipe();
                        this.sendData();
                    }
                }
            }
            if (this.runningTicks != 20) {
                ++this.runningTicks;
            }
        }
    }

    public void renderParticles() {
        Optional<BasinTileEntity> basin = this.getBasin();
        if (!basin.isPresent() || this.field_11863 == null) {
            return;
        }
        for (SmartInventory inv : basin.get().getInvs()) {
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                class_1799 stackInSlot = inv.method_5438(slot);
                if (stackInSlot.method_7960()) continue;
                class_2392 data = new class_2392(class_2398.field_11218, stackInSlot);
                this.spillParticle((class_2394)data);
            }
        }
        for (SmartFluidTankBehaviour behaviour : basin.get().getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                this.spillParticle(FluidFX.getFluidParticle(tankSegment.getRenderedFluid()));
            }
        }
    }

    protected void spillParticle(class_2394 data) {
        float angle = this.field_11863.field_9229.nextFloat() * 360.0f;
        class_243 offset = new class_243(0.0, 0.0, 0.25);
        offset = VecHelper.rotate(offset, angle, class_2350.class_2351.field_11052);
        class_243 target = VecHelper.rotate(offset, this.getSpeed() > 0.0f ? 25.0 : -25.0, class_2350.class_2351.field_11052).method_1031(0.0, 0.25, 0.0);
        class_243 center = offset.method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
        target = VecHelper.offsetRandomly(target.method_1020(offset), this.field_11863.field_9229, 0.0078125f);
        this.field_11863.method_8406(data, center.field_1352, center.field_1351 - 1.75, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    @Override
    protected List<class_1860<?>> getMatchingRecipes() {
        List<class_1860<?>> matchingRecipes = super.getMatchingRecipes();
        Optional<BasinTileEntity> basin = this.getBasin();
        if (!basin.isPresent()) {
            return matchingRecipes;
        }
        Storage<ItemVariant> availableItems = basin.get().getItemStorage(null);
        if (availableItems == null) {
            return matchingRecipes;
        }
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : availableItems.iterable((TransactionContext)t)) {
                List<MixingRecipe> list;
                if (view.isResourceBlank() || (list = PotionMixingRecipes.BY_ITEM.get(((ItemVariant)view.getResource()).getItem())) == null) continue;
                for (MixingRecipe mixingRecipe : list) {
                    if (!this.matchBasinRecipe(mixingRecipe)) continue;
                    matchingRecipes.add(mixingRecipe);
                }
            }
        }
        return matchingRecipes;
    }

    @Override
    protected <C extends class_1263> boolean matchStaticFilters(class_1860<C> r) {
        return r instanceof class_3955 && !(r instanceof class_1869) && (Boolean)AllConfigs.SERVER.recipes.allowShapelessInMixer.get() != false && r.method_8117().size() > 1 && !MechanicalPressTileEntity.canCompress(r) && !AllRecipeTypes.shouldIgnoreInAutomation(r) || r.method_17716() == AllRecipeTypes.MIXING.getType();
    }

    @Override
    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        this.runningTicks = 0;
    }

    @Override
    public boolean continueWithPreviousRecipe() {
        this.runningTicks = 20;
        return true;
    }

    @Override
    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    @Override
    protected Object getRecipeCacheKey() {
        return shapelessOrMixingRecipesKey;
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    @Override
    protected Optional<CreateAdvancement> getProcessedRecipeTrigger() {
        return Optional.of(AllAdvancements.MIXER);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        boolean slow;
        super.tickAudio();
        boolean bl = slow = Math.abs(this.getSpeed()) < 65.0f;
        if (slow && AnimationTickHolder.getTicks() % 2 == 0) {
            return;
        }
        if (this.runningTicks == 20) {
            AllSoundEvents.MIXING.playAt(this.field_11863, (class_2382)this.field_11867, 0.75f, 1.0f, true);
        }
    }
}

