/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.SpeedControllerBlock;
import com.simibubi.create.content.contraptions.relays.advanced.SpeedControllerTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.content.contraptions.relays.encased.DirectionalShaftHalvesTileEntity;
import com.simibubi.create.content.contraptions.relays.encased.EncasedBeltBlock;
import com.simibubi.create.content.contraptions.relays.encased.SplitShaftTileEntity;
import com.simibubi.create.content.contraptions.relays.gearbox.GearboxTileEntity;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Iterate;
import io.github.fabricators_of_create.porting_lib.util.LevelUtil;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4538;

public class RotationPropagator {
    private static final int MAX_FLICKER_SCORE = 128;

    private static float getRotationSpeedModifier(KineticTileEntity from, KineticTileEntity to) {
        boolean connectedByGears;
        class_2680 stateFrom = from.method_11010();
        class_2680 stateTo = to.method_11010();
        class_2248 fromBlock = stateFrom.method_26204();
        class_2248 toBlock = stateTo.method_26204();
        if (!(fromBlock instanceof IRotate) || !(toBlock instanceof IRotate)) {
            return 0.0f;
        }
        IRotate definitionFrom = (IRotate)fromBlock;
        IRotate definitionTo = (IRotate)toBlock;
        class_2338 diff = to.method_11016().method_10059((class_2382)from.method_11016());
        class_2350 direction = class_2350.method_10147((float)diff.method_10263(), (float)diff.method_10264(), (float)diff.method_10260());
        class_1937 world = from.method_10997();
        boolean alignedAxes = true;
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            if (axis == direction.method_10166() || axis.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260()) == 0) continue;
            alignedAxes = false;
        }
        boolean connectedByAxis = alignedAxes && definitionFrom.hasShaftTowards((class_4538)world, from.method_11016(), stateFrom, direction) && definitionTo.hasShaftTowards((class_4538)world, to.method_11016(), stateTo, direction.method_10153());
        float custom = from.propagateRotationTo(to, stateFrom, stateTo, diff, connectedByAxis, connectedByGears = ICogWheel.isSmallCog(stateFrom) && ICogWheel.isSmallCog(stateTo));
        if (custom != 0.0f) {
            return custom;
        }
        if (connectedByAxis) {
            float axisModifier = RotationPropagator.getAxisModifier(to, direction.method_10153());
            if (axisModifier != 0.0f) {
                axisModifier = 1.0f / axisModifier;
            }
            return RotationPropagator.getAxisModifier(from, direction) * axisModifier;
        }
        if (fromBlock instanceof EncasedBeltBlock && toBlock instanceof EncasedBeltBlock) {
            boolean connected = EncasedBeltBlock.areBlocksConnected(stateFrom, stateTo, direction);
            return connected ? EncasedBeltBlock.getRotationSpeedModifier(from, to) : 0.0f;
        }
        if (RotationPropagator.isLargeToLargeGear(stateFrom, stateTo, diff)) {
            class_2350.class_2351 sourceAxis = (class_2350.class_2351)stateFrom.method_11654((class_2769)class_2741.field_12496);
            class_2350.class_2351 targetAxis = (class_2350.class_2351)stateTo.method_11654((class_2769)class_2741.field_12496);
            int sourceAxisDiff = sourceAxis.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260());
            int targetAxisDiff = targetAxis.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260());
            return sourceAxisDiff > 0 ^ targetAxisDiff > 0 ? -1.0f : 1.0f;
        }
        if (ICogWheel.isLargeCog(stateFrom) && ICogWheel.isSmallCog(stateTo) && RotationPropagator.isLargeToSmallCog(stateFrom, stateTo, definitionTo, diff)) {
            return -2.0f;
        }
        if (ICogWheel.isLargeCog(stateTo) && ICogWheel.isSmallCog(stateFrom) && RotationPropagator.isLargeToSmallCog(stateTo, stateFrom, definitionFrom, diff)) {
            return -0.5f;
        }
        if (connectedByGears) {
            if (diff.method_19455((class_2382)class_2338.field_10980) != 1) {
                return 0.0f;
            }
            if (ICogWheel.isLargeCog(stateTo)) {
                return 0.0f;
            }
            if (direction.method_10166() == definitionFrom.getRotationAxis(stateFrom)) {
                return 0.0f;
            }
            if (definitionFrom.getRotationAxis(stateFrom) == definitionTo.getRotationAxis(stateTo)) {
                return -1.0f;
            }
        }
        return 0.0f;
    }

    private static float getConveyedSpeed(KineticTileEntity from, KineticTileEntity to) {
        class_2680 stateTo;
        class_2680 stateFrom = from.method_11010();
        if (RotationPropagator.isLargeCogToSpeedController(stateFrom, stateTo = to.method_11010(), to.method_11016().method_10059((class_2382)from.method_11016()))) {
            return SpeedControllerTileEntity.getConveyedSpeed(from, to, true);
        }
        if (RotationPropagator.isLargeCogToSpeedController(stateTo, stateFrom, from.method_11016().method_10059((class_2382)to.method_11016()))) {
            return SpeedControllerTileEntity.getConveyedSpeed(to, from, false);
        }
        float rotationSpeedModifier = RotationPropagator.getRotationSpeedModifier(from, to);
        return from.getTheoreticalSpeed() * rotationSpeedModifier;
    }

    private static boolean isLargeToLargeGear(class_2680 from, class_2680 to, class_2338 diff) {
        class_2350.class_2351 toAxis;
        if (!ICogWheel.isLargeCog(from) || !ICogWheel.isLargeCog(to)) {
            return false;
        }
        class_2350.class_2351 fromAxis = (class_2350.class_2351)from.method_11654((class_2769)class_2741.field_12496);
        if (fromAxis == (toAxis = (class_2350.class_2351)to.method_11654((class_2769)class_2741.field_12496))) {
            return false;
        }
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            int axisDiff = axis.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260());
            if (!(axis == fromAxis || axis == toAxis ? axisDiff == 0 : axisDiff != 0)) continue;
            return false;
        }
        return true;
    }

    private static float getAxisModifier(KineticTileEntity te, class_2350 direction) {
        if (!te.hasSource() && !te.isSource() || !(te instanceof DirectionalShaftHalvesTileEntity)) {
            return 1.0f;
        }
        class_2350 source = ((DirectionalShaftHalvesTileEntity)te).getSourceFacing();
        if (te instanceof GearboxTileEntity) {
            return direction.method_10166() == source.method_10166() ? (direction == source ? 1.0f : -1.0f) : (direction.method_10171() == source.method_10171() ? -1.0f : 1.0f);
        }
        if (te instanceof SplitShaftTileEntity) {
            return ((SplitShaftTileEntity)te).getRotationSpeedModifier(direction);
        }
        return 1.0f;
    }

    private static boolean isLargeToSmallCog(class_2680 from, class_2680 to, IRotate defTo, class_2338 diff) {
        class_2350.class_2351 axisFrom = (class_2350.class_2351)from.method_11654((class_2769)class_2741.field_12496);
        if (axisFrom != defTo.getRotationAxis(to)) {
            return false;
        }
        if (axisFrom.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260()) != 0) {
            return false;
        }
        for (class_2350.class_2351 axis : class_2350.class_2351.values()) {
            if (axis == axisFrom || Math.abs(axis.method_10173(diff.method_10263(), diff.method_10264(), diff.method_10260())) == 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isLargeCogToSpeedController(class_2680 from, class_2680 to, class_2338 diff) {
        if (!ICogWheel.isLargeCog(from) || !AllBlocks.ROTATION_SPEED_CONTROLLER.has(to)) {
            return false;
        }
        if (!diff.equals((Object)class_2338.field_10980.method_10074())) {
            return false;
        }
        class_2350.class_2351 axis = (class_2350.class_2351)from.method_11654((class_2769)CogWheelBlock.AXIS);
        if (axis.method_10178()) {
            return false;
        }
        return to.method_11654(SpeedControllerBlock.HORIZONTAL_AXIS) != axis;
    }

    public static void handleAdded(class_1937 worldIn, class_2338 pos, KineticTileEntity addedTE) {
        if (worldIn.field_9236) {
            return;
        }
        if (!worldIn.method_8477(pos)) {
            return;
        }
        RotationPropagator.propagateNewSource(addedTE);
    }

    private static void propagateNewSource(KineticTileEntity currentTE) {
        class_2338 pos = currentTE.method_11016();
        class_1937 world = currentTE.method_10997();
        for (KineticTileEntity neighbourTE : RotationPropagator.getConnectedNeighbours(currentTE)) {
            float prevSpeed;
            boolean speedChangedTooOften;
            float speedOfCurrent = currentTE.getTheoreticalSpeed();
            float speedOfNeighbour = neighbourTE.getTheoreticalSpeed();
            float newSpeed = RotationPropagator.getConveyedSpeed(currentTE, neighbourTE);
            float oppositeSpeed = RotationPropagator.getConveyedSpeed(neighbourTE, currentTE);
            if (newSpeed == 0.0f && oppositeSpeed == 0.0f) continue;
            boolean incompatible = Math.signum(newSpeed) != Math.signum(speedOfNeighbour) && newSpeed != 0.0f && speedOfNeighbour != 0.0f;
            boolean tooFast = Math.abs(newSpeed) > (float)((Integer)AllConfigs.SERVER.kinetics.maxRotationSpeed.get()).intValue() || Math.abs(oppositeSpeed) > (float)((Integer)AllConfigs.SERVER.kinetics.maxRotationSpeed.get()).intValue();
            boolean bl = speedChangedTooOften = currentTE.getFlickerScore() > 128;
            if (tooFast || speedChangedTooOften) {
                world.method_22352(pos, true);
                return;
            }
            if (incompatible) {
                world.method_22352(pos, true);
                return;
            }
            if (Math.abs(oppositeSpeed) > Math.abs(speedOfCurrent)) {
                prevSpeed = currentTE.getSpeed();
                currentTE.setSource(neighbourTE.method_11016());
                currentTE.setSpeed(RotationPropagator.getConveyedSpeed(neighbourTE, currentTE));
                currentTE.onSpeedChanged(prevSpeed);
                currentTE.sendData();
                RotationPropagator.propagateNewSource(currentTE);
                return;
            }
            if (Math.abs(newSpeed) >= Math.abs(speedOfNeighbour)) {
                if (!currentTE.hasNetwork() || currentTE.network.equals(neighbourTE.network)) {
                    float epsilon = Math.abs(speedOfNeighbour) / 256.0f / 256.0f;
                    if (!(Math.abs(newSpeed) > Math.abs(speedOfNeighbour) + epsilon)) continue;
                    world.method_22352(pos, true);
                    continue;
                }
                if (currentTE.hasSource() && currentTE.source.equals((Object)neighbourTE.method_11016())) {
                    currentTE.removeSource();
                }
                prevSpeed = neighbourTE.getSpeed();
                neighbourTE.setSource(currentTE.method_11016());
                neighbourTE.setSpeed(RotationPropagator.getConveyedSpeed(currentTE, neighbourTE));
                neighbourTE.onSpeedChanged(prevSpeed);
                neighbourTE.sendData();
                RotationPropagator.propagateNewSource(neighbourTE);
                continue;
            }
            if (neighbourTE.getTheoreticalSpeed() == newSpeed) continue;
            prevSpeed = neighbourTE.getSpeed();
            neighbourTE.setSpeed(newSpeed);
            neighbourTE.setSource(currentTE.method_11016());
            neighbourTE.onSpeedChanged(prevSpeed);
            neighbourTE.sendData();
            RotationPropagator.propagateNewSource(neighbourTE);
        }
    }

    public static void handleRemoved(class_1937 worldIn, class_2338 pos, KineticTileEntity removedTE) {
        if (worldIn.field_9236) {
            return;
        }
        if (removedTE == null) {
            return;
        }
        if (removedTE.getTheoreticalSpeed() == 0.0f) {
            return;
        }
        for (class_2338 neighbourPos : RotationPropagator.getPotentialNeighbourLocations(removedTE)) {
            KineticTileEntity neighbourTE;
            class_2586 tileEntity;
            class_2680 neighbourState = worldIn.method_8320(neighbourPos);
            if (!(neighbourState.method_26204() instanceof IRotate) || !((tileEntity = worldIn.method_8321(neighbourPos)) instanceof KineticTileEntity) || !(neighbourTE = (KineticTileEntity)tileEntity).hasSource() || !neighbourTE.source.equals((Object)pos)) continue;
            RotationPropagator.propagateMissingSource(neighbourTE);
        }
    }

    private static void propagateMissingSource(KineticTileEntity updateTE) {
        class_2338 missingSource;
        class_1937 world = updateTE.method_10997();
        LinkedList<KineticTileEntity> potentialNewSources = new LinkedList<KineticTileEntity>();
        LinkedList<class_2338> frontier = new LinkedList<class_2338>();
        frontier.add(updateTE.method_11016());
        class_2338 class_23382 = missingSource = updateTE.hasSource() ? updateTE.source : null;
        while (!frontier.isEmpty()) {
            class_2338 pos = (class_2338)frontier.remove(0);
            class_2586 tileEntity = world.method_8321(pos);
            if (!(tileEntity instanceof KineticTileEntity)) continue;
            KineticTileEntity currentTE = (KineticTileEntity)tileEntity;
            currentTE.removeSource();
            currentTE.sendData();
            for (KineticTileEntity neighbourTE : RotationPropagator.getConnectedNeighbours(currentTE)) {
                if (neighbourTE.method_11016().equals((Object)missingSource) || !neighbourTE.hasSource()) continue;
                if (!neighbourTE.source.equals((Object)pos)) {
                    potentialNewSources.add(neighbourTE);
                    continue;
                }
                if (neighbourTE.isSource()) {
                    potentialNewSources.add(neighbourTE);
                }
                frontier.add(neighbourTE.method_11016());
            }
        }
        for (KineticTileEntity newSource : potentialNewSources) {
            if (!newSource.hasSource() && !newSource.isSource()) continue;
            RotationPropagator.propagateNewSource(newSource);
            return;
        }
    }

    private static KineticTileEntity findConnectedNeighbour(KineticTileEntity currentTE, class_2338 neighbourPos) {
        class_2680 neighbourState = currentTE.method_10997().method_8320(neighbourPos);
        if (!(neighbourState.method_26204() instanceof IRotate)) {
            return null;
        }
        if (!neighbourState.method_31709()) {
            return null;
        }
        class_2586 neighbourTE = currentTE.method_10997().method_8321(neighbourPos);
        if (!(neighbourTE instanceof KineticTileEntity)) {
            return null;
        }
        KineticTileEntity neighbourKTE = (KineticTileEntity)neighbourTE;
        if (!(neighbourKTE.method_11010().method_26204() instanceof IRotate)) {
            return null;
        }
        if (!RotationPropagator.isConnected(currentTE, neighbourKTE) && !RotationPropagator.isConnected(neighbourKTE, currentTE)) {
            return null;
        }
        return neighbourKTE;
    }

    public static boolean isConnected(KineticTileEntity from, KineticTileEntity to) {
        class_2680 stateTo;
        class_2680 stateFrom = from.method_11010();
        return RotationPropagator.isLargeCogToSpeedController(stateFrom, stateTo = to.method_11010(), to.method_11016().method_10059((class_2382)from.method_11016())) || RotationPropagator.getRotationSpeedModifier(from, to) != 0.0f || from.isCustomConnection(to, stateFrom, stateTo);
    }

    private static List<KineticTileEntity> getConnectedNeighbours(KineticTileEntity te) {
        LinkedList<KineticTileEntity> neighbours = new LinkedList<KineticTileEntity>();
        for (class_2338 neighbourPos : RotationPropagator.getPotentialNeighbourLocations(te)) {
            KineticTileEntity neighbourTE = RotationPropagator.findConnectedNeighbour(te, neighbourPos);
            if (neighbourTE == null) continue;
            neighbours.add(neighbourTE);
        }
        return neighbours;
    }

    private static List<class_2338> getPotentialNeighbourLocations(KineticTileEntity te) {
        LinkedList<class_2338> neighbours = new LinkedList<class_2338>();
        if (!LevelUtil.isAreaLoaded((class_1936)te.method_10997(), (class_2338)te.method_11016(), (int)1)) {
            return neighbours;
        }
        for (class_2350 facing : Iterate.directions) {
            neighbours.add(te.method_11016().method_10093(facing));
        }
        class_2680 blockState = te.method_11010();
        if (!(blockState.method_26204() instanceof IRotate)) {
            return neighbours;
        }
        IRotate block = (IRotate)blockState.method_26204();
        return te.addPropagationLocations(block, blockState, neighbours);
    }
}

