/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2561;
import net.minecraft.class_4587;

@ParametersAreNonnullByDefault
public abstract class ProcessingViaFanCategory<T extends class_1860<?>>
extends CreateRecipeCategory<T> {
    protected static final int SCALE = 24;

    public ProcessingViaFanCategory(CreateRecipeCategory.Info<T> info) {
        super(info);
    }

    public static Supplier<class_1799> getFan(String name) {
        return () -> AllBlocks.ENCASED_FAN.asStack().method_7977((class_2561)Lang.translateDirect("recipe." + name + ".fan", new Object[0]).method_27694(style -> style.method_10978(Boolean.valueOf(false))));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 21, 48).setBackground(ProcessingViaFanCategory.getRenderedSlot(), -1, -1).addIngredients((class_1856)recipe.method_8117().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 141, 48).setBackground(ProcessingViaFanCategory.getRenderedSlot(), -1, -1).addItemStack(recipe.method_8110());
    }

    public void draw(T recipe, IRecipeSlotsView iRecipeSlotsView, class_4587 matrixStack, double mouseX, double mouseY) {
        this.renderWidgets(matrixStack, recipe, mouseX, mouseY);
        matrixStack.method_22903();
        this.translateFan(matrixStack);
        matrixStack.method_22907(class_1160.field_20703.method_23214(-12.5f));
        matrixStack.method_22907(class_1160.field_20705.method_23214(22.5f));
        AnimatedKinetics.defaultBlockElement(AllBlockPartials.ENCASED_FAN_INNER).rotateBlock(180.0, 0.0, AnimatedKinetics.getCurrentAngle() * 16.0f).scale(24.0).render(matrixStack);
        AnimatedKinetics.defaultBlockElement(AllBlocks.ENCASED_FAN.getDefaultState()).rotateBlock(0.0, 180.0, 0.0).atLocal(0.0, 0.0, 0.0).scale(24.0).render(matrixStack);
        this.renderAttachedBlock(matrixStack);
        matrixStack.method_22909();
    }

    protected void renderWidgets(class_4587 matrixStack, T recipe, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 46, 29);
        this.getBlockShadow().render(matrixStack, 65, 39);
        AllGuiTextures.JEI_LONG_ARROW.render(matrixStack, 54, 51);
    }

    protected AllGuiTextures getBlockShadow() {
        return AllGuiTextures.JEI_SHADOW;
    }

    protected void translateFan(class_4587 matrixStack) {
        matrixStack.method_22904(56.0, 33.0, 0.0);
    }

    protected abstract void renderAttachedBlock(class_4587 var1);

    public static abstract class MultiOutput<T extends ProcessingRecipe<?>>
    extends ProcessingViaFanCategory<T> {
        public MultiOutput(CreateRecipeCategory.Info<T> info) {
            super(info);
        }

        @Override
        public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
            List<ProcessingOutput> results = ((ProcessingRecipe)recipe).getRollableResults();
            int xOffsetAmount = 1 - Math.min(3, results.size());
            builder.addSlot(RecipeIngredientRole.INPUT, 5 * xOffsetAmount + 21, 48).setBackground(MultiOutput.getRenderedSlot(), -1, -1).addIngredients((class_1856)((ProcessingRecipe)recipe).method_8117().get(0));
            int i = 0;
            boolean excessive = results.size() > 9;
            for (ProcessingOutput output : results) {
                int xOffset = i % 3 * 19 + 9 * xOffsetAmount;
                int yOffset = i / 3 * -19 + (excessive ? 8 : 0);
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 141 + xOffset, 48 + yOffset).setBackground(MultiOutput.getRenderedSlot(output), -1, -1).addItemStack(output.getStack())).addTooltipCallback(MultiOutput.addStochasticTooltip(output));
                ++i;
            }
        }

        @Override
        protected void renderWidgets(class_4587 matrixStack, T recipe, double mouseX, double mouseY) {
            int size = ((ProcessingRecipe)recipe).getRollableResultsAsItemStacks().size();
            int xOffsetAmount = 1 - Math.min(3, size);
            AllGuiTextures.JEI_SHADOW.render(matrixStack, 46, 29);
            this.getBlockShadow().render(matrixStack, 65, 39);
            AllGuiTextures.JEI_LONG_ARROW.render(matrixStack, 7 * xOffsetAmount + 54, 51);
        }
    }
}

