/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.module;

import com.yungnickyoung.minecraft.yungsbridges.YungsBridgesCommon;
import com.yungnickyoung.minecraft.yungsbridges.module.FeatureModule;
import com.yungnickyoung.minecraft.yungsbridges.world.feature.BridgeFeatureConfig;
import com.yungnickyoung.minecraft.yungsbridges.world.feature.MultipleAttemptSingleRandomFeatureConfig;
import com.yungnickyoung.minecraft.yungsbridges.world.placement.BridgePlacement;
import com.yungnickyoung.minecraft.yungsbridges.world.placement.BridgePlacementConfig;
import com.yungnickyoung.minecraft.yungsbridges.world.placement.RngInitializerPlacement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_5458;
import net.minecraft.class_6792;
import net.minecraft.class_6796;
import net.minecraft.class_6799;
import net.minecraft.class_6880;

public class ConfiguredFeatureModule {
    private static final List<class_6796> PLACED_BRIDGES = new ArrayList<class_6796>();
    public static final class_2975<?, ?> BRIDGE_LIST_FEATURE_CONFIGURED;
    public static final class_6796 BRIDGE_LIST_FEATURE_PLACED;

    public static void registerConfiguredFeatures() {
        ConfiguredFeatureModule.registerConfiguredFeature(BRIDGE_LIST_FEATURE_CONFIGURED, "bridge_list");
    }

    public static void registerPlacedFeatures() {
        ConfiguredFeatureModule.registerPlacedFeature(BRIDGE_LIST_FEATURE_PLACED, "bridge_list");
    }

    private static void registerConfiguredFeature(class_2975<?, ?> feature, String id) {
        class_2378.method_10230((class_2378)class_5458.field_25929, (class_2960)new class_2960("yungsbridges", id), feature);
    }

    private static void registerPlacedFeature(class_6796 feature, String id) {
        class_2378.method_10230((class_2378)class_5458.field_35761, (class_2960)new class_2960("yungsbridges", id), (Object)feature);
    }

    private static void addLargeBridge(String id, BridgePlacementConfig placementConfig) {
        ConfiguredFeatureModule.addBridge(id, placementConfig, YungsBridgesCommon.CONFIG.spawnRates.largeBridges);
    }

    private static void addMediumBridge(String id, BridgePlacementConfig placementConfig) {
        ConfiguredFeatureModule.addBridge(id, placementConfig, YungsBridgesCommon.CONFIG.spawnRates.mediumBridges);
    }

    private static void addSmallBridge(String id, BridgePlacementConfig placementConfig) {
        ConfiguredFeatureModule.addBridge(id, placementConfig, YungsBridgesCommon.CONFIG.spawnRates.smallBridges);
    }

    private static void addBridge(String id, BridgePlacementConfig placementConfig, int chance) {
        BridgeFeatureConfig featureConfig = new BridgeFeatureConfig(id);
        class_2975 configuredFeature = new class_2975(FeatureModule.BRIDGE, (class_3037)featureConfig);
        class_6796 placedFeature = new class_6796(class_6880.method_40223((Object)configuredFeature), List.of(BridgePlacement.of(placementConfig), class_6799.method_39659((int)chance), RngInitializerPlacement.randomized()));
        class_2975 rotatedConfiguredFeature = new class_2975(FeatureModule.BRIDGE, (class_3037)featureConfig.rotatedCopy());
        class_6796 placedRotatedFeature = new class_6796(class_6880.method_40223((Object)rotatedConfiguredFeature), List.of(BridgePlacement.of(placementConfig.rotatedCopy()), class_6799.method_39659((int)chance), RngInitializerPlacement.randomized()));
        PLACED_BRIDGES.add(placedFeature);
        PLACED_BRIDGES.add(placedRotatedFeature);
    }

    static {
        ConfiguredFeatureModule.addLargeBridge("bridge/stone/31_0", new BridgePlacementConfig(31, 5, 4, 28).widthOffset(2).solidBlocks(3));
        ConfiguredFeatureModule.addLargeBridge("bridge/wood/27_0", new BridgePlacementConfig(27, 5, 2, 26).solidBlocks(2));
        ConfiguredFeatureModule.addMediumBridge("bridge/stone/24_0", new BridgePlacementConfig(24, 5, 2, 23).solidBlocks(2));
        ConfiguredFeatureModule.addMediumBridge("bridge/stone/24_0_broken", new BridgePlacementConfig(24, 5, 2, 23).solidBlocks(2));
        ConfiguredFeatureModule.addMediumBridge("bridge/stone/22_0", new BridgePlacementConfig(22, 5, 2, 21).solidBlocks(2));
        ConfiguredFeatureModule.addMediumBridge("bridge/stone/22_0_broken", new BridgePlacementConfig(22, 5, 2, 21).solidBlocks(2));
        ConfiguredFeatureModule.addSmallBridge("bridge/wood/17_0", new BridgePlacementConfig(17, 4, 2, 16).solidBlocks(2));
        ConfiguredFeatureModule.addSmallBridge("bridge/wood/17_0_broken", new BridgePlacementConfig(17, 4, 2, 16).solidBlocks(2));
        ConfiguredFeatureModule.addSmallBridge("bridge/stone/16_0", new BridgePlacementConfig(16, 5, 2, 15).solidBlocks(2));
        ConfiguredFeatureModule.addSmallBridge("bridge/stone/16_0_broken", new BridgePlacementConfig(16, 5, 2, 15).solidBlocks(2));
        ConfiguredFeatureModule.addSmallBridge("bridge/stone/15_1", new BridgePlacementConfig(15, 5, 2, 14).widthOffset(1).solidBlocks(2));
        BRIDGE_LIST_FEATURE_CONFIGURED = new class_2975(FeatureModule.MULTIPLE_ATTEMPT_SINGLE_RANDOM, (class_3037)new MultipleAttemptSingleRandomFeatureConfig(PLACED_BRIDGES));
        BRIDGE_LIST_FEATURE_PLACED = new class_6796(class_6880.method_40223(BRIDGE_LIST_FEATURE_CONFIGURED), List.of(class_6792.method_39614()));
    }
}

