/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractMeshConsumer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.TerrainFallbackConsumer;
import net.minecraft.class_1087;
import net.minecraft.class_1159;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;

public class BlockRenderContext
extends AbstractRenderContext {
    private final BlockRenderInfo blockInfo = new BlockRenderInfo();
    private final AoCalculator aoCalc = new AoCalculator(this.blockInfo, this::brightness, this::aoLevel);
    private class_4588 bufferBuilder;
    private boolean didOutput = false;
    private Random random;
    private long seed;
    private final Supplier<Random> randomSupplier = () -> {
        this.random.setSeed(this.seed);
        return this.random;
    };
    private final AbstractMeshConsumer meshConsumer = new AbstractMeshConsumer(this.blockInfo, this::outputBuffer, this.aoCalc, this::transform){

        @Override
        protected class_1159 matrix() {
            return BlockRenderContext.this.matrix;
        }

        @Override
        protected class_4581 normalMatrix() {
            return BlockRenderContext.this.normalMatrix;
        }

        @Override
        protected int overlay() {
            return BlockRenderContext.this.overlay;
        }
    };
    private final TerrainFallbackConsumer fallbackConsumer = new TerrainFallbackConsumer(this.blockInfo, this::outputBuffer, this.aoCalc, this::transform){

        @Override
        protected class_1159 matrix() {
            return BlockRenderContext.this.matrix;
        }

        @Override
        protected class_4581 normalMatrix() {
            return BlockRenderContext.this.normalMatrix;
        }

        @Override
        protected int overlay() {
            return BlockRenderContext.this.overlay;
        }
    };

    private int brightness(class_2338 pos, class_2680 state) {
        if (this.blockInfo.blockView == null) {
            return 0xF000F0;
        }
        return class_761.method_23793((class_1920)this.blockInfo.blockView, (class_2680)state, (class_2338)pos);
    }

    private float aoLevel(class_2338 pos, class_2680 state) {
        class_1920 blockView = this.blockInfo.blockView;
        return blockView == null ? 1.0f : AoLuminanceFix.INSTANCE.apply((class_1922)blockView, pos, state);
    }

    private class_4588 outputBuffer(class_1921 renderLayer) {
        this.didOutput = true;
        return this.bufferBuilder;
    }

    public boolean render(class_1920 blockView, class_1087 model, class_2680 state, class_2338 pos, class_4587 matrixStack, class_4588 buffer, Random random, long seed, int overlay) {
        this.bufferBuilder = buffer;
        this.matrix = matrixStack.method_23760().method_23761();
        this.normalMatrix = matrixStack.method_23760().method_23762();
        this.random = random;
        this.seed = seed;
        this.overlay = overlay;
        this.didOutput = false;
        this.aoCalc.clear();
        this.blockInfo.setBlockView(blockView);
        this.blockInfo.prepareForBlock(state, pos, model.method_4708());
        ((FabricBakedModel)model).emitBlockQuads(blockView, state, pos, this.randomSupplier, (RenderContext)this);
        this.blockInfo.release();
        this.bufferBuilder = null;
        this.random = null;
        this.seed = seed;
        return this.didOutput;
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    public Consumer<class_1087> fallbackConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }
}

