/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.SystemFavoriteEntryProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponent;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.favorites.FavoriteEntryTypeRegistryImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesEntriesManager;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayHistoryManager;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayHistoryWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.listeners.FavoritesRegionListener;
import me.shedaniel.rei.impl.client.gui.widget.favorites.listeners.FavoritesSystemRegionListener;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.FavoritesPanel;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.FavoritesTogglePanelButton;
import me.shedaniel.rei.impl.client.gui.widget.favorites.trash.TrashWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.EntryStacksRegionWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RealRegionEntry;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionDraggableStack;
import me.shedaniel.rei.impl.common.util.RectangleUtils;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FavoritesListWidget
extends WidgetWithBounds
implements DraggableComponentProviderWidget<Object>,
DraggableComponentVisitorWidget,
OverlayListWidget {
    public Rectangle fullBounds;
    public Rectangle excludedBounds;
    public Rectangle favoritesBounds;
    private EntryStacksRegionWidget<FavoriteEntry> systemRegion = new EntryStacksRegionWidget<FavoriteEntry>(new FavoritesSystemRegionListener());
    private EntryStacksRegionWidget<FavoriteEntry> region = new EntryStacksRegionWidget<FavoriteEntry>(new FavoritesRegionListener(this));
    private List<FavoriteEntry> lastSystemEntries = new ArrayList<FavoriteEntry>();
    public final FavoritesPanel favoritePanel = new FavoritesPanel(this);
    public final TrashWidget trash = new TrashWidget(this);
    public final DisplayHistoryWidget displayHistory = new DisplayHistoryWidget(this);
    public final FavoritesTogglePanelButton togglePanelButton = new FavoritesTogglePanelButton(this);
    private List<Widget> children = ImmutableList.of((Object)this.favoritePanel, (Object)this.togglePanelButton, this.systemRegion, this.region);

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.fullBounds.contains(mouseX, mouseY)) {
            if (class_437.method_25441()) {
                ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
                ScreenOverlayImpl.getEntryListWidget().scaleIndicator.setAs(10.0);
                if (config.setEntrySize(config.getEntrySize() + amount * 0.075)) {
                    ConfigManager.getInstance().saveConfig();
                    REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                    return true;
                }
            } else {
                if (this.favoritePanel.method_25401(mouseX, mouseY, amount)) {
                    return true;
                }
                if (this.displayHistory.method_25401(mouseX, mouseY, amount)) {
                    return true;
                }
            }
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    @Override
    public Rectangle getBounds() {
        return this.fullBounds;
    }

    public EntryStacksRegionWidget<FavoriteEntry> getRegion() {
        return this.region;
    }

    public EntryStacksRegionWidget<FavoriteEntry> getSystemRegion() {
        return this.systemRegion;
    }

    @Override
    @Nullable
    public DraggableComponent<Object> getHovered(DraggingContext<class_437> context, double mouseX, double mouseY) {
        DraggableComponent<EntryStack<?>> stack = this.region.getHoveredStack(context, mouseX, mouseY);
        if (stack != null) {
            return stack;
        }
        stack = this.systemRegion.getHoveredStack(context, mouseX, mouseY);
        if (stack != null) {
            return stack;
        }
        if (this.favoritePanel.containsMouse(mouseX, mouseY) && (stack = this.favoritePanel.getHoveredStack(mouseX, mouseY)) != null) {
            return stack;
        }
        stack = this.displayHistory.getHovered(context, mouseX, mouseY);
        if (stack != null) {
            return stack;
        }
        return null;
    }

    @Override
    public DraggedAcceptorResult acceptDragged(DraggingContext<class_437> context, DraggableComponent<?> stack) {
        if (this.favoritePanel.containsMouse(context.getCurrentPosition()) || this.trash.containsMouse(context.getCurrentPosition())) {
            context.renderToVoid(stack);
            return DraggedAcceptorResult.CONSUMED;
        }
        return Stream.of(this.region, this.systemRegion, this.displayHistory).map(visitor -> ((DraggableComponentVisitorWidget)((Object)visitor)).acceptDragged(context, stack)).filter(result -> result != DraggedAcceptorResult.PASS).findFirst().orElse(DraggedAcceptorResult.PASS);
    }

    @Override
    public EntryStack<?> getFocusedStack() {
        EntryStack<?> focusedStack;
        Point mouse = FavoritesListWidget.mouse();
        EntryStack<?> stack = this.region.getFocusedStack();
        if (stack != null && !stack.isEmpty()) {
            return stack;
        }
        stack = this.systemRegion.getFocusedStack();
        if (stack != null && !stack.isEmpty()) {
            return stack;
        }
        if (this.favoritePanel.containsMouse(mouse) && (focusedStack = this.favoritePanel.getFocusedStack(mouse)) != null) {
            return focusedStack;
        }
        return EntryStack.empty();
    }

    @Override
    public Stream<EntryStack<?>> getEntries() {
        return this.region.getEntries();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.fullBounds.isEmpty()) {
            return;
        }
        this.trash.method_25394(matrices, mouseX, mouseY, delta);
        double trashHeight = this.trash.getHeight();
        if (!PluginManager.areAnyReloading()) {
            this.updateSystemRegion();
        }
        boolean draggingDisplay = DraggingContext.getInstance().isDraggingComponent() && DraggingContext.getInstance().getDragged().get() instanceof Display;
        int topOffsetHeight = 0;
        this.favoritesBounds = DisplayHistoryManager.INSTANCE.getEntries(this.displayHistory).isEmpty() && !draggingDisplay ? this.fullBounds : RectangleUtils.excludeZones(this.fullBounds, Stream.of(this.displayHistory.createBounds(this.excludedBounds)));
        this.systemRegion.getBounds().setBounds(this.favoritesBounds.x, this.favoritesBounds.y + 1, this.favoritesBounds.width, Math.max(1, this.systemRegion.scrolling.getMaxScrollHeight()));
        int systemHeight = this.systemRegion.getBounds().getHeight();
        if (systemHeight > 1 && !this.region.isEmpty()) {
            Rectangle innerBounds = this.systemRegion.getInnerBounds();
            this.method_25296(matrices, innerBounds.x + 1, this.favoritesBounds.y + systemHeight + 2, innerBounds.getMaxX() - 1, this.favoritesBounds.y + systemHeight + 3, -8947849, -8947849);
            topOffsetHeight += systemHeight + 4;
        }
        this.displayHistory.method_25394(matrices, mouseX, mouseY, delta);
        if (this.favoritePanel.getBounds().height > 20) {
            this.region.getBounds().setBounds((double)this.favoritesBounds.x, (double)(this.favoritesBounds.y + topOffsetHeight), (double)this.favoritesBounds.width, (double)(this.favoritesBounds.height - topOffsetHeight - (this.favoritesBounds.getMaxY() - this.favoritePanel.getBounds().y) - 4) - (Math.round(trashHeight) <= 0L ? 0.0 : trashHeight));
        } else {
            this.region.getBounds().setBounds((double)this.favoritesBounds.x, (double)(this.favoritesBounds.y + topOffsetHeight), (double)this.favoritesBounds.width, (double)(this.favoritesBounds.height - topOffsetHeight) - (Math.round(trashHeight) <= 0L ? 0.0 : trashHeight + 24.0));
        }
        this.systemRegion.method_25394(matrices, mouseX, mouseY, delta);
        this.region.method_25394(matrices, mouseX, mouseY, delta);
        this.renderAddFavorite(matrices, mouseX, mouseY, delta);
    }

    private void updateSystemRegion() {
        boolean updated = false;
        List<Triple<SystemFavoriteEntryProvider<?>, MutableLong, List<FavoriteEntry>>> providers = ((FavoriteEntryTypeRegistryImpl)FavoriteEntryType.registry()).getSystemProviders();
        for (Triple<SystemFavoriteEntryProvider<?>, MutableLong, List<FavoriteEntry>> pair : providers) {
            SystemFavoriteEntryProvider provider = (SystemFavoriteEntryProvider)pair.getLeft();
            MutableLong mutableLong = (MutableLong)pair.getMiddle();
            List entries = (List)pair.getRight();
            if (mutableLong.getValue() != -1L && mutableLong.getValue() >= System.currentTimeMillis()) continue;
            mutableLong.setValue(System.currentTimeMillis() + provider.updateInterval());
            List provide = provider.provide();
            if (provide.equals(entries)) continue;
            entries.clear();
            entries.addAll(provide);
            updated = true;
        }
        if (updated) {
            this.lastSystemEntries = CollectionUtils.flatMap(providers, Triple::getRight);
            this.setSystemRegionEntries(null);
        }
    }

    public void setSystemRegionEntries(@Nullable RealRegionEntry<FavoriteEntry> removed) {
        this.systemRegion.setEntries(CollectionUtils.filterToList(this.lastSystemEntries, entry -> {
            DraggableStack currentStack;
            if (this.region.has((FavoriteEntry)entry)) {
                return false;
            }
            if (DraggingContext.getInstance().isDraggingStack() && (currentStack = DraggingContext.getInstance().getCurrentStack()) instanceof RegionDraggableStack) {
                RegionDraggableStack stack = (RegionDraggableStack)currentStack;
                if (removed != null && stack.getEntry() == removed) {
                    return true;
                }
                return stack.getEntry().region != this.region || !Objects.equals(stack.getEntry().getEntry(), entry);
            }
            return true;
        }), EntryStacksRegionWidget.RemovalMode.DISAPPEAR);
    }

    private void renderAddFavorite(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.favoritePanel.method_25394(matrices, mouseX, mouseY, delta);
        this.togglePanelButton.method_25394(matrices, mouseX, mouseY, delta);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.containsMouse(FavoritesListWidget.mouse())) {
            for (Widget widget : this.method_25396()) {
                if (!widget.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return this.displayHistory.method_25404(keyCode, scanCode, modifiers);
    }

    public void updateFavoritesBounds(@Nullable String searchTerm) {
        this.fullBounds = REIRuntime.getInstance().calculateFavoritesListArea();
        this.excludedBounds = RectangleUtils.excludeZones(this.fullBounds, ScreenRegistry.getInstance().exclusionZones().getExclusionZones(this.minecraft.field_1755).stream());
        this.favoritesBounds = RectangleUtils.excludeZones(this.fullBounds, Stream.of(this.displayHistory.createBounds(this.fullBounds, null)));
    }

    public void updateSearch() {
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            this.region.setEntries(CollectionUtils.map(FavoritesEntriesManager.INSTANCE.getFavorites(), FavoriteEntry::copy), EntryStacksRegionWidget.RemovalMode.DISAPPEAR);
        } else {
            this.region.setEntries(Collections.emptyList(), EntryStacksRegionWidget.RemovalMode.DISAPPEAR);
        }
    }

    public List<? extends Widget> method_25396() {
        return this.children;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.systemRegion.method_25402(mouseX, mouseY, button) || this.region.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        for (Widget widget : this.method_25396()) {
            if (!widget.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return this.displayHistory.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX, mouseY)) {
            for (Widget widget : this.method_25396()) {
                if (!widget.method_25406(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return this.displayHistory.method_25406(mouseX, mouseY, button);
    }
}

