/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.vertex;

import com.jozufozu.flywheel.api.vertex.ShadedVertexList;
import com.jozufozu.flywheel.core.model.ShadeSeparatedBufferBuilder;
import com.jozufozu.flywheel.core.vertex.AbstractVertexList;
import com.jozufozu.flywheel.fabric.helper.BufferBuilderHelper;
import com.jozufozu.flywheel.util.RenderMath;
import net.minecraft.class_287;

public class BlockVertexList
extends AbstractVertexList {
    private final int stride;

    public BlockVertexList(class_287 builder) {
        super(builder);
        this.stride = BufferBuilderHelper.getVertexFormat(builder).method_1362();
    }

    @Override
    public boolean isEmpty() {
        return this.vertexCount == 0;
    }

    private int vertIdx(int vertexIndex) {
        return vertexIndex * this.stride;
    }

    @Override
    public float getX(int index) {
        return this.contents.getFloat(this.vertIdx(index));
    }

    @Override
    public float getY(int index) {
        return this.contents.getFloat(this.vertIdx(index) + 4);
    }

    @Override
    public float getZ(int index) {
        return this.contents.getFloat(this.vertIdx(index) + 8);
    }

    @Override
    public byte getR(int index) {
        return this.contents.get(this.vertIdx(index) + 12);
    }

    @Override
    public byte getG(int index) {
        return this.contents.get(this.vertIdx(index) + 13);
    }

    @Override
    public byte getB(int index) {
        return this.contents.get(this.vertIdx(index) + 14);
    }

    @Override
    public byte getA(int index) {
        return this.contents.get(this.vertIdx(index) + 15);
    }

    @Override
    public float getU(int index) {
        return this.contents.getFloat(this.vertIdx(index) + 16);
    }

    @Override
    public float getV(int index) {
        return this.contents.getFloat(this.vertIdx(index) + 20);
    }

    @Override
    public int getLight(int index) {
        return this.contents.getInt(this.vertIdx(index) + 24);
    }

    @Override
    public float getNX(int index) {
        return RenderMath.f(this.contents.get(this.vertIdx(index) + 28));
    }

    @Override
    public float getNY(int index) {
        return RenderMath.f(this.contents.get(this.vertIdx(index) + 29));
    }

    @Override
    public float getNZ(int index) {
        return RenderMath.f(this.contents.get(this.vertIdx(index) + 30));
    }

    public static class Shaded
    extends BlockVertexList
    implements ShadedVertexList {
        private final int unshadedStartVertex;

        public Shaded(ShadeSeparatedBufferBuilder builder) {
            super(builder);
            this.unshadedStartVertex = builder.getUnshadedStartVertex();
        }

        @Override
        public boolean isShaded(int index) {
            return index < this.unshadedStartVertex;
        }
    }
}

