/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.source;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.core.source.span.CharPos;
import com.jozufozu.flywheel.util.StringUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SourceLines {
    private static final Pattern newLine = Pattern.compile("(\\r\\n|\\r|\\n)");
    private final IntList lineStarts;
    private final ImmutableList<String> lines;

    public SourceLines(String source) {
        this.lineStarts = SourceLines.createLineLookup(source);
        this.lines = SourceLines.getLines(source, this.lineStarts);
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public String getLine(int lineNo) {
        return (String)this.lines.get(lineNo);
    }

    public int getLineStart(int lineNo) {
        return this.lineStarts.getInt(lineNo);
    }

    public CharPos getCharPos(int charPos) {
        int ls;
        int lineNo;
        for (lineNo = 0; lineNo < this.lineStarts.size() && charPos >= (ls = this.lineStarts.getInt(lineNo)); ++lineNo) {
        }
        int lineStart = this.lineStarts.getInt(--lineNo);
        return new CharPos(charPos, lineNo, charPos - lineStart);
    }

    public String printLinesWithNumbers() {
        StringBuilder builder = new StringBuilder();
        int linesSize = this.lines.size();
        for (int i = 0; i < linesSize; ++i) {
            builder.append(String.format("%1$4s: ", i + 1)).append((String)this.lines.get(i)).append('\n');
        }
        return builder.toString();
    }

    private static IntList createLineLookup(String source) {
        IntArrayList l = new IntArrayList();
        l.add(0);
        Matcher matcher = newLine.matcher(source);
        while (matcher.find()) {
            l.add(matcher.end());
        }
        return l;
    }

    private static ImmutableList<String> getLines(String source, IntList lines) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 1; i < lines.size(); ++i) {
            int start = lines.getInt(i - 1);
            int end = lines.getInt(i);
            builder.add((Object)StringUtil.trimEnd(source.substring(start, end)));
        }
        return builder.build();
    }
}

