/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.source;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.jozufozu.flywheel.core.source.FileIndex;
import com.jozufozu.flywheel.core.source.Resolver;
import com.jozufozu.flywheel.core.source.ShaderSources;
import com.jozufozu.flywheel.core.source.SourceLines;
import com.jozufozu.flywheel.core.source.parse.Import;
import com.jozufozu.flywheel.core.source.parse.ShaderFunction;
import com.jozufozu.flywheel.core.source.parse.ShaderStruct;
import com.jozufozu.flywheel.core.source.span.ErrorSpan;
import com.jozufozu.flywheel.core.source.span.Span;
import com.jozufozu.flywheel.core.source.span.StringSpan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2960;

public class SourceFile {
    private static final Pattern includePattern = Pattern.compile("#use \"(.*)\"");
    public static final Pattern functionDeclaration = Pattern.compile("(\\w+)\\s+(\\w+)\\s*\\(([\\w,\\s]*)\\)\\s*\\{");
    public final class_2960 name;
    public final ShaderSources parent;
    public final String source;
    public final String elided;
    public final SourceLines lines;
    public final ImmutableMap<String, ShaderFunction> functions;
    public final ImmutableMap<String, ShaderStruct> structs;
    public final ImmutableList<Import> imports;

    public SourceFile(ShaderSources parent, class_2960 name, String source) {
        this.parent = parent;
        this.name = name;
        this.source = source;
        this.lines = new SourceLines(source);
        ArrayList<Span> elisions = new ArrayList<Span>();
        this.imports = this.parseImports(elisions);
        this.functions = this.parseFunctions();
        this.structs = this.parseStructs();
        this.elided = SourceFile.elideSource(source, elisions).toString();
    }

    public Span getLineSpan(int line) {
        int begin = this.lines.getLineStart(line);
        int end = begin + this.lines.getLine(line).length();
        return new StringSpan(this, this.lines.getCharPos(begin), this.lines.getCharPos(end));
    }

    public Span getLineSpanNoWhitespace(int line) {
        int begin;
        int end = begin + this.lines.getLine(line).length();
        for (begin = this.lines.getLineStart(line); begin < end && Character.isWhitespace(this.source.charAt(begin)); ++begin) {
        }
        return new StringSpan(this, this.lines.getCharPos(begin), this.lines.getCharPos(end));
    }

    public Optional<ShaderStruct> findStruct(CharSequence name) {
        ShaderStruct struct = (ShaderStruct)this.structs.get((Object)name.toString());
        if (struct != null) {
            return Optional.of(struct);
        }
        for (Import include : this.imports) {
            Optional<ShaderStruct> externalStruct = include.getOptional().flatMap(file -> file.findStruct(name));
            if (!externalStruct.isPresent()) continue;
            return externalStruct;
        }
        return Optional.empty();
    }

    public Optional<ShaderFunction> findFunction(CharSequence name) {
        ShaderFunction local = (ShaderFunction)this.functions.get((Object)name.toString());
        if (local != null) {
            return Optional.of(local);
        }
        for (Import include : this.imports) {
            Optional<ShaderFunction> external = include.getOptional().flatMap(file -> file.findFunction(name));
            if (!external.isPresent()) continue;
            return external;
        }
        return Optional.empty();
    }

    public CharSequence importStatement() {
        return "#use \"" + this.name + "\"";
    }

    public void generateFinalSource(FileIndex env, StringBuilder source) {
        for (Import include : this.imports) {
            SourceFile file = include.getFile();
            if (file == null) continue;
            file.generateFinalSource(env, source);
        }
        source.append("#line ").append(0).append(' ').append(env.getFileID(this)).append('\n');
        source.append(this.elided);
    }

    public String printSource() {
        return "Source for shader '" + this.name + "':\n" + this.lines.printLinesWithNumbers();
    }

    private static CharSequence elideSource(String source, List<Span> elisions) {
        StringBuilder out = new StringBuilder();
        int lastEnd = 0;
        for (Span elision : elisions) {
            out.append(source, lastEnd, elision.getStartPos());
            lastEnd = elision.getEndPos();
        }
        out.append(source, lastEnd, source.length());
        return out;
    }

    private ImmutableMap<String, ShaderFunction> parseFunctions() {
        Matcher matcher = functionDeclaration.matcher(this.source);
        HashMap<String, ShaderFunction> functions = new HashMap<String, ShaderFunction>();
        while (matcher.find()) {
            Span body;
            Span self;
            Span type = Span.fromMatcher(this, matcher, 1);
            Span name = Span.fromMatcher(this, matcher, 2);
            Span args = Span.fromMatcher(this, matcher, 3);
            int blockStart = matcher.end();
            int blockEnd = this.findEndOfBlock(blockStart);
            if (blockEnd > blockStart) {
                self = new StringSpan(this, matcher.start(), blockEnd + 1);
                body = new StringSpan(this, blockStart, blockEnd);
            } else {
                self = new ErrorSpan(this, matcher.start(), matcher.end());
                body = new ErrorSpan(this, blockStart);
            }
            ShaderFunction function = new ShaderFunction(self, type, name, args, body);
            functions.put(name.get(), function);
        }
        return ImmutableMap.copyOf(functions);
    }

    private ImmutableMap<String, ShaderStruct> parseStructs() {
        Matcher matcher = ShaderStruct.struct.matcher(this.source);
        ImmutableMap.Builder structs = ImmutableMap.builder();
        while (matcher.find()) {
            Span self = Span.fromMatcher(this, matcher);
            Span name = Span.fromMatcher(this, matcher, 1);
            Span body = Span.fromMatcher(this, matcher, 2);
            ShaderStruct shaderStruct = new ShaderStruct(self, name, body);
            structs.put((Object)name.get(), (Object)shaderStruct);
        }
        return structs.build();
    }

    private ImmutableList<Import> parseImports(List<Span> elisions) {
        Matcher uses = includePattern.matcher(this.source);
        ArrayList<Import> imports = new ArrayList<Import>();
        while (uses.find()) {
            Span use = Span.fromMatcher(this, uses);
            Span file = Span.fromMatcher(this, uses, 1);
            imports.add(new Import(Resolver.INSTANCE, use, file));
            elisions.add(use);
        }
        return ImmutableList.copyOf(imports);
    }

    private int findEndOfBlock(int start) {
        int blockDepth = 0;
        for (int i = start + 1; i < this.source.length(); ++i) {
            char ch = this.source.charAt(i);
            if (ch == '{') {
                ++blockDepth;
            } else if (ch == '}') {
                --blockDepth;
            }
            if (blockDepth >= 0) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.name.toString();
    }
}

