/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.core.model.BakedModelBuilder;
import com.jozufozu.flywheel.core.model.Bufferable;
import com.jozufozu.flywheel.core.model.ShadeSeparatedBufferBuilder;
import com.jozufozu.flywheel.core.model.ShadeSeparatingVertexConsumer;
import com.jozufozu.flywheel.core.model.WorldModelBuilder;
import com.jozufozu.flywheel.util.transform.TransformStack;
import java.util.Collection;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3499;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_778;

public class ModelUtil {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    public static ShadeSeparatedBufferBuilder getBufferBuilder(Bufferable bufferable) {
        class_778 blockRenderer = class_310.method_1551().method_1541().method_3350();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        objects.begin();
        bufferable.bufferInto(blockRenderer, objects.shadeSeparatingWrapper, objects.random);
        objects.end();
        return objects.separatedBufferBuilder;
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilder(class_1087 model, class_2680 referenceState, class_4587 poseStack) {
        return new BakedModelBuilder(model).withReferenceState(referenceState).withPoseStack(poseStack).build();
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilder(class_1920 renderWorld, class_1087 model, class_2680 referenceState, class_4587 poseStack) {
        return new BakedModelBuilder(model).withReferenceState(referenceState).withPoseStack(poseStack).withRenderWorld(renderWorld).build();
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilderFromTemplate(class_1920 renderWorld, class_1921 layer, Collection<class_3499.class_3501> blocks) {
        return new WorldModelBuilder(layer).withRenderWorld(renderWorld).withBlocks(blocks).build();
    }

    public static ShadeSeparatedBufferBuilder getBufferBuilderFromTemplate(class_1920 renderWorld, class_1921 layer, Collection<class_3499.class_3501> blocks, class_4587 poseStack) {
        return new WorldModelBuilder(layer).withRenderWorld(renderWorld).withBlocks(blocks).withPoseStack(poseStack).build();
    }

    public static Supplier<class_4587> rotateToFace(class_2350 facing) {
        return () -> {
            class_4587 stack = new class_4587();
            ((TransformStack)((TransformStack)TransformStack.cast(stack).centre()).rotateToFace(facing.method_10153())).unCentre();
            return stack;
        };
    }

    private static class ThreadLocalObjects {
        public final Random random = new Random();
        public final ShadeSeparatingVertexConsumer shadeSeparatingWrapper = new ShadeSeparatingVertexConsumer();
        public final ShadeSeparatedBufferBuilder separatedBufferBuilder = new ShadeSeparatedBufferBuilder(512);
        public final class_287 unshadedBuilder = new class_287(512);

        private ThreadLocalObjects() {
        }

        private void begin() {
            this.separatedBufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
            this.unshadedBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1590);
            this.shadeSeparatingWrapper.prepare((class_4588)this.separatedBufferBuilder, (class_4588)this.unshadedBuilder);
        }

        private void end() {
            this.shadeSeparatingWrapper.clear();
            this.unshadedBuilder.method_1326();
            this.separatedBufferBuilder.appendUnshadedVertices(this.unshadedBuilder);
            this.separatedBufferBuilder.method_1326();
        }
    }
}

