/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.hardcoded;

import com.jozufozu.flywheel.core.hardcoded.ModelPart;
import com.jozufozu.flywheel.core.vertex.PosTexNormalWriterUnsafe;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1058;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_2350;
import net.minecraft.class_4581;

public class PartBuilder {
    private final float sizeU;
    private final float sizeV;
    private class_1058 sprite;
    private final List<CuboidBuilder> cuboids = new ArrayList<CuboidBuilder>();
    private final String name;

    public PartBuilder(String name, int sizeU, int sizeV) {
        this.name = name;
        this.sizeU = sizeU;
        this.sizeV = sizeV;
    }

    public PartBuilder sprite(class_1058 sprite) {
        this.sprite = sprite;
        return this;
    }

    public CuboidBuilder cuboid() {
        return new CuboidBuilder(this);
    }

    public ModelPart build() {
        return new ModelPart(this.cuboids, this.name);
    }

    private PartBuilder addCuboid(CuboidBuilder builder) {
        this.cuboids.add(builder);
        return this;
    }

    public static class CuboidBuilder {
        class_1058 sprite;
        Set<class_2350> visibleFaces = EnumSet.allOf(class_2350.class);
        int textureOffsetU;
        int textureOffsetV;
        float posX1;
        float posY1;
        float posZ1;
        float posX2;
        float posY2;
        float posZ2;
        boolean invertYZ;
        boolean useRotation;
        float rotationX;
        float rotationY;
        float rotationZ;
        final PartBuilder partBuilder;

        CuboidBuilder(PartBuilder partBuilder) {
            this.partBuilder = partBuilder;
            this.sprite = partBuilder.sprite;
        }

        public CuboidBuilder textureOffset(int u, int v) {
            this.textureOffsetU = u;
            this.textureOffsetV = v;
            return this;
        }

        public CuboidBuilder start(float x, float y, float z) {
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            return this;
        }

        public CuboidBuilder end(float x, float y, float z) {
            this.posX2 = x;
            this.posY2 = y;
            this.posZ2 = z;
            return this;
        }

        public CuboidBuilder size(float x, float y, float z) {
            this.posX2 = this.posX1 + x;
            this.posY2 = this.posY1 + y;
            this.posZ2 = this.posZ1 + z;
            return this;
        }

        public CuboidBuilder shift(float x, float y, float z) {
            this.posX1 -= x;
            this.posY1 -= y;
            this.posZ1 -= z;
            this.posX2 -= x;
            this.posY2 -= y;
            this.posZ2 -= z;
            return this;
        }

        public CuboidBuilder rotate(float x, float y, float z) {
            this.useRotation = true;
            this.rotationX = x;
            this.rotationY = y;
            this.rotationZ = z;
            return this;
        }

        public CuboidBuilder rotateX(float x) {
            this.useRotation = true;
            this.rotationX = x;
            return this;
        }

        public CuboidBuilder rotateY(float y) {
            this.useRotation = true;
            this.rotationY = y;
            return this;
        }

        public CuboidBuilder rotateZ(float z) {
            this.useRotation = true;
            this.rotationZ = z;
            return this;
        }

        public CuboidBuilder sprite(class_1058 sprite) {
            this.sprite = sprite;
            return this;
        }

        public CuboidBuilder invertYZ() {
            this.invertYZ = true;
            return this;
        }

        public PartBuilder endCuboid() {
            return this.partBuilder.addCuboid(this);
        }

        public int vertices() {
            return this.visibleFaces.size() * 4;
        }

        public void buffer(PosTexNormalWriterUnsafe buffer) {
            float sizeX = this.posX2 - this.posX1;
            float sizeY = this.posY2 - this.posY1;
            float sizeZ = this.posZ2 - this.posZ1;
            float posX1 = this.posX1 / 16.0f;
            float posY1 = this.posY1 / 16.0f;
            float posZ1 = this.posZ1 / 16.0f;
            float posX2 = this.posX2 / 16.0f;
            float posY2 = this.posY2 / 16.0f;
            float posZ2 = this.posZ2 / 16.0f;
            class_1160 lll = new class_1160(posX1, posY1, posZ1);
            class_1160 hll = new class_1160(posX2, posY1, posZ1);
            class_1160 hhl = new class_1160(posX2, posY2, posZ1);
            class_1160 lhl = new class_1160(posX1, posY2, posZ1);
            class_1160 llh = new class_1160(posX1, posY1, posZ2);
            class_1160 hlh = new class_1160(posX2, posY1, posZ2);
            class_1160 hhh = new class_1160(posX2, posY2, posZ2);
            class_1160 lhh = new class_1160(posX1, posY2, posZ2);
            class_1160 down = class_2350.field_11033.method_23955();
            class_1160 up = class_2350.field_11036.method_23955();
            class_1160 west = class_2350.field_11039.method_23955();
            class_1160 north = class_2350.field_11043.method_23955();
            class_1160 east = class_2350.field_11034.method_23955();
            class_1160 south = class_2350.field_11035.method_23955();
            if (this.useRotation) {
                class_4581 matrix3f = new class_4581(new class_1158(this.rotationX, this.rotationY, this.rotationZ, false));
                lll.method_23215(matrix3f);
                hll.method_23215(matrix3f);
                hhl.method_23215(matrix3f);
                lhl.method_23215(matrix3f);
                llh.method_23215(matrix3f);
                hlh.method_23215(matrix3f);
                hhh.method_23215(matrix3f);
                lhh.method_23215(matrix3f);
                down.method_23215(matrix3f);
                up.method_23215(matrix3f);
                west.method_23215(matrix3f);
                north.method_23215(matrix3f);
                east.method_23215(matrix3f);
                south.method_23215(matrix3f);
            }
            float f4 = this.getU(this.textureOffsetU);
            float f5 = this.getU((float)this.textureOffsetU + sizeZ);
            float f6 = this.getU((float)this.textureOffsetU + sizeZ + sizeX);
            float f7 = this.getU((float)this.textureOffsetU + sizeZ + sizeX + sizeX);
            float f8 = this.getU((float)this.textureOffsetU + sizeZ + sizeX + sizeZ);
            float f9 = this.getU((float)this.textureOffsetU + sizeZ + sizeX + sizeZ + sizeX);
            float f10 = this.getV(this.textureOffsetV);
            float f11 = this.getV((float)this.textureOffsetV + sizeZ);
            float f12 = this.getV((float)this.textureOffsetV + sizeZ + sizeY);
            if (this.invertYZ) {
                this.quad(buffer, new class_1160[]{hlh, llh, lll, hll}, f6, f11, f7, f10, down);
                this.quad(buffer, new class_1160[]{hhl, lhl, lhh, hhh}, f5, f10, f6, f11, up);
                this.quad(buffer, new class_1160[]{lll, llh, lhh, lhl}, f5, f12, f4, f11, west);
                this.quad(buffer, new class_1160[]{hll, lll, lhl, hhl}, f9, f12, f8, f11, north);
                this.quad(buffer, new class_1160[]{hlh, hll, hhl, hhh}, f8, f12, f6, f11, east);
                this.quad(buffer, new class_1160[]{llh, hlh, hhh, lhh}, f6, f12, f5, f11, south);
            } else {
                this.quad(buffer, new class_1160[]{hlh, llh, lll, hll}, f5, f10, f6, f11, down);
                this.quad(buffer, new class_1160[]{hhl, lhl, lhh, hhh}, f6, f11, f7, f10, up);
                this.quad(buffer, new class_1160[]{lll, llh, lhh, lhl}, f4, f11, f5, f12, west);
                this.quad(buffer, new class_1160[]{hll, lll, lhl, hhl}, f5, f11, f6, f12, north);
                this.quad(buffer, new class_1160[]{hlh, hll, hhl, hhh}, f6, f11, f8, f12, east);
                this.quad(buffer, new class_1160[]{llh, hlh, hhh, lhh}, f8, f11, f9, f12, south);
            }
        }

        public void quad(PosTexNormalWriterUnsafe buffer, class_1160[] vertices, float minU, float minV, float maxU, float maxV, class_1160 normal) {
            buffer.putVertex(vertices[0].method_4943(), vertices[0].method_4945(), vertices[0].method_4947(), normal.method_4943(), normal.method_4945(), normal.method_4947(), maxU, minV);
            buffer.putVertex(vertices[1].method_4943(), vertices[1].method_4945(), vertices[1].method_4947(), normal.method_4943(), normal.method_4945(), normal.method_4947(), minU, minV);
            buffer.putVertex(vertices[2].method_4943(), vertices[2].method_4945(), vertices[2].method_4947(), normal.method_4943(), normal.method_4945(), normal.method_4947(), minU, maxV);
            buffer.putVertex(vertices[3].method_4943(), vertices[3].method_4945(), vertices[3].method_4947(), normal.method_4943(), normal.method_4945(), normal.method_4947(), maxU, maxV);
        }

        public float getU(float u) {
            if (this.sprite != null) {
                return this.sprite.method_4580((double)(u * 16.0f / this.partBuilder.sizeU));
            }
            return u / this.partBuilder.sizeU;
        }

        public float getV(float v) {
            if (this.sprite != null) {
                return this.sprite.method_4570((double)(v * 16.0f / this.partBuilder.sizeV));
            }
            return v / this.partBuilder.sizeV;
        }
    }
}

