/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.config;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.config.BackendType;
import com.jozufozu.flywheel.config.FlwConfig;
import com.jozufozu.flywheel.config.Option;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public final class FlwCommands {
    public static void init(FlwConfig config) {
        ConfigCommandBuilder commandBuilder = new ConfigCommandBuilder("flywheel");
        commandBuilder.addOption(config.backend, (builder, option) -> FlwCommands.enumOptionCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, config, option, BackendType::getShortName, (source, value) -> source.sendFeedback(FlwCommands.getEngineMessage(value)), (source, value) -> {
            source.sendFeedback(FlwCommands.getEngineMessage(value));
            Backend.reloadWorldRenderers();
        }));
        commandBuilder.addOption(config.debugNormals, (builder, option) -> FlwCommands.booleanOptionCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, config, option, (source, value) -> {
            class_5250 text = new class_2585("Normal debug mode is currently: ").method_10852((class_2561)FlwCommands.boolToText(value));
            source.sendFeedback((class_2561)text);
        }, (source, value) -> {
            class_5250 text = FlwCommands.boolToText(value).method_10852((class_2561)new class_2585(" normal debug mode").method_27692(class_124.field_1068));
            source.sendFeedback((class_2561)text);
        }));
        commandBuilder.addOption(config.limitUpdates, (builder, option) -> FlwCommands.booleanOptionCommand((LiteralArgumentBuilder<FabricClientCommandSource>)builder, config, option, (source, value) -> {
            class_5250 text = new class_2585("Update limiting is currently: ").method_10852((class_2561)FlwCommands.boolToText(value));
            source.sendFeedback((class_2561)text);
        }, (source, value) -> {
            class_5250 text = FlwCommands.boolToText(value).method_10852((class_2561)new class_2585(" update limiting.").method_27692(class_124.field_1068));
            source.sendFeedback((class_2561)text);
        }));
        commandBuilder.build();
    }

    public static void booleanOptionCommand(LiteralArgumentBuilder<FabricClientCommandSource> builder, FlwConfig config, Option<Boolean> option, BiConsumer<FabricClientCommandSource, Boolean> displayAction, BiConsumer<FabricClientCommandSource, Boolean> setAction) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(context -> {
            displayAction.accept((FabricClientCommandSource)context.getSource(), (Boolean)option.get());
            return 1;
        })).then(ClientCommandManager.literal((String)"on").executes(context -> {
            option.set(true);
            setAction.accept((FabricClientCommandSource)context.getSource(), (Boolean)option.get());
            config.save();
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            option.set(false);
            setAction.accept((FabricClientCommandSource)context.getSource(), (Boolean)option.get());
            config.save();
            return 1;
        }));
    }

    public static <E extends Enum<E>> void enumOptionCommand(LiteralArgumentBuilder<FabricClientCommandSource> builder, FlwConfig config, Option.EnumOption<E> option, Function<E, String> nameFunc, BiConsumer<FabricClientCommandSource, E> displayAction, BiConsumer<FabricClientCommandSource, E> setAction) {
        builder.executes(context -> {
            displayAction.accept((FabricClientCommandSource)context.getSource(), (Enum)option.get());
            return 1;
        });
        for (Enum constant : (Enum[])option.getEnumType().getEnumConstants()) {
            builder.then(ClientCommandManager.literal((String)nameFunc.apply(constant)).executes(context -> {
                option.set(constant);
                setAction.accept((FabricClientCommandSource)context.getSource(), (Enum)option.get());
                config.save();
                return 1;
            }));
        }
    }

    public static class_5250 boolToText(boolean b) {
        return b ? new class_2585("enabled").method_27692(class_124.field_1077) : new class_2585("disabled").method_27692(class_124.field_1061);
    }

    public static class_2561 getEngineMessage(@NotNull BackendType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BackendType.OFF -> new class_2585("Disabled Flywheel").method_27692(class_124.field_1061);
            case BackendType.INSTANCING -> new class_2585("Using Instancing Engine").method_27692(class_124.field_1060);
            case BackendType.BATCHING -> new class_2585("Using Batching Engine").method_27692(class_124.field_1060);
        };
    }

    public static class ConfigCommandBuilder {
        protected LiteralArgumentBuilder<FabricClientCommandSource> command;

        public ConfigCommandBuilder(String baseLiteral) {
            this.command = ClientCommandManager.literal((String)baseLiteral);
        }

        public <T extends Option<?>> void addOption(T option, BiConsumer<LiteralArgumentBuilder<FabricClientCommandSource>, T> consumer) {
            this.addOption(option, option.getKey(), consumer);
        }

        public <T extends Option<?>> void addOption(T option, String subcommand, BiConsumer<LiteralArgumentBuilder<FabricClientCommandSource>, T> consumer) {
            LiteralArgumentBuilder builder = ClientCommandManager.literal((String)subcommand);
            consumer.accept((LiteralArgumentBuilder<FabricClientCommandSource>)builder, (LiteralArgumentBuilder<FabricClientCommandSource>)option);
            this.command.then((ArgumentBuilder)builder);
        }

        public void build() {
            ClientCommandManager.DISPATCHER.register(this.command);
        }
    }
}

