/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public enum BackendType {
    OFF("Off"),
    BATCHING("Parallel Batching"),
    INSTANCING("GL33 Instanced Arrays");

    private static final Map<String, BackendType> lookup;
    private final String properName;

    private BackendType(String properName) {
        this.properName = properName;
    }

    public String getProperName() {
        return this.properName;
    }

    public String getShortName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Nullable
    public static BackendType byName(String name) {
        return lookup.get(name);
    }

    public static Collection<String> validNames() {
        return lookup.keySet();
    }

    static {
        lookup = new HashMap<String, BackendType>();
        for (BackendType value : BackendType.values()) {
            lookup.put(value.name().toLowerCase(Locale.ROOT), value);
        }
    }
}

