/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.Engine;
import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.instancing.ParallelTaskEngine;
import com.jozufozu.flywheel.backend.instancing.batching.BatchingEngine;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstanceManager;
import com.jozufozu.flywheel.backend.instancing.entity.EntityInstanceManager;
import com.jozufozu.flywheel.backend.instancing.instancing.InstancingEngine;
import com.jozufozu.flywheel.config.BackendType;
import com.jozufozu.flywheel.core.Contexts;
import com.jozufozu.flywheel.core.shader.WorldProgram;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.util.ClientLevelExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class InstanceWorld {
    protected final Engine engine;
    protected final InstanceManager<class_1297> entityInstanceManager;
    protected final InstanceManager<class_2586> blockEntityInstanceManager;
    public final ParallelTaskEngine taskEngine;

    public static InstanceWorld create(class_1936 level) {
        return switch (Backend.getBackendType()) {
            case BackendType.INSTANCING -> {
                InstancingEngine<WorldProgram> manager = InstancingEngine.builder(Contexts.WORLD).build();
                EntityInstanceManager entityInstanceManager = new EntityInstanceManager(manager);
                BlockEntityInstanceManager blockEntityInstanceManager = new BlockEntityInstanceManager(manager);
                manager.addListener(entityInstanceManager);
                manager.addListener(blockEntityInstanceManager);
                yield new InstanceWorld(manager, entityInstanceManager, blockEntityInstanceManager);
            }
            case BackendType.BATCHING -> {
                BatchingEngine manager = new BatchingEngine();
                EntityInstanceManager entityInstanceManager = new EntityInstanceManager(manager);
                BlockEntityInstanceManager blockEntityInstanceManager = new BlockEntityInstanceManager(manager);
                yield new InstanceWorld(manager, entityInstanceManager, blockEntityInstanceManager);
            }
            default -> throw new IllegalArgumentException("Unknown engine type");
        };
    }

    public InstanceWorld(Engine engine, InstanceManager<class_1297> entityInstanceManager, InstanceManager<class_2586> blockEntityInstanceManager) {
        this.engine = engine;
        this.entityInstanceManager = entityInstanceManager;
        this.blockEntityInstanceManager = blockEntityInstanceManager;
        this.taskEngine = Backend.getTaskEngine();
    }

    public InstanceManager<class_1297> getEntityInstanceManager() {
        return this.entityInstanceManager;
    }

    public InstanceManager<class_2586> getBlockEntityInstanceManager() {
        return this.blockEntityInstanceManager;
    }

    public void delete() {
        this.engine.delete();
        this.entityInstanceManager.detachLightListeners();
        this.blockEntityInstanceManager.detachLightListeners();
    }

    public void beginFrame(BeginFrameEvent event) {
        this.engine.beginFrame(event.getCamera());
        this.taskEngine.syncPoint();
        this.blockEntityInstanceManager.beginFrame(this.taskEngine, event.getCamera());
        this.entityInstanceManager.beginFrame(this.taskEngine, event.getCamera());
    }

    public void tick() {
        class_1297 renderViewEntity;
        class_310 mc = class_310.method_1551();
        Object object = renderViewEntity = mc.field_1719 != null ? mc.field_1719 : mc.field_1724;
        if (renderViewEntity == null) {
            return;
        }
        this.blockEntityInstanceManager.tick(this.taskEngine, renderViewEntity.method_23317(), renderViewEntity.method_23318(), renderViewEntity.method_23321());
        this.entityInstanceManager.tick(this.taskEngine, renderViewEntity.method_23317(), renderViewEntity.method_23318(), renderViewEntity.method_23321());
    }

    public void renderLayer(RenderLayerEvent event) {
        this.taskEngine.syncPoint();
        event.stack.method_22903();
        event.stack.method_22904(-event.camX, -event.camY, -event.camZ);
        this.engine.render(this.taskEngine, event);
        event.stack.method_22909();
    }

    public void loadEntities(class_638 world) {
        ClientLevelExtension.cast(world).flywheel$getAllLoadedEntities().forEach(this.entityInstanceManager::add);
    }
}

