/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.backend.instancing.DrawBuffer;
import com.jozufozu.flywheel.backend.instancing.RenderTypeExtension;
import com.jozufozu.flywheel.backend.model.BufferBuilderExtension;
import com.jozufozu.flywheel.backend.model.DirectVertexConsumer;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1921;
import net.minecraft.class_287;

public class BatchDrawingTracker {
    protected final Set<class_1921> activeTypes = new HashSet<class_1921>();
    private final class_287 scratch = new class_287(8);

    public BatchDrawingTracker() {
        ((BufferBuilderExtension)this.scratch).flywheel$freeBuffer();
    }

    public DirectVertexConsumer getDirectConsumer(class_1921 renderType, int vertexCount) {
        this.activeTypes.add(renderType);
        return RenderTypeExtension.getDrawBuffer(renderType).begin(vertexCount);
    }

    public void endBatch() {
        for (class_1921 renderType : this.activeTypes) {
            this._draw(renderType);
        }
        this.activeTypes.clear();
    }

    public void endBatch(class_1921 renderType) {
        this._draw(renderType);
        this.activeTypes.remove(renderType);
    }

    public void clear() {
        for (class_1921 type : this.activeTypes) {
            RenderTypeExtension.getDrawBuffer(type).reset();
        }
        this.activeTypes.clear();
    }

    private void _draw(class_1921 renderType) {
        DrawBuffer drawBuffer = RenderTypeExtension.getDrawBuffer(renderType);
        BufferBuilderExtension scratch = (BufferBuilderExtension)this.scratch;
        if (drawBuffer.hasVertices()) {
            drawBuffer.inject(scratch);
            renderType.method_23012(this.scratch, 0, 0, 0);
            drawBuffer.reset();
        }
    }
}

