/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.jozufozu.flywheel.backend.Backend;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4604;

public final class ShadersModHandler {
    public static final String OPTIFINE_ROOT_PACKAGE = "net.optifine";
    public static final String SHADER_PACKAGE = "net.optifine.shaders";
    private static final boolean isIrisLoaded;
    private static final boolean isOptifineInstalled;
    private static final InternalHandler internalHandler;

    private ShadersModHandler() {
    }

    public static void init() {
    }

    public static boolean isOptifineInstalled() {
        return isOptifineInstalled;
    }

    public static boolean isIrisLoaded() {
        return isIrisLoaded;
    }

    public static boolean isShaderPackInUse() {
        return internalHandler.isShaderPackInUse();
    }

    public static boolean isRenderingShadowPass() {
        return internalHandler.isRenderingShadowPass();
    }

    static {
        Package optifinePackage = Package.getPackage(OPTIFINE_ROOT_PACKAGE);
        isOptifineInstalled = optifinePackage != null;
        isIrisLoaded = FabricLoader.getInstance().isModLoaded("iris");
        if (isOptifineInstalled) {
            Backend.LOGGER.info("Optifine detected.");
            internalHandler = new Optifine();
        } else if (isIrisLoaded) {
            Backend.LOGGER.info("Iris detected.");
            internalHandler = new Iris();
        } else {
            Backend.LOGGER.info("No shaders mod detected.");
            internalHandler = new InternalHandler(){};
        }
    }

    private static interface InternalHandler {
        default public boolean isShaderPackInUse() {
            return false;
        }

        default public boolean isRenderingShadowPass() {
            return false;
        }
    }

    private static class Optifine
    implements InternalHandler {
        private final BooleanSupplier shadersEnabledSupplier = Optifine.createShadersEnabledSupplier();
        private final BooleanSupplier shadowPassSupplier = Optifine.createShadowPassSupplier();
        private final FrustumConstructor shadowFrustumConstructor = Optifine.createShadowFrustumConstructor();

        Optifine() {
        }

        @Override
        public boolean isShaderPackInUse() {
            return this.shadersEnabledSupplier.getAsBoolean();
        }

        @Override
        public boolean isRenderingShadowPass() {
            return this.shadowPassSupplier.getAsBoolean();
        }

        @Nullable
        public class_4604 createShadowFrustum(class_4184 camera, float partialTicks) {
            class_4604 frustum = this.shadowFrustumConstructor.create(camera, partialTicks);
            if (frustum != null) {
                class_243 position = camera.method_19326();
                frustum.method_23088(position.field_1352, position.field_1351, position.field_1350);
            }
            return frustum;
        }

        private static FrustumConstructor createShadowFrustumConstructor() {
            try {
                Class<?> ofShaders = Class.forName("net.optifine.shaders.ShadersRender");
                Method method = ofShaders.getDeclaredMethod("makeShadowFrustum", class_4184.class, Float.TYPE);
                method.setAccessible(true);
                return (cam, pt) -> {
                    try {
                        return (class_4604)method.invoke(null, cam, Float.valueOf(pt));
                    }
                    catch (Exception ignored) {
                        return null;
                    }
                };
            }
            catch (Exception ignored) {
                return ($, $$) -> null;
            }
        }

        private static BooleanSupplier createShadowPassSupplier() {
            try {
                Class<?> ofShaders = Class.forName("net.optifine.shaders.Shaders");
                Field field = ofShaders.getDeclaredField("isShadowPass");
                field.setAccessible(true);
                return () -> {
                    try {
                        return field.getBoolean(null);
                    }
                    catch (IllegalAccessException ignored) {
                        return false;
                    }
                };
            }
            catch (Exception ignored) {
                return () -> false;
            }
        }

        private static BooleanSupplier createShadersEnabledSupplier() {
            try {
                Class<?> ofShaders = Class.forName("net.optifine.shaders.Shaders");
                Field field = ofShaders.getDeclaredField("shaderPackLoaded");
                field.setAccessible(true);
                return () -> {
                    try {
                        return field.getBoolean(null);
                    }
                    catch (IllegalAccessException ignored) {
                        return false;
                    }
                };
            }
            catch (Exception ignored) {
                return () -> false;
            }
        }

        @FunctionalInterface
        public static interface FrustumConstructor {
            @Nullable
            public class_4604 create(class_4184 var1, float var2);
        }
    }

    private static class Iris
    implements InternalHandler {
        private Iris() {
        }

        @Override
        public boolean isShaderPackInUse() {
            return IrisApi.getInstance().isShaderPackInUse();
        }

        @Override
        public boolean isRenderingShadowPass() {
            return IrisApi.getInstance().isRenderingShadowPass();
        }
    }
}

