/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.util.text.ITextCollection;

public class TextMapBuilder<K>
implements ITextCollection {
    private LinkedHashMap<K, List<class_2561>> lines = new LinkedHashMap();
    private Predicate<String> filter;

    public TextMapBuilder<K> setFilter(Predicate<String> predicate) {
        this.filter = predicate;
        return this;
    }

    private void addNewLine(K key, class_2561 line) {
        ArrayList<class_2561> newLine = new ArrayList<class_2561>();
        newLine.add(line);
        this.addNewLine(key, newLine);
    }

    private void addNewLine(K key, List<class_2561> line) {
        if (this.filter != null) {
            StringBuilder builder = new StringBuilder();
            for (class_2561 component : line) {
                builder.append(component.getString());
            }
            if (!this.filter.test(builder.toString())) {
                return;
            }
        }
        this.lines.put(key, line);
    }

    public TextMapBuilder<K> addComponent(K key, class_2561 component) {
        this.addNewLine(key, component);
        return this;
    }

    public TextMapBuilder<K> addComponent(K[] array, Function<K, class_2561> toComponent) {
        for (K k : array) {
            this.addNewLine(k, toComponent.apply(k));
        }
        return this;
    }

    public TextMapBuilder<K> addComponent(Collection<K> collection, Function<K, class_2561> toComponent) {
        for (K t : collection) {
            this.addNewLine(t, toComponent.apply(t));
        }
        return this;
    }

    public TextMapBuilder<K> addEntrySet(Set<Map.Entry<String, K>> map, Function<Map.Entry<String, K>, class_2561> toComponent) {
        for (Map.Entry<String, K> entry : map) {
            this.addNewLine(entry.getValue(), toComponent.apply(entry));
        }
        return this;
    }

    public TextMapBuilder<K> addComponents(Collection<K> collection, Function<K, List<class_2561>> toComponent) {
        for (K t : collection) {
            this.addNewLine(t, toComponent.apply(t));
        }
        return this;
    }

    @Override
    public CompiledText[] build() {
        CompiledText[] lines = new CompiledText[this.lines.size()];
        int i = 0;
        for (List<class_2561> text : this.lines.values()) {
            lines[i] = CompiledText.createAnySize();
            lines[i].setText(text);
            ++i;
        }
        return lines;
    }

    public List<K> keys() {
        return new ArrayList<K>(this.lines.keySet());
    }
}

