/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.network.type;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1160;
import net.minecraft.class_1161;
import net.minecraft.class_128;
import net.minecraft.class_148;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3530;
import net.minecraft.class_4615;
import net.minecraft.class_5250;
import team.creative.creativecore.common.network.type.NetworkFieldType;
import team.creative.creativecore.common.network.type.NetworkFieldTypeClass;
import team.creative.creativecore.common.network.type.NetworkFieldTypeSpecial;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.filter.Filter;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.creativecore.common.util.math.vec.Vec1f;
import team.creative.creativecore.common.util.math.vec.Vec2d;
import team.creative.creativecore.common.util.math.vec.Vec2f;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.registry.exception.RegistryException;
import team.creative.creativecore.common.util.text.AdvancedComponent;

public class NetworkFieldTypes {
    private static final Gson GSON = new Gson();
    private static final List<NetworkFieldTypeSpecial> specialParsers = new ArrayList<NetworkFieldTypeSpecial>();
    private static final HashMap<Class<?>, NetworkFieldTypeClass<?>> parsers = new HashMap();

    public static <T> void register(NetworkFieldTypeClass<T> parser, Class<T> classType) {
        parsers.put(classType, parser);
    }

    public static <T> void register(NetworkFieldTypeClass<T> parser, Class<? extends T> ... classType) {
        for (Class<? extends T> clazz : classType) {
            parsers.put(clazz, parser);
        }
    }

    public static <T> void register(NetworkFieldTypeSpecial parser) {
        specialParsers.add(parser);
    }

    public static NetworkFieldType<?> get(Field field) {
        return NetworkFieldTypes.get(field.getType(), field.getGenericType());
    }

    public static <T> NetworkFieldType<T> get(Class<T> classType) {
        try {
            NetworkFieldType parser = parsers.get(classType);
            if (parser != null) {
                return parser;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        throw new RuntimeException("No field type found for " + classType.getSimpleName());
    }

    public static NetworkFieldType get(Class classType, Type genericType) {
        try {
            NetworkFieldType parser = parsers.get(classType);
            if (parser != null) {
                return parser;
            }
            for (int i = 0; i < specialParsers.size(); ++i) {
                if (!NetworkFieldTypes.specialParsers.get((int)i).predicate.test(classType, genericType)) continue;
                return specialParsers.get(i);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        throw new RuntimeException("No field type found for " + classType.getSimpleName());
    }

    public static <T> void write(Class<T> clazz, T object, class_2540 buffer) {
        NetworkFieldTypes.get(clazz).write(object, clazz, null, buffer);
    }

    public static <T> T read(Class<T> clazz, class_2540 buffer) {
        return NetworkFieldTypes.get(clazz).read(clazz, null, buffer);
    }

    static {
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Boolean>(){

            @Override
            protected void writeContent(Boolean content, class_2540 buffer) {
                buffer.writeBoolean(content.booleanValue());
            }

            @Override
            protected Boolean readContent(class_2540 buffer) {
                return buffer.readBoolean();
            }
        }, Boolean.TYPE, Boolean.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Byte>(){

            @Override
            protected void writeContent(Byte content, class_2540 buffer) {
                buffer.writeByte((int)content.byteValue());
            }

            @Override
            protected Byte readContent(class_2540 buffer) {
                return buffer.readByte();
            }
        }, Byte.TYPE, Byte.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Short>(){

            @Override
            protected void writeContent(Short content, class_2540 buffer) {
                buffer.writeShort((int)content.shortValue());
            }

            @Override
            protected Short readContent(class_2540 buffer) {
                return buffer.readShort();
            }
        }, Short.TYPE, Short.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Integer>(){

            @Override
            protected void writeContent(Integer content, class_2540 buffer) {
                buffer.writeInt(content.intValue());
            }

            @Override
            protected Integer readContent(class_2540 buffer) {
                return buffer.readInt();
            }
        }, Integer.TYPE, Integer.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Long>(){

            @Override
            protected void writeContent(Long content, class_2540 buffer) {
                buffer.writeLong(content.longValue());
            }

            @Override
            protected Long readContent(class_2540 buffer) {
                return buffer.readLong();
            }
        }, Long.TYPE, Long.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Float>(){

            @Override
            protected void writeContent(Float content, class_2540 buffer) {
                buffer.writeFloat(content.floatValue());
            }

            @Override
            protected Float readContent(class_2540 buffer) {
                return Float.valueOf(buffer.readFloat());
            }
        }, Float.TYPE, Float.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Double>(){

            @Override
            protected void writeContent(Double content, class_2540 buffer) {
                buffer.writeDouble(content.doubleValue());
            }

            @Override
            protected Double readContent(class_2540 buffer) {
                return buffer.readDouble();
            }
        }, Double.TYPE, Double.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2338>(){

            @Override
            protected void writeContent(class_2338 content, class_2540 buffer) {
                buffer.method_10807(content);
            }

            @Override
            protected class_2338 readContent(class_2540 buffer) {
                return buffer.method_10811();
            }
        }, class_2338.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<String>(){

            @Override
            protected void writeContent(String content, class_2540 buffer) {
                buffer.method_10814(content);
            }

            @Override
            protected String readContent(class_2540 buffer) {
                return buffer.method_10800(Short.MAX_VALUE);
            }
        }, String.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2561>(){

            @Override
            protected void writeContent(class_2561 content, class_2540 buffer) {
                buffer.method_10805(content);
            }

            @Override
            protected class_2561 readContent(class_2540 buffer) {
                return buffer.method_10808();
            }
        }, class_2561.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2487>(){

            @Override
            protected void writeContent(class_2487 content, class_2540 buffer) {
                buffer.method_10794(content);
            }

            @Override
            protected class_2487 readContent(class_2540 buffer) {
                return buffer.method_10798();
            }
        }, class_2487.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_1799>(){

            @Override
            protected void writeContent(class_1799 content, class_2540 buffer) {
                buffer.method_10793(content);
            }

            @Override
            protected class_1799 readContent(class_2540 buffer) {
                return buffer.method_10819();
            }
        }, class_1799.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2960>(){

            @Override
            protected void writeContent(class_2960 content, class_2540 buffer) {
                buffer.method_10812(content);
            }

            @Override
            protected class_2960 readContent(class_2540 buffer) {
                return buffer.method_10810();
            }
        }, class_2960.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2680>(){

            @Override
            protected void writeContent(class_2680 content, class_2540 buffer) {
                buffer.writeInt(class_2248.method_9507((class_2680)content));
            }

            @Override
            protected class_2680 readContent(class_2540 buffer) {
                return class_2248.method_9531((int)buffer.readInt());
            }
        }, class_2680.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2248>(){

            @Override
            protected void writeContent(class_2248 content, class_2540 buffer) {
                buffer.method_10812(class_2378.field_11146.method_10221((Object)content));
            }

            @Override
            protected class_2248 readContent(class_2540 buffer) {
                return (class_2248)class_2378.field_11146.method_10223(buffer.method_10810());
            }
        }, class_2248.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_1792>(){

            @Override
            protected void writeContent(class_1792 content, class_2540 buffer) {
                buffer.method_10812(class_2378.field_11142.method_10221((Object)content));
            }

            @Override
            protected class_1792 readContent(class_2540 buffer) {
                return (class_1792)class_2378.field_11142.method_10223(buffer.method_10810());
            }
        }, class_1792.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_1161>(){

            @Override
            protected void writeContent(class_1161 content, class_2540 buffer) {
                buffer.writeDouble(content.field_5661);
                buffer.writeDouble(content.field_5660);
                buffer.writeDouble(content.field_5659);
            }

            @Override
            protected class_1161 readContent(class_2540 buffer) {
                return new class_1161(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, class_1161.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_243>(){

            @Override
            protected void writeContent(class_243 content, class_2540 buffer) {
                buffer.writeDouble(content.field_1352);
                buffer.writeDouble(content.field_1351);
                buffer.writeDouble(content.field_1350);
            }

            @Override
            protected class_243 readContent(class_2540 buffer) {
                return new class_243(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, class_243.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec1d>(){

            @Override
            protected void writeContent(Vec1d content, class_2540 buffer) {
                buffer.writeDouble(content.x);
            }

            @Override
            protected Vec1d readContent(class_2540 buffer) {
                return new Vec1d(buffer.readDouble());
            }
        }, Vec1d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec1f>(){

            @Override
            protected void writeContent(Vec1f content, class_2540 buffer) {
                buffer.writeFloat(content.x);
            }

            @Override
            protected Vec1f readContent(class_2540 buffer) {
                return new Vec1f(buffer.readFloat());
            }
        }, Vec1f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec2d>(){

            @Override
            protected void writeContent(Vec2d content, class_2540 buffer) {
                buffer.writeDouble(content.x);
                buffer.writeDouble(content.y);
            }

            @Override
            protected Vec2d readContent(class_2540 buffer) {
                return new Vec2d(buffer.readDouble(), buffer.readDouble());
            }
        }, Vec2d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec2f>(){

            @Override
            protected void writeContent(Vec2f content, class_2540 buffer) {
                buffer.writeFloat(content.x);
                buffer.writeFloat(content.y);
            }

            @Override
            protected Vec2f readContent(class_2540 buffer) {
                return new Vec2f(buffer.readFloat(), buffer.readFloat());
            }
        }, Vec2f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec3d>(){

            @Override
            protected void writeContent(Vec3d content, class_2540 buffer) {
                buffer.writeDouble(content.x);
                buffer.writeDouble(content.y);
                buffer.writeDouble(content.z);
            }

            @Override
            protected Vec3d readContent(class_2540 buffer) {
                return new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            }
        }, Vec3d.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Vec3f>(){

            @Override
            protected void writeContent(Vec3f content, class_2540 buffer) {
                buffer.writeFloat(content.x);
                buffer.writeFloat(content.y);
                buffer.writeFloat(content.z);
            }

            @Override
            protected Vec3f readContent(class_2540 buffer) {
                return new Vec3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        }, Vec3f.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_1160>(){

            @Override
            protected void writeContent(class_1160 content, class_2540 buffer) {
                buffer.writeFloat(content.method_4943());
                buffer.writeFloat(content.method_4945());
                buffer.writeFloat(content.method_4947());
            }

            @Override
            protected class_1160 readContent(class_2540 buffer) {
                return new class_1160(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        }, class_1160.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<UUID>(){

            @Override
            protected void writeContent(UUID content, class_2540 buffer) {
                buffer.method_10814(content.toString());
            }

            @Override
            protected UUID readContent(class_2540 buffer) {
                return UUID.fromString(buffer.method_10800(Short.MAX_VALUE));
            }
        }, UUID.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<JsonObject>(){

            @Override
            protected void writeContent(JsonObject content, class_2540 buffer) {
                buffer.method_10814(content.toString());
            }

            @Override
            protected JsonObject readContent(class_2540 buffer) {
                return (JsonObject)GSON.fromJson(buffer.method_10800(Short.MAX_VALUE), JsonObject.class);
            }
        }, JsonObject.class);
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial((x, y) -> x.isArray()){

            @Override
            public void write(Object content, Class classType, Type genericType, class_2540 buffer) {
                Class<?> subClass = classType.getComponentType();
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, null);
                int length = Array.getLength(content);
                buffer.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(Array.get(content, i), subClass, null, buffer);
                }
            }

            @Override
            public Object read(Class classType, Type genericType, class_2540 buffer) {
                int length = buffer.readInt();
                Class<?> subClass = classType.getComponentType();
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, null);
                Object object = Array.newInstance(subClass, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(object, i, subParser.read(subClass, null, buffer));
                }
                return object;
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial((x, y) -> x.equals(ArrayList.class) || x.equals(List.class)){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void write(Object content, Class classType, Type genericType, class_2540 buffer) {
                Type subType;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Class subClass = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, subType = types[0]);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = ((List)content).size();
                buffer.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    subParser.write(((List)content).get(i), subClass, subType, buffer);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Object read(Class classType, Type genericType, class_2540 buffer) {
                Type subType;
                if (!(genericType instanceof ParameterizedType)) throw new RuntimeException("Missing generic type");
                Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
                if (types.length != 1) throw new RuntimeException("Invalid generic type");
                Class subClass = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                NetworkFieldType subParser = NetworkFieldTypes.get(subClass, subType = types[0]);
                if (subParser == null) {
                    throw new RuntimeException("Invalid class type " + classType.getComponentType().getName());
                }
                int length = buffer.readInt();
                ArrayList list = new ArrayList(length);
                for (int j = 0; j < length; ++j) {
                    list.add(subParser.read(subClass, subType, buffer));
                }
                return list;
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeSpecial((x, y) -> x.isEnum()){

            @Override
            public void write(Object content, Class classType, Type genericType, class_2540 buffer) {
                buffer.method_10817((Enum)content);
            }

            @Override
            public Object read(Class classType, Type genericType, class_2540 buffer) {
                return buffer.method_10818(classType);
            }
        });
        NetworkFieldTypes.register(new NetworkFieldTypeClass<Filter>(){

            @Override
            protected void writeContent(Filter content, class_2540 buffer) {
                try {
                    buffer.method_10794(Filter.SERIALIZER.write(content));
                }
                catch (RegistryException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected Filter readContent(class_2540 buffer) {
                try {
                    return Filter.SERIALIZER.read(buffer.method_30617());
                }
                catch (RegistryException e) {
                    e.printStackTrace();
                    return Filter.or(new Filter[0]);
                }
            }
        }, Filter.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<BiFilter>(){

            @Override
            protected void writeContent(BiFilter content, class_2540 buffer) {
                try {
                    buffer.method_10794(BiFilter.SERIALIZER.write(content));
                }
                catch (RegistryException e) {
                    e.printStackTrace();
                }
            }

            @Override
            protected BiFilter readContent(class_2540 buffer) {
                try {
                    return BiFilter.SERIALIZER.read(buffer.method_30617());
                }
                catch (RegistryException e) {
                    e.printStackTrace();
                    return BiFilter.or(new BiFilter[0]);
                }
            }
        }, BiFilter.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2561>(){
            private static final Gson GSON = (Gson)class_156.method_656(() -> {
                GsonBuilder gsonbuilder = new GsonBuilder();
                gsonbuilder.disableHtmlEscaping();
                gsonbuilder.registerTypeHierarchyAdapter(class_2561.class, (Object)new AdvancedComponent.Serializer());
                gsonbuilder.registerTypeHierarchyAdapter(class_2583.class, (Object)new class_2583.class_2584());
                gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new class_3530());
                return gsonbuilder.create();
            });

            @Override
            protected void writeContent(class_2561 content, class_2540 buffer) {
                buffer.method_10814(GSON.toJson((Object)content));
            }

            @Override
            protected class_2561 readContent(class_2540 buffer) {
                return (class_2561)class_3518.method_15279((Gson)GSON, (String)buffer.method_19772(), class_5250.class, (boolean)false);
            }
        }, class_2561.class);
        NetworkFieldTypes.register(new NetworkFieldTypeClass<class_2520>(){

            @Override
            protected void writeContent(class_2520 content, class_2540 buffer) {
                buffer.writeByte((int)content.method_10711());
                if (content.method_10711() != 0) {
                    try {
                        content.method_10713((DataOutput)new ByteBufOutputStream((ByteBuf)buffer));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            @Override
            protected class_2520 readContent(class_2540 buffer) {
                ByteBufInputStream in = new ByteBufInputStream((ByteBuf)buffer);
                try {
                    byte b0 = in.readByte();
                    if (b0 == 0) {
                        return class_2491.field_21033;
                    }
                    return class_4615.method_23265((int)b0).method_23262((DataInput)in, 0, class_2505.field_11556);
                }
                catch (IOException e) {
                    class_128 crashreport = class_128.method_560((Throwable)e, (String)"Loading NBT data");
                    crashreport.method_562("NBT Tag");
                    throw new class_148(crashreport);
                }
            }
        }, class_2520.class);
    }
}

