/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5222;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import team.creative.creativecore.client.render.text.Linebreaker;
import team.creative.creativecore.client.render.text.WidthLimitedCharSink;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.util.text.AdvancedComponent;
import team.creative.creativecore.common.util.type.list.SingletonList;

public class CompiledText {
    private int maxWidth;
    private int maxHeight;
    public int usedWidth;
    public int usedHeight;
    public int lineSpacing = 2;
    public boolean shadow = true;
    public int defaultColor = -1;
    public Align alignment = Align.LEFT;
    private List<CompiledLine> lines;
    private List<class_2561> original;

    public CompiledText(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        this.setText(Collections.EMPTY_LIST);
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public void setDimension(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        this.compile();
    }

    public int getMaxWidht() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setText(class_2561 component) {
        this.setText(new SingletonList<class_2561>(component));
    }

    public void setText(List<class_2561> components) {
        this.original = components;
        this.compile();
    }

    private void compile() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return;
        }
        ArrayList<class_5250> copy = new ArrayList<class_5250>();
        for (class_2561 component : this.original) {
            copy.add(component.method_27661());
        }
        this.lines = new ArrayList<CompiledLine>();
        this.compileNext(null, true, copy);
    }

    @Environment(value=EnvType.CLIENT)
    private CompiledLine compileNext(CompiledLine currentLine, boolean newLine, List<? extends class_5348> components) {
        for (class_5348 class_53482 : components) {
            if (newLine) {
                currentLine = new CompiledLine();
                this.lines.add(currentLine);
            }
            currentLine = this.compileNext(currentLine, class_53482);
        }
        return currentLine;
    }

    @Environment(value=EnvType.CLIENT)
    private CompiledLine compileNext(CompiledLine currentLine, boolean newLine, class_5348 component) {
        if (newLine) {
            currentLine = new CompiledLine();
            this.lines.add(currentLine);
        }
        return this.compileNext(currentLine, component);
    }

    private CompiledLine compileNext(CompiledLine currentLine, class_5348 component) {
        class_5348 next;
        ArrayList siblings = null;
        if (component instanceof class_2561 && !((class_2561)component).method_10855().isEmpty()) {
            siblings = new ArrayList(((class_2561)component).method_10855());
            ((class_2561)component).method_10855().clear();
        }
        if ((next = currentLine.add(component)) != null) {
            currentLine = new CompiledLine();
            this.lines.add(currentLine);
            currentLine = this.compileNext(currentLine, false, next);
        }
        if (siblings != null) {
            currentLine = this.compileNext(currentLine, false, siblings);
        }
        return currentLine;
    }

    @Environment(value=EnvType.CLIENT)
    public int getTotalHeight() {
        int height = -this.lineSpacing;
        for (CompiledLine line : this.lines) {
            height += line.height + this.lineSpacing;
        }
        return height;
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_4587 stack) {
        if (this.lines == null) {
            return;
        }
        this.usedWidth = 0;
        this.usedHeight = -this.lineSpacing;
        stack.method_22903();
        for (CompiledLine line : this.lines) {
            switch (this.alignment) {
                case LEFT: {
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, line.width);
                    break;
                }
                case CENTER: {
                    stack.method_22903();
                    stack.method_22904((double)(this.maxWidth / 2 - line.width / 2), 0.0, 0.0);
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                    stack.method_22909();
                    break;
                }
                case RIGHT: {
                    stack.method_22903();
                    stack.method_22904((double)(this.maxWidth - line.width), 0.0, 0.0);
                    line.render(stack);
                    this.usedWidth = Math.max(this.usedWidth, this.maxWidth);
                    stack.method_22909();
                    break;
                }
            }
            int height = line.height + this.lineSpacing;
            stack.method_22904(0.0, (double)height, 0.0);
            this.usedHeight += height;
            if (this.usedHeight <= this.maxHeight) continue;
            break;
        }
        stack.method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    public FormattedTextSplit splitByWidth(class_5348 text, int width, class_2583 style, final boolean force) {
        class_327 font = class_310.method_1551().field_1772;
        final WidthLimitedCharSink charSink = new WidthLimitedCharSink(width, font.method_27527());
        final class_5222 head = new class_5222();
        final class_5222 tail = new class_5222();
        text.method_27658((class_5348.class_5246)new class_5348.class_5246<class_5348>(){

            public Optional<class_5348> accept(class_2583 style, String text) {
                charSink.resetPosition();
                if (!class_5223.method_27479((String)text, (class_2583)style, (class_5224)charSink)) {
                    Linebreaker breaker = charSink.lastBreaker();
                    if (force || breaker != null) {
                        String sTail;
                        String sHead;
                        if (breaker != null) {
                            int pos = charSink.lastBreakerPos();
                            sHead = text.substring(0, pos + (breaker.includeChar && breaker.head ? 1 : 0));
                            sTail = text.substring(pos + (breaker.includeChar && !breaker.head ? 0 : 1));
                        } else {
                            sHead = text.substring(0, charSink.getPosition());
                            sTail = text.substring(charSink.getPosition());
                        }
                        if (!sHead.isEmpty()) {
                            head.method_27462(class_5348.method_29431((String)sHead, (class_2583)style));
                        }
                        if (!sTail.isEmpty()) {
                            tail.method_27462(class_5348.method_29431((String)sTail, (class_2583)style));
                        }
                    } else {
                        tail.method_27462(class_5348.method_29431((String)text, (class_2583)style));
                    }
                } else if (!text.isEmpty()) {
                    head.method_27462(class_5348.method_29431((String)text, (class_2583)style));
                }
                return Optional.empty();
            }
        }, style).orElse(null);
        return new FormattedTextSplit(head, tail);
    }

    @Environment(value=EnvType.CLIENT)
    public int getTotalWidth() {
        return this.calculateWidth(0, true, this.original);
    }

    @Environment(value=EnvType.CLIENT)
    private int calculateWidth(int width, boolean newLine, List<? extends class_5348> components) {
        for (class_5348 class_53482 : components) {
            int result = this.calculateWidth(class_53482);
            if (newLine) {
                width = Math.max(width, result);
                continue;
            }
            width += result;
        }
        return width;
    }

    @Environment(value=EnvType.CLIENT)
    private int calculateWidth(class_5348 component) {
        class_327 font = class_310.method_1551().field_1772;
        int width = 0;
        if (component instanceof AdvancedComponent) {
            AdvancedComponent advanced = (AdvancedComponent)component;
            if (!advanced.isEmpty()) {
                width += advanced.getWidth(font);
            }
        } else {
            width += font.method_27525(component);
        }
        if (component instanceof class_2561 && !((class_2561)component).method_10855().isEmpty()) {
            width += this.calculateWidth(0, false, ((class_2561)component).method_10855());
        }
        return width;
    }

    public CompiledText copy() {
        CompiledText copy = new CompiledText(this.maxWidth, this.maxHeight);
        copy.alignment = this.alignment;
        copy.lineSpacing = this.lineSpacing;
        copy.shadow = this.shadow;
        ArrayList<class_2561> components = new ArrayList<class_2561>();
        for (class_2561 component : this.original) {
            components.add((class_2561)component.method_27661());
        }
        copy.setText(components);
        return copy;
    }

    public static CompiledText createAnySize() {
        return new CompiledText(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public class CompiledLine {
        private List<class_5348> components = new ArrayList<class_5348>();
        private int height = 0;
        private int width = 0;

        @Environment(value=EnvType.CLIENT)
        public void render(class_4587 stack) {
            class_327 font = class_310.method_1551().field_1772;
            int xOffset = 0;
            class_4597.class_4598 renderType = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            for (class_5348 text : this.components) {
                int height;
                int width;
                if (text instanceof AdvancedComponent) {
                    width = ((AdvancedComponent)text).getWidth(font);
                    height = ((AdvancedComponent)text).getHeight(font);
                } else {
                    width = font.method_27525(text);
                    Objects.requireNonNull(font);
                    height = 9;
                }
                int yOffset = 0;
                if (height < this.height) {
                    yOffset = (this.height - height) / 2;
                }
                stack.method_22903();
                stack.method_22904((double)xOffset, (double)yOffset, 0.0);
                if (text instanceof AdvancedComponent) {
                    ((AdvancedComponent)text).render(stack, font, CompiledText.this.defaultColor);
                } else {
                    font.method_22942(class_2477.method_10517().method_30934(text), 0.0f, 0.0f, CompiledText.this.defaultColor, CompiledText.this.shadow, stack.method_23760().method_23761(), (class_4597)renderType, false, 0, 0xF000F0);
                    renderType.method_22993();
                }
                stack.method_22909();
                xOffset += width;
            }
        }

        @Environment(value=EnvType.CLIENT)
        public void updateDimension(int width, int height) {
            this.width = Math.max(width, this.width);
            this.height = Math.max(height, this.height);
        }

        public class_5348 add(class_5348 component) {
            class_327 font = class_310.method_1551().field_1772;
            int remainingWidth = CompiledText.this.maxWidth - this.width;
            if (component instanceof AdvancedComponent) {
                AdvancedComponent advanced = (AdvancedComponent)component;
                if (advanced.isEmpty()) {
                    return null;
                }
                int textWidth = advanced.getWidth(font);
                if (remainingWidth > textWidth) {
                    this.components.add(advanced);
                    this.updateDimension(this.width + textWidth, advanced.getHeight(font));
                    return null;
                }
                if (advanced.canSplit()) {
                    List<AdvancedComponent> remaining = advanced.split(remainingWidth, this.width == 0);
                    AdvancedComponent toAdd = remaining.remove(0);
                    this.components.add(toAdd);
                    this.updateDimension(this.width + toAdd.getWidth(font), toAdd.getHeight(font));
                    if (remaining.isEmpty()) {
                        return null;
                    }
                    return remaining.get(0);
                }
                if (this.width == 0) {
                    this.components.add(advanced);
                    this.updateDimension(this.width + textWidth, advanced.getHeight(font));
                    return null;
                }
                return advanced;
            }
            int textWidth = font.method_27525(component);
            if (remainingWidth >= textWidth) {
                this.components.add(component);
                Objects.requireNonNull(font);
                this.updateDimension(this.width + textWidth, 9);
                return null;
            }
            FormattedTextSplit split = CompiledText.this.splitByWidth(component, remainingWidth, class_2583.field_24360, this.width == 0);
            if (split != null && (split.head != null || this.width == 0)) {
                if (split.head != null) {
                    int n = this.width + font.method_27525(split.head);
                    Objects.requireNonNull(font);
                    this.updateDimension(n, 9);
                    this.components.add(split.head);
                    return split.tail;
                }
                int n = this.width + font.method_27525(split.tail);
                Objects.requireNonNull(font);
                this.updateDimension(n, 9);
                this.components.add(split.tail);
                return null;
            }
            return component;
        }
    }

    static class FormattedTextSplit {
        public final class_5348 head;
        public final class_5348 tail;

        public FormattedTextSplit(class_5348 head, class_5348 tail) {
            this.head = head;
            this.tail = tail;
        }

        public FormattedTextSplit(class_5222 head, class_5222 tail) {
            this.head = head.method_27461();
            this.tail = tail.method_27461();
        }
    }
}

