/*
 * Decompiled with CFR 0.152.
 */
package com.github.legoatoom.connectiblechains.chain;

import com.github.legoatoom.connectiblechains.ConnectibleChains;
import com.github.legoatoom.connectiblechains.chain.ChainType;
import com.github.legoatoom.connectiblechains.util.Helper;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class ChainTypesRegistry {
    public static final class_2960 DEFAULT_CHAIN_TYPE_ID = class_2378.field_11142.method_10221((Object)class_1802.field_23983);
    public static final class_5321<? extends class_2378<ChainType>> CHAIN_TYPE_KEY = class_5321.method_29180((class_2960)Helper.identifier("chain_types"));
    public static final class_2348<ChainType> REGISTRY = (class_2348)FabricRegistryBuilder.from((class_2385)new class_2348(DEFAULT_CHAIN_TYPE_ID.toString(), CHAIN_TYPE_KEY, Lifecycle.stable(), null)).attribute(RegistryAttribute.SYNCED).buildAndRegister();
    public static final Map<class_1792, ChainType> ITEM_CHAIN_TYPES = new Object2ObjectOpenHashMap(64);
    public static final ChainType DEFAULT_CHAIN_TYPE;
    public static final ChainType IRON_CHAIN;
    private static boolean frozen;

    public static void lock() {
        frozen = true;
    }

    public static ChainType register(class_1792 item) {
        class_2960 id = class_2378.field_11142.method_10221((Object)item);
        if (id == class_2378.field_11142.method_10137()) {
            ConnectibleChains.LOGGER.error("Cannot create chain type with unregistered item: {}", (Object)item.method_7848());
            return DEFAULT_CHAIN_TYPE;
        }
        if (REGISTRY.method_10250(id)) {
            return (ChainType)REGISTRY.method_10223(id);
        }
        ChainType chainType = (ChainType)class_2378.method_10230(REGISTRY, (class_2960)id, (Object)new ChainType(item));
        ITEM_CHAIN_TYPES.put(item, chainType);
        return chainType;
    }

    public static void registerDynamic(class_1792 item) {
        class_2960 id = class_2378.field_11142.method_10221((Object)item);
        if (frozen) {
            ConnectibleChains.LOGGER.error("Tried to add {} but registry is locked.", (Object)id);
        }
        Optional existing = REGISTRY.method_17966(id);
        OptionalInt rawId = OptionalInt.empty();
        if (existing.isPresent()) {
            if (((ChainType)existing.get()).item() == item) {
                return;
            }
            rawId = OptionalInt.of(REGISTRY.method_10206((Object)((ChainType)existing.get())));
        }
        class_6880 chainType = REGISTRY.method_31062(rawId, class_5321.method_29179((class_5321)REGISTRY.method_30517(), (class_2960)id), (Object)new ChainType(item), Lifecycle.stable());
        ITEM_CHAIN_TYPES.put(item, (ChainType)chainType.comp_349());
    }

    public static void init() {
    }

    public static boolean isFrozen() {
        return frozen;
    }

    static {
        frozen = false;
        DEFAULT_CHAIN_TYPE = IRON_CHAIN = ChainTypesRegistry.register(class_1802.field_23983);
    }
}

