/*
 * Decompiled with CFR 0.152.
 */
package dev.stashy.extrasounds.mapping;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.stashy.extrasounds.ExtraSounds;
import dev.stashy.extrasounds.debug.DebugUtils;
import dev.stashy.extrasounds.json.SoundEntrySerializer;
import dev.stashy.extrasounds.json.SoundSerializer;
import dev.stashy.extrasounds.mapping.SoundDefinition;
import dev.stashy.extrasounds.mapping.SoundGenerator;
import dev.stashy.extrasounds.sounds.SoundType;
import dev.stashy.extrasounds.sounds.Sounds;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.devtech.arrp.api.RRPCallback;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1110;
import net.minecraft.class_1111;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3414;
import net.minecraft.class_3545;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundPackLoader {
    private static final int CACHE_VERSION = 1;
    private static final RuntimeResourcePack genericPack = RuntimeResourcePack.create((String)"extrasounds");
    private static final class_2960 soundsJsonId = new class_2960("extrasounds:sounds.json");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Path cachePath = FabricLoader.getInstance().getConfigDir().resolve("extrasounds.cache");
    public static List<RuntimeResourcePack> packs = Collections.emptyList();
    public static Map<String, SoundGenerator> mappers = new HashMap<String, SoundGenerator>();
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(class_1110.class, (Object)new SoundEntrySerializer()).registerTypeAdapter(class_1111.class, (Object)new SoundSerializer()).create();

    public static void init() {
        FabricLoader.getInstance().getEntrypoints("extrasounds", SoundGenerator.class).forEach(it -> mappers.put(it.namespace(), (SoundGenerator)it));
        String json = SoundPackLoader.getCache();
        if (json == null) {
            json = gson.toJson(SoundPackLoader.processSounds());
            SoundPackLoader.writeCache(json);
        }
        byte[] jsonBytes = json.getBytes();
        DebugUtils.exportSoundsJson(jsonBytes);
        DebugUtils.exportGenerators();
        genericPack.addResource(class_3264.field_14188, soundsJsonId, jsonBytes);
        RRPCallback.BEFORE_VANILLA.register(packs -> packs.add(genericPack));
    }

    private static Map<String, class_1110> processSounds() {
        return class_2378.field_11142.method_10220().flatMap(item -> {
            class_2960 itemId = class_2378.field_11142.method_10221(item);
            SoundDefinition def = new SoundDefinition(Sounds.aliased(Sounds.ITEM_PICK));
            if (mappers.containsKey(itemId.method_12836())) {
                def = mappers.get(itemId.method_12836()).itemSoundGenerator().apply((class_1792)item);
            } else if (item instanceof class_1747) {
                class_1747 b = (class_1747)item;
                try {
                    class_3414 blockSound = b.method_7711().method_9573(b.method_7711().method_9564()).method_10598();
                    def = SoundDefinition.of(Sounds.aliased(blockSound));
                }
                catch (Exception blockSound) {
                    // empty catch block
                }
            }
            ArrayList<class_3545<class_3414, class_1110>> entries = new ArrayList<class_3545<class_3414, class_1110>>();
            class_3545<class_3414, class_1110> pickupSound = SoundPackLoader.registerOrDefault(itemId, SoundType.PICKUP, def.pickup, Sounds.aliased(Sounds.ITEM_PICK));
            entries.add(pickupSound);
            entries.add(SoundPackLoader.registerOrDefault(itemId, SoundType.PLACE, def.place, Sounds.aliased((class_3414)pickupSound.method_15442())));
            entries.add(SoundPackLoader.registerOrDefault(itemId, SoundType.HOTBAR, def.hotbar, Sounds.aliased((class_3414)pickupSound.method_15442())));
            return entries.stream();
        }).collect(Collectors.toMap(key -> ((class_3414)key.method_15442()).method_14833().method_12832(), class_3545::method_15441));
    }

    private static class_3545<class_3414, class_1110> registerOrDefault(class_2960 itemId, SoundType type, class_1110 entry, class_1110 defaultEntry) {
        class_1110 soundEntry = entry == null ? defaultEntry : entry;
        return new class_3545((Object)SoundPackLoader.registerIfNotExists(itemId, type), (Object)soundEntry);
    }

    private static class_3414 registerIfNotExists(class_2960 itemId, SoundType type) {
        class_2960 soundId = new class_2960("extrasounds", ExtraSounds.getClickId(itemId, type, false));
        class_3414 event = new class_3414(soundId);
        if (!class_2378.field_11156.method_10250(soundId)) {
            class_2378.method_10230((class_2378)class_2378.field_11156, (class_2960)soundId, (Object)event);
        }
        return event;
    }

    private static String getCache() {
        if (Files.exists(cachePath, new LinkOption[0]) && !DebugUtils.noCache) {
            try {
                List<String> lines = Files.readAllLines(cachePath);
                if (CacheInfo.fromString(lines.get(0)).equals(CacheInfo.getCurrent())) {
                    String cache = lines.get(1);
                    JsonObject jsonObj = JsonParser.parseString((String)cache).getAsJsonObject();
                    jsonObj.keySet().forEach(it -> {
                        class_2960 identifier = new class_2960("extrasounds", it);
                        if (!class_2378.field_11156.method_10250(identifier)) {
                            class_2378.method_10230((class_2378)class_2378.field_11156, (class_2960)identifier, (Object)new class_3414(identifier));
                        }
                    });
                    return cache;
                }
                DebugUtils.genericLog("Invalidating ExtraSounds cache.");
                DebugUtils.genericLog("Previous: " + lines.get(0));
                DebugUtils.genericLog("Current: " + CacheInfo.getCurrent());
            }
            catch (Exception e) {
                System.err.println("Failed to load ExtraSounds cache.");
                e.printStackTrace();
            }
        } else {
            DebugUtils.genericLog("Cache not found - generating...");
        }
        return null;
    }

    private static void writeCache(String json) {
        try {
            Files.write(cachePath, (CacheInfo.getCurrent() + "\n" + json).getBytes(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            DebugUtils.genericLog("Cache saved.");
        }
        catch (IOException e) {
            System.err.println("Failed to save ExtraSounds cache.");
            e.printStackTrace();
        }
    }

    record CacheInfo(int version, int itemCount, String[] mappers) {
        public static CacheInfo getCurrent() {
            String[] versionInfos = (String[])mappers.values().stream().map(it -> CacheInfo.getModVersion(it.modId())).toArray(String[]::new);
            return new CacheInfo(1, class_2378.field_11142.method_10204(), versionInfos);
        }

        public static CacheInfo fromString(String s) {
            try {
                String[] arr = s.split(";");
                return new CacheInfo(Integer.parseInt(arr[0]), Integer.parseInt(arr[1]), arr[2].split(","));
            }
            catch (Exception e) {
                return new CacheInfo(0, 0, new String[0]);
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CacheInfo) {
                CacheInfo comp = (CacheInfo)obj;
                return this.version == comp.version && this.itemCount == comp.itemCount && Arrays.equals(this.mappers, comp.mappers);
            }
            return false;
        }

        @Override
        public String toString() {
            return "%d;%d;%s".formatted(this.version, this.itemCount, String.join((CharSequence)",", this.mappers));
        }

        private static String getModVersion(String modId) {
            return FabricLoader.getInstance().getModContainer(modId).map(modContainer -> modId + " " + modContainer.getMetadata().getVersion().getFriendlyString()).orElse("nope");
        }
    }
}

