/*
 * Decompiled with CFR 0.152.
 */
package dev.stashy.extrasounds;

import dev.stashy.extrasounds.ExtraSounds;
import dev.stashy.extrasounds.Mixers;
import dev.stashy.extrasounds.debug.DebugUtils;
import dev.stashy.extrasounds.sounds.SoundType;
import dev.stashy.extrasounds.sounds.Sounds;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1291;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static long lastPlayed = System.currentTimeMillis();

    public static void playSound(class_1799 stack, SoundType type) {
        class_2960 itemId = class_2378.field_11142.method_10221((Object)stack.method_7909());
        String idString = ExtraSounds.getClickId(itemId, type);
        if (!class_2960.method_20207((String)idString)) {
            LOGGER.error("Unable to parse sound from ID: " + idString);
            return;
        }
        class_2960 id = class_2960.method_12829((String)idString);
        class_2378.field_11156.method_17966(id).ifPresentOrElse(snd -> SoundManager.playSound(snd, type), () -> LOGGER.error("Sound cannot be found in registry: " + id));
    }

    public static void playSound(class_1291 effect, boolean add) {
        class_3414 class_34142;
        DebugUtils.effectLog(effect, add);
        if (add) {
            switch (effect.method_18792()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case field_18272: {
                    class_34142 = Sounds.EFFECT_ADD_NEGATIVE;
                    break;
                }
                case field_18273: 
                case field_18271: {
                    class_34142 = Sounds.EFFECT_ADD_POSITIVE;
                    break;
                }
            }
        } else {
            switch (effect.method_18792()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case field_18272: {
                    class_34142 = Sounds.EFFECT_REMOVE_NEGATIVE;
                    break;
                }
                case field_18273: 
                case field_18271: {
                    class_34142 = Sounds.EFFECT_REMOVE_POSITIVE;
                }
            }
        }
        class_3414 e = class_34142;
        SoundManager.playSound(e, SoundType.EFFECT);
    }

    public static void playSound(class_3414 snd, SoundType type) {
        SoundManager.playSound(snd, type, type.category);
    }

    public static void playSound(class_3414 snd, SoundType type, class_3419 cat) {
        SoundManager.playSound(snd, type.pitch, cat);
    }

    public static void playSound(class_3414 snd, float pitch, class_3419 cat) {
        SoundManager.throttle(() -> {
            class_310.method_1551().method_1483().method_4873((class_1113)new class_1109(snd.method_14833(), cat, SoundManager.getMasterVol(), pitch, false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true));
            DebugUtils.soundLog(snd);
        });
    }

    public static void playSound(class_3414 snd, SoundType type, class_2338 position) {
        SoundManager.throttle(() -> {
            class_310.method_1551().method_1483().method_4873((class_1113)new class_1109(snd, type.category, SoundManager.getMasterVol(), type.pitch, (double)position.method_10263() + 0.5, (double)position.method_10264() + 0.5, (double)position.method_10260() + 0.5));
            DebugUtils.soundLog(snd);
        });
    }

    public static void stopSound(class_3414 e, SoundType type) {
        class_310.method_1551().method_1483().method_4875(e.method_14833(), type.category);
    }

    private static void throttle(Runnable r) {
        try {
            long now = System.currentTimeMillis();
            if (now - lastPlayed > 5L) {
                r.run();
            }
            lastPlayed = now;
        }
        catch (Exception e) {
            System.err.println("Failed to play sound:");
            e.printStackTrace();
        }
    }

    private static float getMasterVol() {
        return class_310.method_1551().field_1690.method_1630(Mixers.MASTER);
    }
}

