/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.stats;

import aztech.modern_industrialization.stats.StatisticsRate;
import aztech.modern_industrialization.util.TickHelper;
import net.minecraft.class_2487;

public class StatisticValue {
    private long allTime = 0L;
    private final long[] pastRates = new long[3];
    private final long[] currentRates = new long[3];
    private final int[] remainingTicks = new int[3];
    private long lastTick = 0L;

    public StatisticValue() {
    }

    public StatisticValue(class_2487 nbt) {
        this.allTime = nbt.method_10537("at");
        for (StatisticsRate rate : StatisticsRate.values()) {
            this.pastRates[rate.id] = nbt.method_10537("p" + rate.id);
            this.currentRates[rate.id] = nbt.method_10537("c" + rate.id);
            this.remainingTicks[rate.id] = nbt.method_10550("r" + rate.id);
        }
        this.lastTick = TickHelper.getCurrentTick();
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10544("at", this.allTime);
        for (StatisticsRate rate : StatisticsRate.values()) {
            nbt.method_10544("p" + rate.id, this.pastRates[rate.id]);
            nbt.method_10544("c" + rate.id, this.currentRates[rate.id]);
            nbt.method_10569("r" + rate.id, this.remainingTicks[rate.id]);
        }
        return nbt;
    }

    public void add(long toAdd) {
        this.updateRates();
        this.allTime += toAdd;
        for (StatisticsRate rate : StatisticsRate.values()) {
            int n = rate.id;
            this.currentRates[n] = this.currentRates[n] + toAdd;
        }
    }

    public void updateRates() {
        long tickDiff = TickHelper.getCurrentTick() - this.lastTick;
        if (tickDiff > 0L) {
            for (StatisticsRate rate : StatisticsRate.values()) {
                int i = rate.id;
                if (tickDiff < (long)this.remainingTicks[i]) {
                    int n = i;
                    this.remainingTicks[n] = (int)((long)this.remainingTicks[n] - tickDiff);
                    continue;
                }
                if (tickDiff < (long)(rate.ticks + this.remainingTicks[i])) {
                    this.pastRates[i] = this.currentRates[i];
                    this.currentRates[i] = 0L;
                    this.remainingTicks[i] = rate.ticks - ((int)tickDiff - this.remainingTicks[i]);
                    continue;
                }
                this.pastRates[i] = 0L;
                this.currentRates[i] = 0L;
                this.remainingTicks[i] = rate.ticks;
            }
        }
    }
}

