/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.debug.DebugCommands;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.pipes.PipeColor;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.api.PipeRenderer;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetwork;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkData;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidNetwork;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkData;
import aztech.modern_industrialization.pipes.fluid.FluidNetworkNode;
import aztech.modern_industrialization.pipes.fluid.FluidPipeScreenHandler;
import aztech.modern_industrialization.pipes.impl.PipeBlock;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import aztech.modern_industrialization.pipes.impl.PipeMeshCache;
import aztech.modern_industrialization.pipes.impl.PipePackets;
import aztech.modern_industrialization.pipes.item.ItemNetwork;
import aztech.modern_industrialization.pipes.item.ItemNetworkData;
import aztech.modern_industrialization.pipes.item.ItemNetworkNode;
import aztech.modern_industrialization.pipes.item.ItemPipeScreenHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_3917;
import net.minecraft.class_4730;

public class MIPipes {
    public static final MIPipes INSTANCE = new MIPipes();
    public static final class_2248 BLOCK_PIPE = new PipeBlock(FabricBlockSettings.of((class_3614)class_3614.field_15953).method_36557(2.0f));
    public static class_2591<PipeBlockEntity> BLOCK_ENTITY_TYPE_PIPE;
    private final Map<PipeNetworkType, PipeItem> pipeItems = new HashMap<PipeNetworkType, PipeItem>();
    public static final Map<PipeItem, CableTier> ELECTRICITY_PIPE_TIER;
    public static final class_3917<ItemPipeScreenHandler> SCREEN_HANDLER_TYPE_ITEM_PIPE;
    public static final class_3917<FluidPipeScreenHandler> SCREEN_HANDLER_TYPE_FLUID_PIPE;
    public static final Set<class_2960> PIPE_MODEL_NAMES;
    private static final PipeRenderer.Factory ITEM_RENDERER;
    private static final PipeRenderer.Factory FLUID_RENDERER;
    private static final PipeRenderer.Factory ELECTRICITY_RENDERER;

    private static PipeRenderer.Factory makeRenderer(final List<String> sprites, final boolean innerQuads) {
        return new PipeRenderer.Factory(){

            @Override
            public Collection<class_4730> getSpriteDependencies() {
                return sprites.stream().map(n -> new class_4730(class_1723.field_21668, (class_2960)new MIIdentifier("block/pipes/" + n))).collect(Collectors.toList());
            }

            @Override
            public PipeRenderer create(Function<class_4730, class_1058> textureGetter) {
                class_4730[] ids = (class_4730[])sprites.stream().map(n -> new class_4730(class_1723.field_21668, (class_2960)new MIIdentifier("block/pipes/" + n))).toArray(class_4730[]::new);
                return new PipeMeshCache(textureGetter, ids, innerQuads);
            }
        };
    }

    public void setup() {
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)new MIIdentifier("pipe"), (Object)BLOCK_PIPE);
        BLOCK_ENTITY_TYPE_PIPE = (class_2591)class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)new MIIdentifier("pipe"), (Object)FabricBlockEntityTypeBuilder.create(PipeBlockEntity::new, (class_2248[])new class_2248[]{BLOCK_PIPE}).build(null));
        for (PipeColor color : PipeColor.values()) {
            this.registerFluidPipeType(color);
        }
        for (PipeColor color : PipeColor.values()) {
            this.registerItemPipeType(color);
        }
        this.registerPackets();
        DebugCommands.init();
    }

    private void registerFluidPipeType(PipeColor color) {
        String pipeId = color.prefix + "fluid_pipe";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(pipeId), (id, data) -> new FluidNetwork((int)id, (PipeNetworkData)data, 81000), FluidNetworkNode::new, color.color, true, FLUID_RENDERER);
        ItemDefinition<PipeItem> itemDef = MIItem.itemNoModel(color.englishNamePrefix + "Fluid Pipe", pipeId, prop -> new PipeItem((class_1792.class_1793)prop, type, new FluidNetworkData(FluidVariant.blank())), SortOrder.PIPES);
        PipeItem item = itemDef.method_8389();
        this.pipeItems.put(type, item);
        PIPE_MODEL_NAMES.add(new MIIdentifier("item/" + pipeId));
        TagsToGenerate.generateTag(MITags.FLUID_PIPES, (class_1792)item);
    }

    private void registerItemPipeType(PipeColor color) {
        String pipeId = color.prefix + "item_pipe";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(pipeId), ItemNetwork::new, ItemNetworkNode::new, color.color, true, ITEM_RENDERER);
        ItemDefinition<PipeItem> itemDef = MIItem.itemNoModel(color.englishNamePrefix + "Item Pipe", pipeId, prop -> new PipeItem((class_1792.class_1793)prop, type, new ItemNetworkData()), SortOrder.PIPES);
        PipeItem item = itemDef.method_8389();
        this.pipeItems.put(type, item);
        PIPE_MODEL_NAMES.add(new MIIdentifier("item/" + pipeId));
        TagsToGenerate.generateTag(MITags.ITEM_PIPES, (class_1792)item);
    }

    public void registerCableType(String englishName, String name, int color, CableTier tier) {
        String cableId = name + "_cable";
        PipeNetworkType type = PipeNetworkType.register(new MIIdentifier(cableId), (id, data) -> new ElectricityNetwork((int)id, (PipeNetworkData)data, tier), ElectricityNetworkNode::new, color, false, ELECTRICITY_RENDERER);
        ItemDefinition<PipeItem> itemDef = MIItem.itemNoModel(englishName, cableId, prop -> new PipeItem((class_1792.class_1793)prop, type, new ElectricityNetworkData()), SortOrder.CABLES.and((Comparable)((Object)tier)));
        PipeItem item = itemDef.method_8389();
        this.pipeItems.put(type, item);
        ELECTRICITY_PIPE_TIER.put(item, tier);
        PIPE_MODEL_NAMES.add(new MIIdentifier("item/" + cableId));
    }

    public PipeItem getPipeItem(PipeNetworkType type) {
        return this.pipeItems.get(type);
    }

    public void registerPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PipePackets.SET_ITEM_WHITELIST, PipePackets.ON_SET_ITEM_WHITELIST::handleC2S);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PipePackets.SET_CONNECTION_TYPE, PipePackets.ON_SET_CONNECTION_TYPE::handleC2S);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PipePackets.INCREMENT_PRIORITY, (ServerPlayNetworking.PlayChannelHandler)PipePackets.ON_INCREMENT_PRIORITY);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PipePackets.SET_NETWORK_FLUID, PipePackets.ON_SET_NETWORK_FLUID::handleC2S);
    }

    static {
        ELECTRICITY_PIPE_TIER = new HashMap<PipeItem, CableTier>();
        SCREEN_HANDLER_TYPE_ITEM_PIPE = ScreenHandlerRegistry.registerExtended((class_2960)new MIIdentifier("item_pipe"), ItemPipeScreenHandler::new);
        SCREEN_HANDLER_TYPE_FLUID_PIPE = ScreenHandlerRegistry.registerExtended((class_2960)new MIIdentifier("fluid_pipe"), FluidPipeScreenHandler::new);
        PIPE_MODEL_NAMES = new HashSet<class_2960>();
        ITEM_RENDERER = MIPipes.makeRenderer(Arrays.asList("item", "item_item", "item_in", "item_in_out", "item_out"), false);
        FLUID_RENDERER = MIPipes.makeRenderer(Arrays.asList("fluid", "fluid_item", "fluid_in", "fluid_in_out", "fluid_out"), true);
        ELECTRICITY_RENDERER = MIPipes.makeRenderer(Arrays.asList("electricity", "electricity_blocks"), false);
    }
}

