/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.BuildablePart;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.MaterialPart;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.textures.MITextures;
import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.textures.TextureManager;
import aztech.modern_industrialization.util.TagHelper;
import java.io.IOException;
import net.minecraft.class_1011;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_4946;

public class RegularPart
extends Part
implements BuildablePart {
    private final Register register;
    private final Register clientRegister;
    private final TextureRegister textureRegister;
    private final String englishNameFormatter;

    public static String getEnglishName(String englishNameFormatter, String partEnglishName) {
        if (englishNameFormatter.equals("")) {
            return partEnglishName;
        }
        Object englishName = englishNameFormatter.endsWith("!") ? englishNameFormatter.subSequence(0, englishNameFormatter.length() - 1).toString() : (!englishNameFormatter.contains("%s") ? partEnglishName + " " + englishNameFormatter : String.format(englishNameFormatter, partEnglishName));
        return englishName;
    }

    public RegularPart(String englishNameFormatter, String key) {
        this(englishNameFormatter, key, (partContext, part, itemPath, itemId, itemTag) -> {
            class_1792 item = RegularPart.createSimpleItem(RegularPart.getEnglishName(englishNameFormatter, partContext.getEnglishName()), itemPath, partContext, part);
            RegularPart.setupTag(part, itemTag, item);
        }, (partContext, part, itemPath, itemId, itemTag) -> {}, (mtm, partContext, part, itemPath) -> MITextures.generateItemPartTexture(mtm, part.key, partContext.getMaterialSet(), itemPath, false, partContext.getColoramp()));
    }

    private RegularPart(String englishNameFormatter, String key, Register register, Register clientRegister, TextureRegister textureRegister) {
        super(key);
        this.englishNameFormatter = englishNameFormatter;
        this.register = register;
        this.clientRegister = clientRegister;
        this.textureRegister = textureRegister;
    }

    public static class_1792 createSimpleItem(String englishName, String itemPath, MaterialBuilder.PartContext partContext, Part part) {
        return MIItem.item(englishName, itemPath, SortOrder.MATERIALS.and((Comparable)((Object)partContext.getMaterialName())).and(part)).method_8389();
    }

    private static void setupTag(Part part, String itemTag, class_1792 item) {
        for (Part partTagged : MIParts.TAGGED_PARTS) {
            if (!partTagged.equals(part)) continue;
            TagsToGenerate.generateTag(itemTag.replaceFirst("#", ""), item);
        }
    }

    public RegularPart asBlock(SortOrder sortOrder, float hardness, float resistance, int miningLevel) {
        return new RegularPart(this.englishNameFormatter, this.key, (partContext, part, itemPath, itemId, itemTag) -> {
            BlockDefinition<class_2248> blockDefinition = MIBlock.block(RegularPart.getEnglishName(this.englishNameFormatter, partContext.getEnglishName()), itemPath, MIBlock.BlockDefinitionParams.of().clearTags().addMoreTags(TagHelper.getMiningLevelTag(miningLevel)).sortOrder(sortOrder.and((Comparable)((Object)partContext.getMaterialName()))).method_36557(hardness).method_36558(resistance));
            RegularPart.setupTag(part, itemTag, blockDefinition.method_8389());
        }, this.clientRegister, (mtm, partContext, part, itemPath) -> MITextures.generateItemPartTexture(mtm, part.key, partContext.getMaterialSet(), itemPath, true, partContext.getColoramp()));
    }

    public RegularPart asColumnBlock(SortOrder sortOrder) {
        return new RegularPart(this.englishNameFormatter, this.key, (partContext, part, itemPath, itemId, itemTag) -> {
            BlockDefinition<class_2248> blockDefinition = MIBlock.block(RegularPart.getEnglishName(this.englishNameFormatter, partContext.getEnglishName()), itemPath, MIBlock.BlockDefinitionParams.of().clearTags().addMoreTags(TagHelper.getMiningLevelTag(1)).sortOrder(sortOrder.and((Comparable)((Object)partContext.getMaterialName()))).withModel(class_4946.field_23038).method_36557(5.0f).method_36558(6.0f));
            RegularPart.setupTag(part, itemTag, blockDefinition.method_8389());
        }, this.clientRegister, (mtm, partContext, part, itemPath) -> {
            for (String suffix : new String[]{"_side", "_top"}) {
                String template = String.format("modern_industrialization:textures/materialsets/common/%s%s.png", part, suffix);
                try {
                    class_1011 image = mtm.getAssetAsTexture(template);
                    TextureHelper.colorize(image, partContext.getColoramp());
                    String texturePath = String.format("modern_industrialization:textures/block/%s%s.png", itemPath, suffix);
                    mtm.addTexture(texturePath, image);
                    image.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public RegularPart withoutTextureRegister() {
        return this.withTextureRegister((mtm, partContext, part, itemPath) -> {});
    }

    public RegularPart asBlock(SortOrder sortOrder) {
        return this.asBlock(sortOrder, 5.0f, 6.0f, 1);
    }

    public RegularPart withRegister(Register register) {
        return new RegularPart(this.englishNameFormatter, this.key, register, this.clientRegister, this.textureRegister);
    }

    public RegularPart withClientRegister(Register clientRegister) {
        return new RegularPart(this.englishNameFormatter, this.key, this.register, clientRegister, this.textureRegister);
    }

    public RegularPart withTextureRegister(TextureRegister textureRegister) {
        return new RegularPart(this.englishNameFormatter, this.key, this.register, this.clientRegister, textureRegister);
    }

    public RegularPart appendRegister(Register register) {
        return new RegularPart(this.englishNameFormatter, this.key, (partContext, part, itemPath, itemId, itemTag) -> {
            this.register.register(partContext, part, itemPath, itemId, itemTag);
            register.register(partContext, part, itemPath, itemId, itemTag);
        }, this.clientRegister, this.textureRegister);
    }

    public RegularPart appendTextureRegister(TextureRegister textureRegister) {
        return new RegularPart(this.englishNameFormatter, this.key, this.register, this.clientRegister, (mtm, partContext, part, itemPath) -> {
            this.textureRegister.register(mtm, partContext, part, itemPath);
            textureRegister.register(mtm, partContext, part, itemPath);
        });
    }

    public RegularPart withOverlay(Part normal, String overlay) {
        return this.withTextureRegister((mtm, partContext, part, itemPath) -> MITextures.generateItemPartTexture(mtm, normal.key, overlay, partContext.getMaterialSet(), itemPath, false, partContext.getColoramp()));
    }

    private static MaterialPart build(final String itemPath, final String itemId, final String itemTag, final MaterialBuilder.PartContext partContext, final Part part, final Register register, final Register clientRegister, final TextureRegister textureRegister) {
        return new MaterialPart(){

            @Override
            public Part getPart() {
                return part;
            }

            @Override
            public String getTaggedItemId() {
                return itemTag;
            }

            @Override
            public String getItemId() {
                return itemId;
            }

            @Override
            public void register(MaterialBuilder.PartContext context) {
                register.register(partContext, part, itemPath, itemId, itemTag);
            }

            @Override
            public void registerClient() {
                clientRegister.register(partContext, part, itemPath, itemId, itemTag);
            }

            @Override
            public void registerTextures(TextureManager mtm) {
                textureRegister.register(mtm, partContext, part, itemPath);
            }
        };
    }

    public static String idFromPath(String path) {
        return "modern_industrialization:" + path;
    }

    @Override
    public MaterialPart build(MaterialBuilder.PartContext ctx) {
        String itemPath = ctx.getMaterialName() + "_" + this.key;
        String itemId = RegularPart.idFromPath(itemPath);
        Object itemTag = MIParts.TAGGED_PARTS.contains(this) ? "#c:" + ctx.getMaterialName() + "_" + this.key + "s" : itemId;
        return RegularPart.build(itemPath, itemId, (String)itemTag, ctx, this, this.register, this.clientRegister, this.textureRegister);
    }

    @Override
    public Part getPart() {
        return this;
    }

    public BuildablePart withCustomPath(String itemPath, String itemTag) {
        return BuildablePart.of(this, ctx -> RegularPart.build(itemPath, RegularPart.idFromPath(itemPath), itemTag, ctx, this, this.register, this.clientRegister, this.textureRegister));
    }

    public BuildablePart withCustomPath(String itemPath) {
        return this.withCustomPath(itemPath, itemPath);
    }

    public BuildablePart withCustomFormattablePath(String itemPath, String itemTag) {
        return BuildablePart.of(this, ctx -> {
            String path = String.format(itemPath, ctx.getMaterialName());
            String tag = "#c:" + String.format(itemTag, ctx.getMaterialName());
            return RegularPart.build(path, RegularPart.idFromPath(path), tag, ctx, this, this.register, this.clientRegister, this.textureRegister);
        });
    }

    public BuildablePart withCustomFormattablePath(String itemPath) {
        return this.withCustomFormattablePath(itemPath, itemPath);
    }

    @FunctionalInterface
    public static interface Register {
        public void register(MaterialBuilder.PartContext var1, Part var2, String var3, String var4, String var5);
    }

    @FunctionalInterface
    public static interface TextureRegister {
        public void register(TextureManager var1, MaterialBuilder.PartContext var2, Part var3, String var4);
    }
}

