/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.materials.GemPart;
import aztech.modern_industrialization.materials.part.BarrelPart;
import aztech.modern_industrialization.materials.part.BlockPart;
import aztech.modern_industrialization.materials.part.BuildablePart;
import aztech.modern_industrialization.materials.part.CablePart;
import aztech.modern_industrialization.materials.part.CasingPart;
import aztech.modern_industrialization.materials.part.NuclearFuelPart;
import aztech.modern_industrialization.materials.part.OrePart;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.materials.part.RawMetalPart;
import aztech.modern_industrialization.materials.part.RegularPart;
import aztech.modern_industrialization.materials.part.TankPart;
import aztech.modern_industrialization.textures.MITextures;
import aztech.modern_industrialization.textures.coloramp.HotIngotColoramp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MIParts {
    public static final RegularPart BATTERY = new RegularPart("Battery", "battery");
    public static final BarrelPart BARREL = new BarrelPart();
    public static final RegularPart BLADE = new RegularPart("Blade", "blade");
    public static final BlockPart BLOCK = new BlockPart();
    public static final RegularPart BOLT = new RegularPart("Bolt", "bolt");
    public static final CablePart CABLE = new CablePart();
    public static final RegularPart COIL = new RegularPart("Coil", "coil").asColumnBlock(SortOrder.COILS);
    public static final RegularPart CRUSHED_DUST = new RegularPart("Crushed Dust", "crushed_dust");
    public static final RegularPart CURVED_PLATE = new RegularPart("Curved Plate", "curved_plate");
    public static final RegularPart DOUBLE_INGOT = new RegularPart("Double Ingot", "double_ingot").withTextureRegister((mtm, partContext, part, itemPath) -> mtm.runAtEnd(() -> {
        try {
            MITextures.generateDoubleIngot(mtm, partContext.getMaterialName());
        }
        catch (Throwable throwable) {
            MITextures.logTextureGenerationError(throwable, partContext.getMaterialName(), partContext.getMaterialSet(), part.key);
        }
    }));
    public static final RegularPart DRILL_HEAD = new RegularPart("Drill Head", "drill_head");
    public static final RegularPart DRILL = new RegularPart("Drill", "drill");
    public static final RegularPart DUST = new RegularPart("Dust", "dust");
    public static final RegularPart FINE_WIRE = new RegularPart("Fine Wire", "fine_wire");
    public static final RegularPart GEAR = new RegularPart("Gear", "gear");
    public static final GemPart GEM = new GemPart();
    public static final RegularPart HAMMER = new RegularPart("Hammer", "hammer");
    public static final RegularPart HOT_INGOT = new RegularPart("Hot Ingot", "hot_ingot").withTextureRegister((mtm, partContext, part, itemPath) -> MITextures.generateItemPartTexture(mtm, MIParts.INGOT.key, partContext.getMaterialSet(), itemPath, false, new HotIngotColoramp(partContext.getColoramp(), 0.1, 0.5)));
    public static final RegularPart INGOT = new RegularPart("Ingot", "ingot");
    public static final RegularPart LARGE_PLATE = new RegularPart("Large Plate", "large_plate");
    public static final CasingPart MACHINE_CASING = new CasingPart("Machine Casing", "machine_casing");
    public static final CasingPart MACHINE_CASING_PIPE = new CasingPart("Pipe Machine Casing", "machine_casing_pipe");
    public static final CasingPart MACHINE_CASING_SPECIAL = new CasingPart("Special Casing", "machine_casing_special");
    public static final RegularPart NUGGET = new RegularPart("Nugget", "nugget");
    public static final OrePart ORE = new OrePart(false);
    public static final OrePart ORE_DEEPLSATE = new OrePart(true);
    public static final RegularPart PLATE = new RegularPart("Plate", "plate");
    public static final RawMetalPart RAW_METAL = new RawMetalPart(false);
    public static final RawMetalPart RAW_METAL_BLOCK = new RawMetalPart(true);
    public static final RegularPart RING = new RegularPart("Ring", "ring");
    public static final RegularPart ROD = new RegularPart("Rod", "rod");
    public static final RegularPart ROD_MAGNETIC = new RegularPart("Magnetic %s Rod", "rod_magnetic").withOverlay(ROD, "magnetic");
    public static final RegularPart ROTOR = new RegularPart("Rotor", "rotor");
    public static final TankPart TANK = new TankPart();
    public static final RegularPart TINY_DUST = new RegularPart("Tiny Dust", "tiny_dust");
    public static final RegularPart WIRE = new RegularPart("Wire", "wire");
    public static final RegularPart WIRE_MAGNETIC = new RegularPart("Magnetic %s Wire", "wire_magnetic").withOverlay(WIRE, "magnetic");
    public static final NuclearFuelPart FUEL_ROD = new NuclearFuelPart(NuclearFuelPart.Type.SIMPLE);
    public static final NuclearFuelPart FUEL_ROD_DEPLETED = new NuclearFuelPart(NuclearFuelPart.Type.DEPLETED);
    public static final NuclearFuelPart FUEL_ROD_DOUBLE = new NuclearFuelPart(NuclearFuelPart.Type.DOUBLE);
    public static final NuclearFuelPart FUEL_ROD_QUAD = new NuclearFuelPart(NuclearFuelPart.Type.QUAD);
    public static final RegularPart N_DOPED_PLATE = new RegularPart("N-Doped %s Plate", "n_doped_plate").withOverlay(PLATE, "n_doped");
    public static final RegularPart P_DOPED_PLATE = new RegularPart("P-Doped %s Plate", "p_doped_plate").withOverlay(PLATE, "p_doped");
    public static final BuildablePart[] ITEM_PURE_NON_METAL = new BuildablePart[]{TINY_DUST, DUST, CRUSHED_DUST};
    public static final BuildablePart[] ITEM_PURE_METAL = new BuildablePart[]{INGOT, NUGGET, TINY_DUST, DUST};
    public static final List<Part> TAGGED_PARTS_LIST = Arrays.asList(BLOCK, DUST, GEAR, INGOT, NUGGET, ORE, PLATE, TINY_DUST, RAW_METAL, RAW_METAL_BLOCK);
    public static final Set<Part> TAGGED_PARTS = new HashSet<Part>(TAGGED_PARTS_LIST);
    public static final Part[] BLOCKS = new Part[]{ORE, BARREL, BLOCK, COIL, MACHINE_CASING, MACHINE_CASING_SPECIAL, MACHINE_CASING_PIPE, RAW_METAL_BLOCK};

    public static String idOfPart(Part part, String materialName) {
        return "modern_industrialization:" + materialName + "_" + part.key;
    }
}

