/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.MaterialHardness;
import aztech.modern_industrialization.materials.MaterialRegistry;
import aztech.modern_industrialization.materials.part.ExternalPart;
import aztech.modern_industrialization.materials.part.MIItemPart;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.materials.part.RegularPart;
import aztech.modern_industrialization.materials.recipe.ForgeHammerRecipes;
import aztech.modern_industrialization.materials.recipe.SmeltingRecipes;
import aztech.modern_industrialization.materials.recipe.StandardRecipes;
import aztech.modern_industrialization.materials.recipe.builder.MIRecipeBuilder;
import aztech.modern_industrialization.materials.set.MaterialBlockSet;
import aztech.modern_industrialization.materials.set.MaterialOreSet;
import aztech.modern_industrialization.materials.set.MaterialRawSet;
import aztech.modern_industrialization.materials.set.MaterialSet;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.NuclearAbsorbable;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import aztech.modern_industrialization.textures.coloramp.BakableTargetColoramp;
import net.minecraft.class_6019;

public class MIMaterials {
    public static final Material ALUMINUM;
    public static final Material ANNEALED_COPPER;
    public static final Material ANTIMONY;
    public static final Material BATTERY_ALLOY;
    public static final Material BAUXITE;
    public static final Material BERYLLIUM;
    public static final Material BLASTPROOF_ALLOY;
    public static final Material BRICK;
    public static final Material BRONZE;
    public static final Material CADMIUM;
    public static final Material CARBON;
    public static final Material CHROMIUM;
    public static final Material COAL;
    public static final Material COKE;
    public static final Material COPPER;
    public static final Material CUPRONICKEL;
    public static final Material DIAMOND;
    public static final Material ELECTRUM;
    public static final Material EMERALD;
    public static final Material FIRE_CLAY;
    public static final Material GOLD;
    public static final Material HE_MOX;
    public static final Material HE_URANIUM;
    public static final Material INVAR;
    public static final Material IRIDIUM;
    public static final Material IRON;
    public static final Material KANTHAL;
    public static final Material LAPIS;
    public static final Material LEAD;
    public static final Material LE_MOX;
    public static final Material LE_URANIUM;
    public static final Material LIGNITE_COAL;
    public static final Material MANGANESE;
    public static final Material MOZANITE;
    public static final Material NEODYMIUM;
    public static final Material NICKEL;
    public static final Material NUCLEAR_ALLOY;
    public static final Material PLATINUM;
    public static final Material PLUTONIUM;
    public static final Material QUARTZ;
    public static final Material REDSTONE;
    public static final Material RUBY;
    public static final Material SALT;
    public static final Material SILICON;
    public static final Material SILVER;
    public static final Material SODIUM;
    public static final Material SOLDERING_ALLOY;
    public static final Material STAINLESS_STEEL;
    public static final Material STEEL;
    public static final Material SULFUR;
    public static final Material SUPERCONDUCTOR;
    public static final Material TIN;
    public static final Material TITANIUM;
    public static final Material TUNGSTEN;
    public static final Material URANIUM;
    public static final Material URANIUM_235;
    public static final Material URANIUM_238;
    public static final Material YTTRIUM;
    public static final String commonPath = "modern_industrialization:textures/materialsets/common/";
    public static final String templatePath = "modern_industrialization:textures/template/";
    public static final String mcPath = "minecraft:textures/item/";
    public static final String miPath = "modern_industrialization:textures/item/";

    public static void init() {
    }

    public static String common(String name) {
        return commonPath + name + ".png";
    }

    public static String common(Part part) {
        return MIMaterials.common(part.key);
    }

    public static String mcitem(String name) {
        return mcPath + name + ".png";
    }

    public static String miitem(String name) {
        return miPath + name + ".png";
    }

    public static String template(String name) {
        return templatePath + name + ".png";
    }

    public static MaterialBuilder addVanillaMetal(boolean nugget, MaterialBuilder builder) {
        String n = builder.getMaterialName();
        MaterialBuilder res = builder.overridePart(ExternalPart.of(MIParts.INGOT, "#c:" + n + "_ingots", "minecraft:" + n + "_ingot")).addParts(ExternalPart.of(MIParts.BLOCK, "#c:" + n + "_blocks", "minecraft:" + n + "_block")).addParts(ExternalPart.of(MIParts.ORE, "#c:" + n + "_ores", "minecraft:" + n + "_ore")).addParts(ExternalPart.of(MIParts.ORE_DEEPLSATE, "#c:" + n + "_ores", "minecraft:deepslate_" + n + "_ore")).addParts(ExternalPart.of(MIParts.RAW_METAL, "#c:raw_" + n + "_ores", "minecraft:raw_" + n)).addParts(ExternalPart.of(MIParts.RAW_METAL_BLOCK, "#c:raw_" + n + "_blocks", "minecraft:raw_" + n + "_block"));
        if (nugget) {
            res.overridePart(ExternalPart.of(MIParts.NUGGET, "#c:" + n + "_nuggets", "minecraft:" + n + "_nugget"));
        }
        res.addRecipes(ForgeHammerRecipes::apply, SmeltingRecipes::apply, StandardRecipes::apply).cancelRecipes("craft/block_from_ingot", "craft/ingot_from_block").cancelRecipes("craft/raw_metal_block_from_raw_metal", "craft/raw_metal_from_raw_metal_block").cancelRecipes("smelting/ore_to_ingot_smelting", "smelting/ore_to_ingot_blasting").cancelRecipes("smelting/ore_deepslate_to_ingot_smelting", "smelting/ore_deepslate_to_ingot_blasting").cancelRecipes("smelting/raw_metal_to_ingot_smelting", "smelting/raw_metal_to_ingot_blasting");
        if (nugget) {
            res.cancelRecipes("craft/ingot_from_nugget", "craft/nugget_from_ingot");
        }
        return res;
    }

    public static MaterialBuilder addVanillaGem(boolean compressor, MaterialBuilder builder) {
        return MIMaterials.addVanillaGem(compressor, builder.getMaterialName(), builder);
    }

    public static MaterialBuilder addVanillaGem(boolean compressor, String gemPath, MaterialBuilder builder) {
        String n = builder.getMaterialName();
        MaterialBuilder res = builder.addParts(ExternalPart.of(MIParts.GEM, "minecraft:" + gemPath, "minecraft:" + gemPath)).addParts(ExternalPart.of(MIParts.BLOCK, "#c:" + n + "_blocks", "minecraft:" + n + "_block")).addParts(ExternalPart.of(MIParts.ORE, "#c:" + n + "_ores", "minecraft:" + n + "_ore")).addParts(ExternalPart.of(MIParts.ORE_DEEPLSATE, "#c:" + n + "_ores", "minecraft:deepslate_" + n + "_ore"));
        res.addRecipes(SmeltingRecipes::apply, StandardRecipes::apply).cancelRecipes("craft/block_from_gem", "craft/gem_from_block").cancelRecipes("smelting/ore_to_gem_smelting", "smelting/ore_to_gem_blasting").cancelRecipes("smelting/ore_deepslate_to_gem_smelting", "smelting/ore_deepslate_to_gem_blasting");
        if (compressor) {
            res.addRecipes(context -> new MIRecipeBuilder((MaterialBuilder.RecipeContext)context, MIMachineRecipeTypes.COMPRESSOR, n).addTaggedPartInput(MIParts.DUST, 1).addItemOutput("minecraft:" + gemPath, 1));
        }
        return res;
    }

    static {
        GOLD = MaterialRegistry.addMaterial(MIMaterials.addVanillaMetal(true, new MaterialBuilder("Gold", "gold", MaterialSet.SHINY, new BakableTargetColoramp(16770640, MIMaterials.common(MIParts.INGOT), MIMaterials.mcitem("gold_ingot")), MaterialHardness.SOFT).addParts(MIParts.BOLT, MIParts.RING, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.DRILL_HEAD, MIParts.DRILL)).build(new MaterialBuilder.RegisteringEvent[0]));
        IRON = MaterialRegistry.addMaterial(MIMaterials.addVanillaMetal(true, new MaterialBuilder("Iron", "iron", MaterialSet.METALLIC, new BakableTargetColoramp(0xC8C8C8, MIMaterials.common(MIParts.INGOT), MIMaterials.mcitem("iron_ingot")), MaterialHardness.AVERAGE).addParts(MIParts.BOLT, MIParts.RING, MIParts.GEAR, MIParts.ROD, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(ExternalPart.of(MIParts.HAMMER, MIItem.IRON_HAMMER.getId().toString()))).build(new MaterialBuilder.RegisteringEvent[0]));
        COPPER = MaterialRegistry.addMaterial(MIMaterials.addVanillaMetal(false, new MaterialBuilder("Copper", "copper", MaterialSet.METALLIC, new BakableTargetColoramp(15170646, MIMaterials.common(MIParts.INGOT), MIMaterials.mcitem("copper_ingot")), MaterialHardness.SOFT).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.WIRE).addParts(MIParts.FINE_WIRE).addParts(MIParts.CABLE.of(CableTier.LV)).addParts(MIParts.DRILL_HEAD, MIParts.DRILL)).cancelRecipes("macerator/ore_to_raw", "forge_hammer/ore_to_raw_metal", "forge_hammer/ore_to_raw_metal_with_tool", "forge_hammer/ore_to_dust_with_tool").build(new MaterialBuilder.RegisteringEvent[0]));
        COAL = MaterialRegistry.addMaterial(MIMaterials.addVanillaGem(true, new MaterialBuilder("Coal", "coal", MaterialSet.STONE, (Part)MIParts.GEM, new BakableTargetColoramp(0x282828, MIMaterials.common(MIParts.PLATE), MIMaterials.mcitem("coal")), MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_NON_METAL)).addRecipes(ForgeHammerRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        DIAMOND = MaterialRegistry.addMaterial(MIMaterials.addVanillaGem(false, new MaterialBuilder("Diamond", "diamond", MaterialSet.SHINY, (Part)MIParts.GEM, new BakableTargetColoramp(4779738, MIMaterials.mcitem("diamond"), MIMaterials.mcitem("diamond")), MaterialHardness.VERY_HARD).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.PLATE, MIParts.LARGE_PLATE).addParts(ExternalPart.of(MIParts.HAMMER, MIItem.DIAMOND_HAMMER.getId().toString()))).build(new MaterialBuilder.RegisteringEvent[0]));
        EMERALD = MaterialRegistry.addMaterial(MIMaterials.addVanillaGem(false, new MaterialBuilder("Emerald", "emerald", MaterialSet.SHINY, (Part)MIParts.GEM, new BakableTargetColoramp(4191109, MIMaterials.mcitem("emerald"), MIMaterials.mcitem("emerald")), MaterialHardness.VERY_HARD).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.PLATE)).build(new MaterialBuilder.RegisteringEvent[0]));
        LAPIS = MaterialRegistry.addMaterial(MIMaterials.addVanillaGem(true, "lapis_lazuli", new MaterialBuilder("Lapis Lazuli", "lapis", MaterialSet.DULL, (Part)MIParts.GEM, new BakableTargetColoramp(1715597, MIMaterials.common("dust"), MIMaterials.mcitem("lapis_lazuli")), MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.PLATE)).cancelRecipes("macerator/ore_to_crushed").build(new MaterialBuilder.RegisteringEvent[0]));
        REDSTONE = MaterialRegistry.addMaterial(new MaterialBuilder("Redstone", "redstone", MaterialSet.STONE, (Part)MIParts.DUST, new BakableTargetColoramp(0xD20000, MIMaterials.common(MIParts.DUST), MIMaterials.mcitem("redstone")), MaterialHardness.SOFT).addParts(MIParts.TINY_DUST, MIParts.CRUSHED_DUST, MIParts.BATTERY).addParts(ExternalPart.of(MIParts.DUST, "minecraft:redstone", "minecraft:redstone")).addParts(ExternalPart.of(MIParts.BLOCK, "#c:redstone_blocks", "minecraft:redstone_block")).addParts(ExternalPart.of(MIParts.ORE, "#c:redstone_ores", "minecraft:redstone_ore")).addParts(ExternalPart.of(MIParts.ORE_DEEPLSATE, "#c:redstone_ores", "minecraft:deepslate_redstone_ore")).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).cancelRecipes("macerator/ore_to_crushed").cancelRecipes("craft/block_from_dust", "craft/dust_from_block").build(new MaterialBuilder.RegisteringEvent[0]));
        QUARTZ = MaterialRegistry.addMaterial(new MaterialBuilder("Quartz", "quartz", MaterialSet.STONE, (Part)MIParts.GEM, new BakableTargetColoramp(15789028, MIMaterials.mcitem("quartz"), MIMaterials.mcitem("quartz")), MaterialHardness.SOFT).addParts(MIParts.CRUSHED_DUST, MIParts.DUST, MIParts.TINY_DUST).addParts(MIParts.ORE.of(class_6019.method_35017((int)2, (int)5), MaterialOreSet.QUARTZ)).addParts(ExternalPart.of(MIParts.GEM, "minecraft:quartz", "minecraft:quartz")).addRecipes(StandardRecipes::apply).cancelRecipes("macerator/ore_to_crushed").addRecipes(context -> new MIRecipeBuilder((MaterialBuilder.RecipeContext)context, MIMachineRecipeTypes.COMPRESSOR, "quartz").addTaggedPartInput(MIParts.DUST, 1).addItemOutput("minecraft:quartz", 1)).build(new MaterialBuilder.RegisteringEvent[0]));
        BRICK = MaterialRegistry.addMaterial(new MaterialBuilder("Brick", "brick", MaterialSet.STONE, new BakableTargetColoramp(12016182, MIMaterials.common("ingot"), MIMaterials.mcitem("brick")), MaterialHardness.SOFT).addParts(MIParts.DUST, MIParts.TINY_DUST).addParts(ExternalPart.of(MIParts.INGOT, "minecraft:brick", "minecraft:brick")).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        FIRE_CLAY = MaterialRegistry.addMaterial(new MaterialBuilder("Fire Clay", "fire_clay", MaterialSet.STONE, new BakableTargetColoramp(12016182, MIMaterials.common("ingot"), MIMaterials.miitem("fire_clay_brick")), MaterialHardness.SOFT).addParts(MIParts.DUST).addParts(MIItemPart.of(MIParts.INGOT, "Fire Clay Brick", "fire_clay_brick")).addRecipes(SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        COKE = MaterialRegistry.addMaterial(new MaterialBuilder("Coke", "coke", MaterialSet.STONE, (Part)MIParts.GEM, new BakableTargetColoramp(7171415, MIMaterials.common("dust"), MIMaterials.miitem("coke")), MaterialHardness.SOFT).addParts(MIParts.DUST).addParts(MIItemPart.of(MIParts.GEM, "Coke", "coke")).addParts(MIParts.BLOCK.of(MaterialBlockSet.COAL)).addRecipes(context -> new MIRecipeBuilder((MaterialBuilder.RecipeContext)context, MIMachineRecipeTypes.COMPRESSOR, "dust").addTaggedPartInput(MIParts.DUST, 1).addPartOutput(MIParts.GEM, 1)).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        BRONZE = MaterialRegistry.addMaterial(new MaterialBuilder("Bronze", "bronze", MaterialSet.SHINY, new BakableTargetColoramp(0xFFCC00, MIMaterials.common("ingot"), MIMaterials.template("bronze_ingot")), MaterialHardness.SOFT).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).removeParts(MIParts.CRUSHED_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addParts(MIParts.TANK.of(4)).addParts(MIParts.DRILL_HEAD, MIParts.DRILL).addParts(MIParts.BARREL.of(32)).addParts(MIParts.MACHINE_CASING, MIParts.MACHINE_CASING_PIPE).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Bronze Plated Bricks", "bronze_plated_bricks")).addRecipes(ForgeHammerRecipes::apply, SmeltingRecipes::apply, StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        TIN = MaterialRegistry.addMaterial(new MaterialBuilder("Tin", "tin", MaterialSet.DULL, new BakableTargetColoramp(12631248, MIMaterials.common("ingot"), MIMaterials.template("tin_ingot")), MaterialHardness.SOFT).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.ORE.ofAll(16, 9, 64, MaterialOreSet.IRON)).addParts(MIParts.WIRE).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.GOLD)).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addParts(MIParts.CABLE.of(CableTier.LV)).addRecipes(ForgeHammerRecipes::apply, SmeltingRecipes::apply, StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        STEEL = MaterialRegistry.addMaterial(new MaterialBuilder("Steel", "steel", MaterialSet.METALLIC, new BakableTargetColoramp(0x3F3F3F, MIMaterials.common("ingot"), MIMaterials.template("steel_ingot")), MaterialHardness.AVERAGE).addParts(MIParts.BOLT, MIParts.RING, MIParts.ROD, MIParts.GEAR, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.ROD_MAGNETIC).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addParts(MIParts.DRILL_HEAD, MIParts.DRILL).addParts(MIParts.MACHINE_CASING, MIParts.MACHINE_CASING_PIPE).addParts(MIParts.TANK.of(8)).addParts(MIParts.BARREL.of(128)).addParts(ExternalPart.of(MIParts.HAMMER, MIItem.STEEL_HAMMER.getId().toString())).addRecipes(ForgeHammerRecipes::apply, SmeltingRecipes::apply, StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        LIGNITE_COAL = MaterialRegistry.addMaterial(new MaterialBuilder("Lignite Coal", "lignite_coal", MaterialSet.STONE, (Part)MIParts.GEM, 0x644646, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.BLOCK.of(MaterialBlockSet.COAL)).addParts(MIParts.GEM).addParts(MIParts.ORE.ofAll(class_6019.method_35017((int)0, (int)2), 25, 17, 256, MaterialOreSet.COAL)).addRecipes(ForgeHammerRecipes::apply, SmeltingRecipes::apply, StandardRecipes::apply).cancelRecipes("macerator/crushed_dust").addRecipes(context -> new MIRecipeBuilder((MaterialBuilder.RecipeContext)context, MIMachineRecipeTypes.COMPRESSOR, "lignite_coal").addTaggedPartInput(MIParts.DUST, 1).addPartOutput(MIParts.GEM, 1)).build(new MaterialBuilder.RegisteringEvent[0]));
        ALUMINUM = MaterialRegistry.addMaterial(new MaterialBuilder("Aluminum", "aluminum", MaterialSet.METALLIC, new BakableTargetColoramp(4180735, MIMaterials.common("ingot"), MIMaterials.template("aluminum_ingot")), MaterialHardness.AVERAGE).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.WIRE).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.MACHINE_CASING.of("Advanced Machine Casing", "advanced_machine_casing")).addParts(MIParts.DRILL_HEAD, MIParts.DRILL).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Frostproof Machine Casing", "frostproof_machine_casing")).addParts(MIParts.TANK.of(16)).addParts(MIParts.BARREL.of(512)).addParts(MIParts.CABLE.of(CableTier.HV)).addRecipes(StandardRecipes::apply).addRecipes(SmeltingRecipes::applyBlastFurnace).build(new MaterialBuilder.RegisteringEvent[0]));
        BAUXITE = MaterialRegistry.addMaterial(new MaterialBuilder("Bauxite", "bauxite", MaterialSet.DULL, (Part)MIParts.DUST, 13132800, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.BLOCK.of(MaterialBlockSet.LAPIS)).addParts(MIParts.ORE.ofAll(class_6019.method_35017((int)1, (int)4), 24, 7, 32, MaterialOreSet.REDSTONE)).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        LEAD = MaterialRegistry.addMaterial(new MaterialBuilder("Lead", "lead", MaterialSet.DULL, new BakableTargetColoramp(6977212, MIMaterials.common("ingot"), MIMaterials.template("lead_ingot")), MaterialHardness.AVERAGE).addParts(MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addParts(MIParts.ORE.ofAll(16, 5, 64, MaterialOreSet.IRON)).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.IRON)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).cancelRecipes("macerator/raw_metal").build(new MaterialBuilder.RegisteringEvent[0]));
        BATTERY_ALLOY = MaterialRegistry.addMaterial(new MaterialBuilder("Battery Alloy", "battery_alloy", MaterialSet.DULL, 10255520, MaterialHardness.SOFT).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.INGOT, MIParts.DOUBLE_INGOT, MIParts.PLATE, MIParts.CURVED_PLATE, MIParts.NUGGET, MIParts.LARGE_PLATE).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        INVAR = MaterialRegistry.addMaterial(new MaterialBuilder("Invar", "invar", MaterialSet.METALLIC, 14474390, MaterialHardness.AVERAGE).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Heatproof Machine Casing", "heatproof_machine_casing")).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.INGOT, MIParts.ROD, MIParts.DOUBLE_INGOT, MIParts.RING, MIParts.BOLT, MIParts.PLATE, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.GEAR).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        CUPRONICKEL = MaterialRegistry.addMaterial(new MaterialBuilder("Cupronickel", "cupronickel", MaterialSet.METALLIC, 14915201, MaterialHardness.SOFT).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.INGOT, MIParts.DOUBLE_INGOT, MIParts.PLATE, MIParts.WIRE, MIParts.NUGGET, MIParts.WIRE_MAGNETIC).addParts(MIParts.COIL).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addParts(MIParts.CABLE.of(CableTier.MV)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        ANTIMONY = MaterialRegistry.addMaterial(new MaterialBuilder("Antimony", "antimony", MaterialSet.SHINY, 14474480, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.COPPER)).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addParts(MIParts.ORE.ofAll(20, 5, 64, MaterialOreSet.REDSTONE)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        NICKEL = MaterialRegistry.addMaterial(new MaterialBuilder("Nickel", "nickel", MaterialSet.METALLIC, 16448200, MaterialHardness.AVERAGE).addParts(MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.IRON)).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addParts(MIParts.ORE.ofAll(14, 6, 64, MaterialOreSet.IRON)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        SILVER = MaterialRegistry.addMaterial(new MaterialBuilder("Silver", "silver", MaterialSet.SHINY, new BakableTargetColoramp(0xDCDCFF, MIMaterials.common("ingot"), MIMaterials.template("silver_ingot")), MaterialHardness.SOFT).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.GOLD)).addParts(MIParts.CABLE.of(CableTier.LV)).addParts(MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST, MIParts.WIRE).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        SODIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Sodium", "sodium", MaterialSet.STONE, (Part)MIParts.DUST, 466104, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.BLOCK.of(MaterialBlockSet.LAPIS)).addParts(MIParts.BATTERY).removeParts(MIParts.CRUSHED_DUST).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        SALT = MaterialRegistry.addMaterial(new MaterialBuilder("Salt", "salt", MaterialSet.STONE, (Part)MIParts.DUST, 13096645, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_NON_METAL).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addParts(MIParts.ORE.ofAll(class_6019.method_35017((int)1, (int)3), 6, 6, 64, MaterialOreSet.COAL)).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        TITANIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Titanium", "titanium", MaterialSet.METALLIC, new BakableTargetColoramp(14459120, MIMaterials.common("ingot"), MIMaterials.template("titanium_ingot")), MaterialHardness.HARD).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.NETHERITE)).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.COPPER)).addParts(MIParts.HOT_INGOT).addParts(MIParts.MACHINE_CASING.of("Highly Advanced Machine Casing", "highly_advanced_machine_casing")).addParts(MIParts.DRILL_HEAD, MIParts.DRILL).addParts(MIParts.MACHINE_CASING_PIPE).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Solid Titanium Machine Casing", "solid_titanium_machine_casing")).addParts(MIParts.ORE.of(MaterialOreSet.IRON)).addParts(MIParts.TANK.of(64)).addParts(MIParts.BARREL.of(8192)).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, true, 128, 400)).cancelRecipes("macerator/raw_metal").build(new MaterialBuilder.RegisteringEvent[0]));
        ELECTRUM = MaterialRegistry.addMaterial(new MaterialBuilder("Electrum", "electrum", MaterialSet.SHINY, new BakableTargetColoramp(0xFFFF64, MIMaterials.common("ingot"), MIMaterials.template("electrum_ingot")), MaterialHardness.SOFT).addParts(MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.WIRE, MIParts.FINE_WIRE).addParts(MIParts.CABLE.of(CableTier.MV)).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        SILICON = MaterialRegistry.addMaterial(new MaterialBuilder("Silicon", "silicon", MaterialSet.METALLIC, 3947600, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addParts(MIParts.N_DOPED_PLATE, MIParts.P_DOPED_PLATE).addParts(MIParts.PLATE, MIParts.DOUBLE_INGOT, MIParts.BATTERY).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        STAINLESS_STEEL = MaterialRegistry.addMaterial(new MaterialBuilder("Stainless Steel", "stainless_steel", MaterialSet.SHINY, new BakableTargetColoramp(0xC8C8DC, MIMaterials.common("ingot"), MIMaterials.template("stainless_steel_ingot")), MaterialHardness.HARD).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addParts(MIParts.BOLT, MIParts.BLADE, MIParts.RING, MIParts.ROTOR, MIParts.GEAR, MIParts.ROD, MIParts.CURVED_PLATE, MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.LARGE_PLATE, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addParts(MIParts.HOT_INGOT).addParts(MIParts.DRILL_HEAD, MIParts.DRILL).addParts(MIParts.MACHINE_CASING.of("Turbo Machine Casing", "turbo_machine_casing")).addParts(MIParts.MACHINE_CASING_PIPE).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Clean Stainless Steel Machine Casing", "clean_stainless_steel_machine_casing")).addParts(MIParts.ROD_MAGNETIC).addParts(MIParts.TANK.of(32)).addParts(MIParts.BARREL.of(4096)).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, true, 32, 400)).cancelRecipes("polarizer/rod_magnetic").build(new MaterialBuilder.RegisteringEvent[0]));
        RUBY = MaterialRegistry.addMaterial(new MaterialBuilder("Ruby", "ruby", MaterialSet.SHINY, 13697055, MaterialHardness.HARD).addParts(MIParts.DUST, MIParts.TINY_DUST).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        CARBON = MaterialRegistry.addMaterial(new MaterialBuilder("Carbon", "carbon", MaterialSet.DULL, 0x444444, MaterialHardness.SOFT).addParts(MIParts.DUST, MIParts.TINY_DUST, MIParts.PLATE).addParts(MIParts.LARGE_PLATE.withRegister((partContext, part, itemPath, itemId, itemTag) -> NuclearAbsorbable.of("Carbon Large Plate", itemPath, 2500, 0.02, INeutronBehaviour.of(NuclearConstant.ScatteringType.MEDIUM, NuclearConstant.CARBON, 2.0), 20480000))).addRecipes(context -> new MIRecipeBuilder((MaterialBuilder.RecipeContext)context, MIMachineRecipeTypes.COMPRESSOR, "dust").addTaggedPartInput(MIParts.DUST, 1).addPartOutput(MIParts.PLATE, 1)).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        CHROMIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Chromium", "chromium", MaterialSet.SHINY, new BakableTargetColoramp(0xFFE6E6, MIMaterials.common("ingot"), MIMaterials.template("chromium_ingot")), MaterialHardness.AVERAGE).addParts(MIParts.CRUSHED_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.HOT_INGOT).addParts(MIParts.PLATE, MIParts.LARGE_PLATE, MIParts.DOUBLE_INGOT).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, true, 32, 400)).cancelRecipes("macerator/crushed_dust").build(new MaterialBuilder.RegisteringEvent[0]));
        MANGANESE = MaterialRegistry.addMaterial(new MaterialBuilder("Manganese", "manganese", MaterialSet.DULL, 0xC1C1C1, MaterialHardness.AVERAGE).addParts(MIParts.BLOCK.of(MaterialBlockSet.IRON)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.CRUSHED_DUST).addRecipes(StandardRecipes::apply).cancelRecipes("macerator/crushed_dust").build(new MaterialBuilder.RegisteringEvent[0]));
        BERYLLIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Beryllium", "beryllium", MaterialSet.SHINY, 0x64B464, MaterialHardness.HARD).addParts(MIParts.BLOCK.of(MaterialBlockSet.NETHERITE)).addParts(MIParts.DOUBLE_INGOT, MIParts.DUST, MIParts.INGOT, MIParts.NUGGET, MIParts.PLATE, MIParts.TINY_DUST).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        ANNEALED_COPPER = MaterialRegistry.addMaterial(new MaterialBuilder("Annealed Copper", "annealed_copper", MaterialSet.SHINY, 16749135, MaterialHardness.SOFT).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addParts(MIParts.PLATE, MIParts.WIRE, MIParts.DOUBLE_INGOT, MIParts.HOT_INGOT).addParts(MIParts.CABLE.of(CableTier.EV)).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, false, 64)).build(new MaterialBuilder.RegisteringEvent[0]));
        URANIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Uranium", "uranium", MaterialSet.DULL, 3794432, MaterialHardness.AVERAGE).addParts(MIParts.FUEL_ROD.ofAll(NuclearConstant.U)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.ROD).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ORE.ofAll(8, 5, 16, MaterialOreSet.COPPER)).addParts(MIParts.RAW_METAL.of(MaterialRawSet.URANIUM)).addParts(MIParts.RAW_METAL_BLOCK.of(MaterialRawSet.COPPER)).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)).build(new MaterialBuilder.RegisteringEvent[0]));
        URANIUM_235 = MaterialRegistry.addMaterial(new MaterialBuilder("Uranium 235", "uranium_235", MaterialSet.SHINY, 15073349, MaterialHardness.VERY_HARD).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)).build(new MaterialBuilder.RegisteringEvent[0]));
        URANIUM_238 = MaterialRegistry.addMaterial(new MaterialBuilder("Uranium 238", "uranium_238", MaterialSet.DULL, 5618995, MaterialHardness.SOFT).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)).build(new MaterialBuilder.RegisteringEvent[0]));
        LE_URANIUM = MaterialRegistry.addMaterial(new MaterialBuilder("LE Uranium", "le_uranium", MaterialSet.DULL, 7381820, MaterialHardness.VERY_HARD).addParts(MIParts.FUEL_ROD.ofAll(NuclearConstant.LEU)).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.ROD).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)).build(new MaterialBuilder.RegisteringEvent[0]));
        HE_URANIUM = MaterialRegistry.addMaterial(new MaterialBuilder("HE Uranium", "he_uranium", MaterialSet.DULL, 11200568, MaterialHardness.VERY_HARD).addParts(MIParts.FUEL_ROD.ofAll(NuclearConstant.HEU)).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.ROD).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)).build(new MaterialBuilder.RegisteringEvent[0]));
        LE_MOX = MaterialRegistry.addMaterial(new MaterialBuilder("LE Mox", "le_mox", MaterialSet.SHINY, 59365, MaterialHardness.VERY_HARD).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.FUEL_ROD.ofAll(NuclearConstant.LE_MOX)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.ROD).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)).build(new MaterialBuilder.RegisteringEvent[0]));
        HE_MOX = MaterialRegistry.addMaterial(new MaterialBuilder("HE Mox", "he_mox", MaterialSet.SHINY, 13404154, MaterialHardness.VERY_HARD).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.FUEL_ROD.ofAll(NuclearConstant.HE_MOX)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.ROD).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)).build(new MaterialBuilder.RegisteringEvent[0]));
        PLUTONIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Plutonium", "plutonium", MaterialSet.SHINY, 14090727, MaterialHardness.VERY_HARD).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.BATTERY).addRecipes(StandardRecipes::apply).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, 128)).build(new MaterialBuilder.RegisteringEvent[0]));
        PLATINUM = MaterialRegistry.addMaterial(new MaterialBuilder("Platinum", "platinum", MaterialSet.SHINY, new BakableTargetColoramp(16770490, MIMaterials.common("ingot"), MIMaterials.template("platinum_ingot")), MaterialHardness.AVERAGE).addParts(MIParts.BLOCK.of(MaterialBlockSet.GOLD)).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.GOLD)).addParts(MIParts.ORE.of(MaterialOreSet.GOLD)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.PLATE, MIParts.DOUBLE_INGOT, MIParts.WIRE, MIParts.FINE_WIRE, MIParts.HOT_INGOT).addParts(MIParts.CABLE.of(CableTier.EV)).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, true, 128, 600)).addRecipes(StandardRecipes::apply).cancelRecipes("macerator/raw_metal").build(new MaterialBuilder.RegisteringEvent[0]));
        KANTHAL = MaterialRegistry.addMaterial(new MaterialBuilder("Kanthal", "kanthal", MaterialSet.METALLIC, new BakableTargetColoramp(13617920, MIMaterials.common("ingot"), MIMaterials.template("kanthal_ingot")), MaterialHardness.HARD).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.PLATE, MIParts.INGOT, MIParts.NUGGET, MIParts.WIRE, MIParts.DOUBLE_INGOT, MIParts.HOT_INGOT).addParts(MIParts.COIL).addParts(MIParts.BLOCK.of(MaterialBlockSet.COPPER)).addRecipes(ctx -> SmeltingRecipes.applyBlastFurnace(ctx, true, 32, 400)).addParts(MIParts.CABLE.of(CableTier.HV)).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        IRIDIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Iridium", "iridium", MaterialSet.SHINY, new BakableTargetColoramp(14804725, MIMaterials.common("ingot"), MIMaterials.template("iridium_ingot")), MaterialHardness.VERY_HARD).addParts(MIParts.BLOCK.of(MaterialBlockSet.DIAMOND)).addParts(MIParts.ITEM_PURE_METAL).addParts(MIParts.CURVED_PLATE).addParts(MIParts.ORE.ofAll(10, 1, 16, MaterialOreSet.DIAMOND)).addParts(MIParts.MACHINE_CASING.of("Quantum Machine Casing!", "quantum_machine_casing", 6000.0f)).addParts(MIParts.TANK.of("Quantum Tank!", Integer.MAX_VALUE).withCustomPath("quantum_tank")).addParts(MIParts.BARREL.of("Quantum Barrel!", Integer.MAX_VALUE).withCustomPath("quantum_barrel")).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Plasma Handling %s Machine Casing", "plasma_handling_iridium_machine_casing", 6000.0f)).addParts(MIParts.MACHINE_CASING_PIPE.of(6000.0f)).addParts(MIParts.RAW_METAL.of(MaterialRawSet.IRIDIUM), MIParts.PLATE).addParts(MIParts.RAW_METAL_BLOCK.of(MaterialRawSet.GOLD)).addRecipes(StandardRecipes::apply).addRecipes(SmeltingRecipes::apply).cancelRecipes("compressor/main").cancelRecipes("craft/tank").cancelRecipes("craft/barrel").cancelRecipes("assembler/tank").cancelRecipes("assembler/barrel").build(new MaterialBuilder.RegisteringEvent[0]));
        MOZANITE = MaterialRegistry.addMaterial(new MaterialBuilder("Mozanite", "mozanite", MaterialSet.STONE, (Part)MIParts.DUST, 9839758, MaterialHardness.SOFT).addParts(MIParts.CRUSHED_DUST, MIParts.DUST, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addParts(MIParts.ORE.ofAll(class_6019.method_35017((int)1, (int)4), 2, 3, 24, MaterialOreSet.LAPIS)).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        CADMIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Cadmium", "cadmium", MaterialSet.DULL, 9859620, MaterialHardness.SOFT).addParts(MIParts.DUST, MIParts.TINY_DUST, MIParts.INGOT, MIParts.PLATE, MIParts.ROD, MIParts.DOUBLE_INGOT, MIParts.BATTERY).addParts(new RegularPart("Control Rod", MIParts.FUEL_ROD.key).withRegister((partContext, part, itemPath1, itemId, itemTag) -> NuclearAbsorbable.of("Cadmium Control Rod", itemPath1, 1900, 0.005, INeutronBehaviour.of(NuclearConstant.ScatteringType.HEAVY, NuclearConstant.CADMIUM, 1.0), 10240000)).withCustomFormattablePath("%s_control_rod")).addRecipes(StandardRecipes::apply, SmeltingRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        NEODYMIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Neodymium", "neodymium", MaterialSet.STONE, (Part)MIParts.DUST, 1918214, MaterialHardness.SOFT).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addParts(MIParts.DUST, MIParts.TINY_DUST).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        YTTRIUM = MaterialRegistry.addMaterial(new MaterialBuilder("Yttrium", "yttrium", MaterialSet.STONE, (Part)MIParts.DUST, 1266022, MaterialHardness.SOFT).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addParts(MIParts.DUST, MIParts.TINY_DUST).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        SUPERCONDUCTOR = MaterialRegistry.addMaterial(new MaterialBuilder("Superconductor", "superconductor", MaterialSet.SHINY, new BakableTargetColoramp(8840172, MIMaterials.common("ingot"), MIMaterials.template("superconductor_ingot")), MaterialHardness.HARD).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.PLATE, MIParts.INGOT, MIParts.NUGGET, MIParts.WIRE, MIParts.DOUBLE_INGOT, MIParts.HOT_INGOT).addParts(MIParts.COIL).addParts(MIParts.CABLE.of(CableTier.SUPERCONDUCTOR)).addRecipes(StandardRecipes::apply).cancelRecipes("craft/cable", "packer/cable", "assembler/cable_synthetic_rubber", "assembler/cable_styrene_rubber").build(new MaterialBuilder.RegisteringEvent[0]));
        TUNGSTEN = MaterialRegistry.addMaterial(new MaterialBuilder("Tungsten", "tungsten", MaterialSet.METALLIC, new BakableTargetColoramp(8872109, MIMaterials.common("ingot"), MIMaterials.template("tungsten_ingot")), MaterialHardness.VERY_HARD).addParts(MIParts.RAW_METAL.ofAll(MaterialRawSet.COPPER)).addParts(MIParts.TINY_DUST, MIParts.DUST, MIParts.PLATE, MIParts.INGOT, MIParts.NUGGET, MIParts.LARGE_PLATE, MIParts.DOUBLE_INGOT, MIParts.ROD).addParts(MIParts.BLOCK.of(MaterialBlockSet.NETHERITE)).addParts(MIParts.ORE.ofAll(6, 5, 20, MaterialOreSet.IRON)).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        BLASTPROOF_ALLOY = MaterialRegistry.addMaterial(new MaterialBuilder("Blastproof Alloy", "blastproof_alloy", MaterialSet.METALLIC, 5393466, MaterialHardness.VERY_HARD).addParts(MIParts.INGOT, MIParts.PLATE, MIParts.LARGE_PLATE, MIParts.CURVED_PLATE).addParts(MIParts.MACHINE_CASING_SPECIAL.of("Blastproof Casing!", "blastproof_casing", 6000.0f)).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        NUCLEAR_ALLOY = MaterialRegistry.addMaterial(new MaterialBuilder("Nuclear Alloy", "nuclear_alloy", MaterialSet.METALLIC, 4017458, MaterialHardness.VERY_HARD).addParts(MIParts.PLATE, MIParts.LARGE_PLATE).addParts(MIParts.MACHINE_CASING_SPECIAL.of("%s Casing", "nuclear_casing", 6000.0f)).addParts(MIParts.MACHINE_CASING_PIPE.of(6000.0f)).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        SOLDERING_ALLOY = MaterialRegistry.addMaterial(new MaterialBuilder("Soldering Alloy", "soldering_alloy", MaterialSet.DULL, (Part)MIParts.DUST, -5520193, MaterialHardness.SOFT).addParts(MIParts.DUST, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
        SULFUR = MaterialRegistry.addMaterial(new MaterialBuilder("Sulfur", "sulfur", MaterialSet.DULL, (Part)MIParts.DUST, 14530068, MaterialHardness.SOFT).addParts(MIParts.DUST, MIParts.TINY_DUST).addParts(MIParts.BLOCK.of(MaterialBlockSet.REDSTONE)).addRecipes(StandardRecipes::apply).build(new MaterialBuilder.RegisteringEvent[0]));
    }
}

