/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyExtractable;
import aztech.modern_industrialization.api.energy.EnergyInsertable;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_2487;

public class EnergyComponent
implements IComponent.ServerOnly {
    private long storedEu;
    private final Supplier<Long> capacity;

    public EnergyComponent(Supplier<Long> capacity) {
        this.capacity = capacity;
    }

    public EnergyComponent(long capacity) {
        this.capacity = () -> capacity;
    }

    public long getEu() {
        return Math.min(this.storedEu, this.capacity.get());
    }

    public long getCapacity() {
        return this.capacity.get();
    }

    public long getRemainingCapacity() {
        return this.capacity.get() - this.getEu();
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10544("storedEu", this.getEu());
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.setEu(tag.method_10537("storedEu"));
    }

    private void setEu(long eu) {
        this.storedEu = Math.min(eu, this.capacity.get());
    }

    public long consumeEu(long max, Simulation simulation) {
        Preconditions.checkArgument((max >= 0L ? 1 : 0) != 0, (Object)"May not consume < 0 energy.");
        long ext = Math.min(max, this.getEu());
        if (simulation.isActing()) {
            this.setEu(this.getEu() - ext);
        }
        return ext;
    }

    public long insertEu(long max, Simulation simulation) {
        Preconditions.checkArgument((max >= 0L ? 1 : 0) != 0, (Object)"May not insert < 0 energy.");
        long ext = Math.min(max, this.capacity.get() - this.getEu());
        if (simulation.isActing()) {
            this.setEu(this.getEu() + ext);
        }
        return ext;
    }

    public void insertEnergy(EnergyInsertable insertable) {
        this.setEu(this.getEu() - insertable.insertEnergy(this.getEu(), Simulation.ACT));
    }

    public EnergyInsertable buildInsertable(final Predicate<CableTier> canInsert) {
        return new EnergyInsertable(){

            @Override
            public long insertEnergy(long amount, Simulation simulation) {
                Preconditions.checkArgument((amount >= 0L ? 1 : 0) != 0, (Object)"May not insert < 0 energy.");
                long inserted = Math.min(amount, EnergyComponent.this.capacity.get() - EnergyComponent.this.getEu());
                if (simulation.isActing()) {
                    EnergyComponent.this.setEu(EnergyComponent.this.getEu() + inserted);
                }
                return inserted;
            }

            @Override
            public boolean canInsert(CableTier tier) {
                return canInsert.test(tier);
            }
        };
    }

    public EnergyExtractable buildExtractable(final Predicate<CableTier> canExtract) {
        return new EnergyExtractable(){

            @Override
            public long extractEnergy(long amount, Simulation simulation) {
                Preconditions.checkArgument((amount >= 0L ? 1 : 0) != 0, (Object)"May not extract < 0 energy.");
                long extracted = Math.min(amount, EnergyComponent.this.getEu());
                if (simulation.isActing()) {
                    EnergyComponent.this.setEu(EnergyComponent.this.getEu() - extracted);
                }
                return extracted;
            }

            @Override
            public boolean canExtract(CableTier tier) {
                return canExtract.test(tier);
            }
        };
    }
}

