/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.compat.megane.holder.EnergyListComponentHolder;
import aztech.modern_industrialization.compat.rei.machines.ReiMachineRecipes;
import aztech.modern_industrialization.definition.BlockDefinition;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.multiblocks.AbstractCraftingMultiblockBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.LubricantHelper;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.machines.components.sync.ProgressBar;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.init.MultiblockMachines;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Simulation;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class ElectricBlastFurnaceBlockEntity
extends AbstractCraftingMultiblockBlockEntity
implements EnergyListComponentHolder {
    private static final ShapeTemplate[] shapeTemplates;
    private final List<EnergyComponent> energyInputs = new ArrayList<EnergyComponent>();
    private final UpgradeComponent upgrades = new UpgradeComponent();
    public static final ArrayList<String> coilNames;
    public static final ArrayList<String> coilEnglishNames;
    public static final ArrayList<class_2248> coils;
    public static final Map<class_2248, Long> coilsMaxBaseEU;

    public ElectricBlastFurnaceBlockEntity(BEP bep) {
        super(bep, "electric_blast_furnace", new OrientationComponent.Params(false, false, false), shapeTemplates);
        this.registerComponents(this.upgrades);
    }

    @Override
    protected CrafterComponent.Behavior getBehavior() {
        return new Behavior();
    }

    @Override
    public List<EnergyComponent> getEnergyComponents() {
        return this.energyInputs;
    }

    @Override
    protected void onSuccessfulMatch(ShapeMatcher shapeMatcher) {
        this.energyInputs.clear();
        for (HatchBlockEntity hatch : shapeMatcher.getMatchedHatches()) {
            hatch.appendEnergyInputs(this.energyInputs);
        }
    }

    @Override
    protected class_1269 onUse(class_1657 player, class_1268 hand, class_2350 face) {
        class_1269 result = super.onUse(player, hand, face);
        if (!result.method_23665()) {
            result = this.upgrades.onUse(this, player, hand);
        }
        if (!result.method_23665()) {
            result = LubricantHelper.onUse(this.crafter, player, hand);
        }
        return result;
    }

    @Override
    public List<class_1799> dropExtra() {
        List<class_1799> drops = super.dropExtra();
        drops.add(this.upgrades.getDrop());
        return drops;
    }

    public static void registerReiShapes() {
        for (ShapeTemplate shapeTemplate : shapeTemplates) {
            ReiMachineRecipes.registerMultiblockShape("electric_blast_furnace", shapeTemplate);
        }
    }

    static {
        int i;
        coilNames = new ArrayList();
        coilEnglishNames = new ArrayList();
        coils = new ArrayList();
        coilsMaxBaseEU = new IdentityHashMap<class_2248, Long>();
        coilNames.add("cupronickel_coil");
        coilNames.add("kanthal_coil");
        for (String coilName : coilNames) {
            coils.add((class_2248)((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier(coilName))).asBlock());
        }
        coilEnglishNames.add(" (Cupronickel Tier)");
        coilEnglishNames.add(" (Kanthal Tier)");
        coilsMaxBaseEU.put(coils.get(0), 32L);
        coilsMaxBaseEU.put(coils.get(1), 128L);
        shapeTemplates = new ShapeTemplate[coils.size()];
        for (i = 0; i < coils.size(); ++i) {
            ShapeTemplate ebfShape;
            SimpleMember invarCasings = SimpleMember.forBlock(((BlockDefinition)MIBlock.BLOCKS.get((Object)new MIIdentifier("heatproof_machine_casing"))).asBlock());
            SimpleMember coilsBlocks = SimpleMember.forBlock(coils.get(i));
            HatchFlags ebfHatches = new HatchFlags.Builder().with(HatchType.ITEM_INPUT, HatchType.ITEM_OUTPUT, HatchType.FLUID_INPUT, HatchType.FLUID_OUTPUT, HatchType.ENERGY_INPUT).build();
            ElectricBlastFurnaceBlockEntity.shapeTemplates[i] = ebfShape = new ShapeTemplate.Builder(MachineCasings.HEATPROOF).add3by3(0, invarCasings, false, ebfHatches).add3by3(1, coilsBlocks, true, null).add3by3(2, coilsBlocks, true, null).add3by3(3, invarCasings, false, ebfHatches).build();
        }
        for (i = 0; i < coils.size(); ++i) {
            long previousMax = i == 0 ? 4L : coilsMaxBaseEU.get(coils.get(i - 1));
            long currentMax = coilsMaxBaseEU.get(coils.get(i));
            ArrayList<String> workstations = new ArrayList<String>();
            workstations.add("electric_blast_furnace");
            for (int j = i; j < coils.size(); ++j) {
                workstations.add(coilNames.get(j));
            }
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) continue;
            new MultiblockMachines.Rei("EBF" + coilEnglishNames.get(i), "electric_blast_furnace_" + i, MIMachineRecipeTypes.BLAST_FURNACE, new ProgressBar.Parameters(77, 33, "arrow")).items(inputs -> inputs.addSlots(56, 35, 2, 1), outputs -> outputs.addSlot(102, 35)).fluids(fluids -> fluids.addSlot(36, 35), outputs -> outputs.addSlot(122, 35)).extraTest(recipe -> previousMax < (long)recipe.eu && (long)recipe.eu <= currentMax).workstations(workstations.toArray(new String[0])).register();
        }
    }

    private class Behavior
    implements CrafterComponent.Behavior {
        private Behavior() {
        }

        @Override
        public long consumeEu(long max, Simulation simulation) {
            long total = 0L;
            for (EnergyComponent energyComponent : ElectricBlastFurnaceBlockEntity.this.energyInputs) {
                total += energyComponent.consumeEu(max - total, simulation);
            }
            return total;
        }

        @Override
        public MachineRecipeType recipeType() {
            return MIMachineRecipeTypes.BLAST_FURNACE;
        }

        @Override
        public boolean banRecipe(MachineRecipe recipe) {
            int index = ElectricBlastFurnaceBlockEntity.this.activeShape.getActiveShapeIndex();
            return (long)recipe.eu > this.getMaxRecipeEu() || (long)recipe.eu > coilsMaxBaseEU.get(coils.get(index));
        }

        @Override
        public long getBaseRecipeEu() {
            return MachineTier.MULTIBLOCK.getBaseEu();
        }

        @Override
        public long getMaxRecipeEu() {
            return (long)MachineTier.MULTIBLOCK.getMaxEu() + ElectricBlastFurnaceBlockEntity.this.upgrades.getAddMaxEUPerTick();
        }

        @Override
        public class_1937 getCrafterWorld() {
            return ElectricBlastFurnaceBlockEntity.this.field_11863;
        }

        @Override
        @Nullable
        public UUID getOwnerUuid() {
            return ElectricBlastFurnaceBlockEntity.this.placedBy.placerId;
        }
    }
}

