/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.hatches;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.sync.AutoExtract;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.multiblocks.HatchBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.HatchType;
import java.util.List;

public class FluidHatch
extends HatchBlockEntity {
    private final boolean input;
    private final boolean upgradesToSteel;
    private final MIInventory inventory;

    public FluidHatch(BEP bep, MachineGuiParameters guiParams, boolean input, boolean upgradesToSteel, MIInventory inventory) {
        super(bep, guiParams, new OrientationComponent.Params(true, false, true));
        this.input = input;
        this.upgradesToSteel = upgradesToSteel;
        this.inventory = inventory;
        this.registerComponents(inventory);
        this.registerClientComponent(new AutoExtract.Server(this.orientation, input));
    }

    @Override
    public HatchType getHatchType() {
        return this.input ? HatchType.FLUID_INPUT : HatchType.FLUID_OUTPUT;
    }

    @Override
    public boolean upgradesToSteel() {
        return this.upgradesToSteel;
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void appendFluidInputs(List<ConfigurableFluidStack> list) {
        if (this.input) {
            list.addAll(this.inventory.getFluidStacks());
        }
    }

    @Override
    public void appendFluidOutputs(List<ConfigurableFluidStack> list) {
        if (!this.input) {
            list.addAll(this.inventory.getFluidStacks());
        }
    }

    @Override
    protected void tickTransfer() {
        if (this.orientation.extractFluids) {
            if (this.input) {
                this.inventory.autoInsertFluids(this.field_11863, this.field_11867, this.orientation.outputDirection);
            } else {
                this.inventory.autoExtractFluids(this.field_11863, this.field_11867, this.orientation.outputDirection);
            }
        }
    }
}

