/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import aztech.modern_industrialization.client.model.MachineBakedModel;
import aztech.modern_industrialization.compat.sodium.SodiumCompat;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_773;
import net.minecraft.class_777;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class MachineBlockEntityRenderer<T extends MachineBlockEntity>
implements class_827<T> {
    private final class_773 blockModels;
    private class_2680 lastBlockState = null;
    private MachineBakedModel model = null;
    private final IdentityHashMap<MachineCasing, Object[]> quadCache = new IdentityHashMap();
    private static final Object NO_QUAD = new Object();
    private static final Field FORWARDING_BAKED_MODEL_WRAPPED;

    public MachineBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.blockModels = ctx.method_32141().method_3351();
    }

    @Nullable
    private class_777 getCachedQuad(MachineModelClientData data, class_2350 d) {
        Object quad;
        class_2350 facing = data.frontDirection;
        int cachedQuadIndex = facing.ordinal() * 6 + d.ordinal();
        MachineCasing casing = data.casing;
        Object[] cachedQuads = this.quadCache.computeIfAbsent(casing, c -> new Object[36]);
        if (cachedQuads[cachedQuadIndex] == null) {
            Renderer renderer = RendererAccess.INSTANCE.getRenderer();
            QuadEmitter emitter = renderer.meshBuilder().getEmitter();
            class_1058 sprite = MachineBakedModel.getSprite(this.model.getSprites(casing), d, facing, true);
            if (sprite != null) {
                emitter.material(this.model.cutoutMaterial);
                emitter.square(d, 0.0f, 0.0f, 1.0f, 1.0f, -2.0E-4f);
                emitter.cullFace(d);
                emitter.spriteBake(0, sprite, 4);
                emitter.spriteColor(0, -1, -1, -1, -1);
                cachedQuads[cachedQuadIndex] = emitter.toBakedQuad(0, sprite, false);
            } else {
                cachedQuads[cachedQuadIndex] = NO_QUAD;
            }
        }
        return (quad = cachedQuads[cachedQuadIndex]) == NO_QUAD ? null : (class_777)quad;
    }

    private MachineBakedModel getMachineModel(class_2680 state) {
        class_1087 model = this.blockModels.method_3335(state);
        while (true) {
            if (model instanceof MachineBakedModel) {
                MachineBakedModel mbm = (MachineBakedModel)model;
                return mbm;
            }
            if (!(model instanceof ForwardingBakedModel)) break;
            ForwardingBakedModel fbm = (ForwardingBakedModel)model;
            try {
                model = (class_1087)FORWARDING_BAKED_MODEL_WRAPPED.get(fbm);
            }
            catch (ReflectiveOperationException reflectiveException) {
                throw new RuntimeException("Failed to read machine model", reflectiveException);
            }
        }
        throw new RuntimeException("Couldn't find for model for machine %s, wrong model is present: %s".formatted(state, model));
    }

    public void render(T entity, float tickDelta, class_4587 matrices, class_4597 vcp, int light, int overlay) {
        class_2680 state = entity.method_11010();
        if (this.lastBlockState == null) {
            this.lastBlockState = state;
            this.model = this.getMachineModel(state);
        } else if (this.lastBlockState != state) {
            throw new IllegalStateException("Tried to use the same machine BER with two block states: " + state + " and " + this.lastBlockState);
        }
        MachineModelClientData data = ((MachineBlockEntity)entity).getModelData();
        if (data.isActive) {
            class_4588 vc = vcp.getBuffer(class_1921.method_23581());
            for (class_2350 d : class_2350.values()) {
                class_777 quad = this.getCachedQuad(data, d);
                if (quad == null) continue;
                int faceLight = class_761.method_23793((class_1920)entity.method_10997(), (class_2680)entity.method_11010(), (class_2338)entity.method_11016().method_10093(d));
                vc.method_22919(matrices.method_23760(), quad, 1.0f, 1.0f, 1.0f, faceLight, class_4608.field_21444);
                SodiumCompat.markSpriteActive(quad.method_35788());
            }
        }
    }

    public int method_33893() {
        return 256;
    }

    static {
        try {
            FORWARDING_BAKED_MODEL_WRAPPED = ForwardingBakedModel.class.getDeclaredField("wrapped");
            FORWARDING_BAKED_MODEL_WRAPPED.setAccessible(true);
        }
        catch (ReflectiveOperationException reflectiveException) {
            throw new RuntimeException("Failed to find ForwardingBakedModel field \"wrapped\"", reflectiveException);
        }
    }
}

