/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.pipes.item.SpeedUpgrade;
import aztech.modern_industrialization.blocks.OreBlock;
import aztech.modern_industrialization.definition.FluidLike;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricBlastFurnaceBlockEntity;
import aztech.modern_industrialization.machines.components.TooltipProvider;
import aztech.modern_industrialization.machines.components.UpgradeComponent;
import aztech.modern_industrialization.nuclear.NuclearAbsorbable;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import aztech.modern_industrialization.util.TextHelper;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_437;
import net.minecraft.class_5251;
import org.jetbrains.annotations.NotNull;

public class MITooltips {
    public static final PriorityQueue<TooltipAttachment> TOOLTIPS = new PriorityQueue();
    public static final class_2583 DEFAULT_STYLE = class_2583.field_24360.method_27703(class_5251.method_27717((int)0xA9A9A9)).method_10978(Boolean.valueOf(false));
    public static final class_2583 NUMBER_TEXT = class_2583.field_24360.method_27703(class_5251.method_27717((int)16768637)).method_10978(Boolean.valueOf(false));
    private static final Map<Class<?>, class_2583> DEFAULT_ARGUMENT_STYLE = new HashMap();
    public static final Parser<Object> DEFAULT_PARSER;
    public static final Parser<Number> EU_PER_TICK_PARSER;
    public static final Parser<Number> EU_PARSER;
    public static final Parser<class_3611> FLUID_PARSER;
    public static final TooltipAttachment CABLES;
    public static final TooltipAttachment COILS;
    public static final TooltipAttachment CREATIVE_FLIGHT;
    public static final TooltipAttachment LUBRICANT_BUCKET;
    public static final TooltipAttachment GUNPOWDER;
    public static final TooltipAttachment MACHINE_TOOLTIPS;
    public static final TooltipAttachment NUCLEAR;
    public static final TooltipAttachment ORES;
    public static final TooltipAttachment SPEED_UPGRADES;
    public static final TooltipAttachment UPGRADES;
    public static final Map<String, String> TOOLTIPS_ENGLISH_TRANSLATION;

    public static void attachTooltip(class_1799 stack, List<class_2561> lines) {
        class_1792 item = stack.method_7909();
        if (item != null) {
            boolean hasPrintRequiredShift = false;
            for (TooltipAttachment tooltip : TOOLTIPS) {
                if (!tooltip.addTooltip.test(item)) continue;
                if (!tooltip.requiresShift || class_437.method_25442()) {
                    lines.addAll((Collection<class_2561>)tooltip.tooltipLines.apply(stack));
                    continue;
                }
                if (!tooltip.requiresShift || hasPrintRequiredShift) continue;
                lines.add((class_2561)MIText.TooltipsShiftRequired.text().method_10862(DEFAULT_STYLE));
                hasPrintRequiredShift = true;
            }
        }
    }

    private static void add(Predicate<class_1935> attachTo, String translationId, String ... englishTooltipsLine) {
        int lineCount = englishTooltipsLine.length;
        Preconditions.checkArgument((lineCount > 0 ? 1 : 0) != 0);
        String[] translationKey = (String[])IntStream.range(0, lineCount).mapToObj(l -> "item_tooltip.modern_industrialization." + translationId + ".line_" + l).toArray(String[]::new);
        for (int i = 0; i < lineCount; ++i) {
            TOOLTIPS_ENGLISH_TRANSLATION.put(translationKey[i], englishTooltipsLine[i]);
        }
        TooltipAttachment.ofMultiline(attachTo::test, itemStack -> Arrays.stream(translationKey).map(s -> new class_2588(s).method_27696(DEFAULT_STYLE)).collect(Collectors.toList()));
    }

    private static void add(class_1935 itemLike, String ... englishTooltipsLine) {
        MITooltips.add((class_1935 item) -> itemLike.method_8389() == item, class_2378.field_11142.method_10221((Object)itemLike.method_8389()).method_12832(), englishTooltipsLine);
    }

    private static void add(String itemId, String ... englishTooltipsLine) {
        MITooltips.add((class_1935)class_2378.field_11142.method_10223((class_2960)new MIIdentifier(itemId)), englishTooltipsLine);
    }

    static {
        DEFAULT_ARGUMENT_STYLE.put(Integer.class, NUMBER_TEXT);
        DEFAULT_ARGUMENT_STYLE.put(Long.class, NUMBER_TEXT);
        DEFAULT_ARGUMENT_STYLE.put(Float.class, NUMBER_TEXT);
        DEFAULT_ARGUMENT_STYLE.put(Double.class, NUMBER_TEXT);
        DEFAULT_PARSER = new Parser<Object>(){

            @Override
            class_2561 parse(Object o) {
                class_2583 style = DEFAULT_STYLE;
                for (Map.Entry<Class<?>, class_2583> entry : DEFAULT_ARGUMENT_STYLE.entrySet()) {
                    if (!o.getClass().isAssignableFrom(entry.getKey())) continue;
                    style = entry.getValue();
                    break;
                }
                if (o instanceof class_3611) {
                    class_3611 f = (class_3611)o;
                    return FLUID_PARSER.parse(f);
                }
                if (o instanceof FluidLike) {
                    FluidLike f = (FluidLike)o;
                    return FLUID_PARSER.parse(f.asFluid());
                }
                return new class_2585(String.valueOf(o)).method_27696(style);
            }
        };
        EU_PER_TICK_PARSER = new Parser<Number>(){

            @Override
            class_2561 parse(Number number) {
                TextHelper.Amount amount = TextHelper.getAmountGeneric(number);
                return MIText.EuT.text(amount.digit(), amount.unit()).method_27696(NUMBER_TEXT);
            }
        };
        EU_PARSER = new Parser<Number>(){

            @Override
            class_2561 parse(Number number) {
                TextHelper.Amount amount = TextHelper.getAmountGeneric(number);
                return MIText.Eu.text(amount.digit(), amount.unit()).method_27696(NUMBER_TEXT);
            }
        };
        FLUID_PARSER = new Parser<class_3611>(){

            @Override
            class_2561 parse(class_3611 fluid) {
                return FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid));
            }
        };
        CABLES = TooltipAttachment.of(item -> {
            PipeItem pipe;
            return item instanceof PipeItem && MIPipes.ELECTRICITY_PIPE_TIER.containsKey((Object)(pipe = (PipeItem)((Object)item)));
        }, itemStack -> {
            CableTier tier = MIPipes.ELECTRICITY_PIPE_TIER.get((Object)((PipeItem)itemStack.method_7909()));
            return new Line(MIText.EuCable).arg(tier.englishName).arg(tier.getMaxTransfer(), EU_PER_TICK_PARSER).build();
        });
        COILS = TooltipAttachment.of(item -> {
            class_1747 blockItem;
            return item instanceof class_1747 && ElectricBlastFurnaceBlockEntity.coilsMaxBaseEU.containsKey((blockItem = (class_1747)item).method_7711());
        }, itemStack -> {
            long eu = ElectricBlastFurnaceBlockEntity.coilsMaxBaseEU.get(((class_1747)itemStack.method_7909()).method_7711());
            return new Line(MIText.EbfMaxEu).arg(eu).build();
        });
        CREATIVE_FLIGHT = TooltipAttachment.of(item -> item == MIItem.QUANTUM_CHESTPLATE.method_8389() || item == MIItem.GRAVICHESTPLATE.method_8389(), itemStack -> new Line(MIText.AllowCreativeFligth).build()).noShiftRequired();
        LUBRICANT_BUCKET = TooltipAttachment.of((class_1935)MIFluids.LUBRICANT.getBucket(), new Line(MIText.LubricantTooltip).arg(25));
        GUNPOWDER = TooltipAttachment.of((class_1935)class_1802.field_8054, MIText.GunpowderUpgrade);
        MACHINE_TOOLTIPS = TooltipAttachment.ofMultiline(item -> {
            if (!(item instanceof class_1747)) return false;
            class_1747 blockItem = (class_1747)item;
            class_2248 patt7434$temp = blockItem.method_7711();
            if (!(patt7434$temp instanceof MachineBlock)) return false;
            MachineBlock machineBlock = (MachineBlock)patt7434$temp;
            if (!(machineBlock.BLOCK_ENTITY_INSTANCE instanceof TooltipProvider)) return false;
            return true;
        }, itemStack -> ((TooltipProvider)((Object)((MachineBlock)((class_1747)itemStack.method_7909()).method_7711()).BLOCK_ENTITY_INSTANCE)).getTooltips());
        NUCLEAR = TooltipAttachment.ofMultiline(item -> item.method_8389() instanceof NuclearAbsorbable, itemStack -> {
            LinkedList<class_2561> tooltips = new LinkedList<class_2561>();
            long remAbs = ((NuclearAbsorbable)itemStack.method_7909()).getRemainingDesintegrations((class_1799)itemStack);
            tooltips.add(new Line(MIText.RemAbsorption).arg(remAbs).arg(((NuclearAbsorbable)itemStack.method_7909()).desintegrationMax).build());
            class_1792 patt8279$temp = itemStack.method_7909();
            if (patt8279$temp instanceof NuclearFuel) {
                NuclearFuel fuel = (NuclearFuel)patt8279$temp;
                long totalEu = (long)fuel.totalEUbyDesintegration * (long)fuel.desintegrationMax;
                tooltips.add(new Line(MIText.BaseEuTotalStored).arg(totalEu, EU_PARSER).build());
            }
            return tooltips;
        });
        ORES = TooltipAttachment.ofMultiline(item -> {
            class_1747 blockItem;
            return item instanceof class_1747 && (blockItem = (class_1747)item).method_7711() instanceof OreBlock;
        }, itemStack -> {
            OreBlock oreBlock = (OreBlock)((class_1747)itemStack.method_7909()).method_7711();
            LinkedList<class_2561> lines = new LinkedList<class_2561>();
            MIConfig config = MIConfig.getConfig();
            if (config.generateOres && !config.blacklistedOres.contains(oreBlock.materialName) && oreBlock.params.generate) {
                lines.add(new Line(MIText.OreGenerationTooltipY).arg(-64).arg(oreBlock.params.maxYLevel).build());
                lines.add(new Line(MIText.OreGenerationTooltipVeinFrequency).arg(oreBlock.params.veinsPerChunk).build());
                lines.add(new Line(MIText.OreGenerationTooltipVeinSize).arg(oreBlock.params.veinSize).build());
            } else {
                lines.add(new Line(MIText.OreNotGenerated).build());
            }
            return lines;
        });
        SPEED_UPGRADES = TooltipAttachment.of(SpeedUpgrade.UPGRADES::containsKey, itemStack -> new Line(MIText.TooltipSpeedUpgrade).arg(SpeedUpgrade.UPGRADES.get(itemStack.method_7909())).build());
        UPGRADES = TooltipAttachment.of(UpgradeComponent.UPGRADES::containsKey, itemStack -> new Line(MIText.MachineUpgrade).arg((Number)UpgradeComponent.UPGRADES.get(itemStack.method_7909()), EU_PER_TICK_PARSER).build());
        TOOLTIPS_ENGLISH_TRANSLATION = new HashMap<String, String>();
        MITooltips.add(MIBlock.FORGE_HAMMER, "Use it to increase the yield of your ore blocks early game!", "(Use the Steam Mining Drill for an easy to get Silk Touch.)");
        MITooltips.add("kanthal_coil", "Right-click the EBF with a Screwdriver", "to change the coils to Kanthal");
        MITooltips.add("stainless_steel_dust", "Use Slot-Locking with REI to differentiate its recipe from the invar dust");
        MITooltips.add("steam_blast_furnace", "Needs at least one Steel or higher tier", "hatch for 3 and 4 EU/t recipes");
        MITooltips.add(MIBlock.TRASH_CAN, "Will delete any item or fluid sent into it.", "Can also be used to empty a fluid slot", "by Right-Clicking on it with a Trash Can");
        MITooltips.add((class_1935 itemLike) -> {
            PipeItem pipe;
            class_1792 patt12338$temp = itemLike.method_8389();
            return patt12338$temp instanceof PipeItem && ((pipe = (PipeItem)patt12338$temp).isItemPipe() || pipe.isFluidPipe());
        }, "pipe", "Can be instantly retrieved by", "Right-Clicking with any Wrench.", "Use Shift + Right-Click to connect ", "directly the pipe to the target block.");
        MITooltips.add((class_1935 itemLike) -> {
            PipeItem pipe;
            class_1792 patt12690$temp = itemLike.method_8389();
            return patt12690$temp instanceof PipeItem && (pipe = (PipeItem)patt12690$temp).isCable();
        }, "cable", " ", "Can power blocks from any mod, but can", "only extract energy from Modern", "Industrialization blocks and machines.", "They also are the only cables able", "to power Modern Industrialization machines.");
    }

    public static class TooltipAttachment
    implements Comparable<TooltipAttachment> {
        public final Predicate<class_1792> addTooltip;
        public final Function<class_1799, List<class_2561>> tooltipLines;
        public boolean requiresShift = true;
        public int priority = 0;

        public static TooltipAttachment ofMultiline(Predicate<class_1792> addTooltip, Function<class_1799, List<class_2561>> tooltipLines) {
            return new TooltipAttachment(addTooltip, tooltipLines);
        }

        public static TooltipAttachment ofMultiline(class_1935 itemLike, Function<class_1799, List<class_2561>> tooltips) {
            return new TooltipAttachment(item -> item == itemLike.method_8389(), tooltips);
        }

        public static TooltipAttachment of(Predicate<class_1792> addTooltip, Function<class_1799, class_2561> tooltips) {
            return TooltipAttachment.ofMultiline(addTooltip, (class_1799 item) -> List.of((class_2561)tooltips.apply((class_1799)item)));
        }

        public static TooltipAttachment of(class_1935 itemLike, Function<class_1799, class_2561> tooltips) {
            return TooltipAttachment.ofMultiline(itemLike, (class_1799 item) -> List.of((class_2561)tooltips.apply((class_1799)item)));
        }

        public static TooltipAttachment of(class_1935 itemLike, MIText text) {
            return TooltipAttachment.of(itemLike, new Line(text));
        }

        public static TooltipAttachment of(class_1935 itemLike, Line line) {
            return TooltipAttachment.of(itemLike, (class_1799 item) -> line.build());
        }

        private TooltipAttachment(Predicate<class_1792> addTooltip, Function<class_1799, List<class_2561>> tooltipLines) {
            this.addTooltip = addTooltip;
            this.tooltipLines = tooltipLines;
            TOOLTIPS.add(this);
        }

        public TooltipAttachment noShiftRequired() {
            this.requiresShift = false;
            return this;
        }

        public TooltipAttachment setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public int compareTo(@NotNull TooltipAttachment o) {
            return -Integer.compare(this.priority, o.priority);
        }
    }

    public static class Line {
        public final MIText baseText;
        public final class_2583 baseStyle;
        public final List<class_2561> args = new LinkedList<class_2561>();

        public Line(MIText baseText, class_2583 style) {
            this.baseText = baseText;
            this.baseStyle = style;
        }

        public Line(MIText baseText) {
            this(baseText, DEFAULT_STYLE);
        }

        public <T> Line arg(T arg, Parser<T> parser) {
            this.args.add(parser.parse(arg));
            return this;
        }

        public Line arg(Object arg) {
            this.arg(arg, DEFAULT_PARSER);
            return this;
        }

        public class_2561 build() {
            return this.baseText.text(this.args.toArray()).method_27696(this.baseStyle);
        }
    }

    static abstract class Parser<T> {
        Parser() {
        }

        abstract class_2561 parse(T var1);
    }
}

