/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3532;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientRegion;
import team.creative.ambientsounds.AmbientSelection;
import team.creative.ambientsounds.AmbientSoundProperties;
import team.creative.ambientsounds.env.AmbientEnviroment;
import team.creative.ambientsounds.env.BiomeEnviroment;

public class AmbientCondition
extends AmbientSoundProperties {
    public Boolean always;
    public double volume = 1.0;
    @SerializedName(value="night")
    public double nightVolume = 1.0;
    @SerializedName(value="day")
    public double dayVolume = 1.0;
    public String[] biomes;
    @SerializedName(value="bad-biomes")
    public String[] badBiomes;
    public Boolean raining;
    @SerializedName(value="overall-raining")
    public Boolean overallRaining;
    public Boolean snowing;
    public Boolean storming;
    public AmbientMinMaxFadeCondition underwater;
    @SerializedName(value="relative-height")
    public AmbientMinMaxFadeCondition relativeHeight;
    @SerializedName(value="absolute-height")
    public AmbientMinMaxFadeCondition absoluteHeight;
    @SerializedName(value="min-height-relative")
    public AmbientMinMaxFadeCondition minHeightRelative;
    @SerializedName(value="max-height-relative")
    public AmbientMinMaxFadeCondition maxHeightRelative;
    public AmbientMinMaxFadeCondition light;
    @SerializedName(value="sky-light")
    public AmbientMinMaxFadeCondition skyLight;
    public AmbientMinMaxFadeCondition air;
    public AmbientMinMaxFadeCondition temperature;
    public String[] features;
    @SerializedName(value="bad-features")
    public String[] badFeatures;
    public AmbientCondition[] variants;
    public String[] regions;
    transient List<AmbientRegion> regionList;
    @SerializedName(value="bad-regions")
    public String[] badRegions;
    transient List<AmbientRegion> badRegionList;

    public String regionName() {
        return null;
    }

    @Override
    public void init(AmbientEngine engine) {
        AmbientRegion region;
        super.init(engine);
        this.volume = class_3532.method_15350((double)this.volume, (double)0.0, (double)1.0);
        this.nightVolume = class_3532.method_15350((double)this.nightVolume, (double)0.0, (double)1.0);
        this.dayVolume = class_3532.method_15350((double)this.dayVolume, (double)0.0, (double)1.0);
        if (this.variants != null) {
            for (int i = 0; i < this.variants.length; ++i) {
                this.variants[i].init(engine);
            }
        }
        if (this.regions != null) {
            this.regionList = new ArrayList<AmbientRegion>();
            for (String regionName : this.regions) {
                region = engine.getRegion(regionName);
                if (region == null || regionName.equals(this.regionName())) continue;
                this.regionList.add(region);
            }
        }
        if (this.badRegions != null) {
            this.badRegionList = new ArrayList<AmbientRegion>();
            for (String regionName : this.badRegions) {
                region = engine.getRegion(regionName);
                if (region == null || regionName.equals(this.regionName())) continue;
                this.badRegionList.add(region);
            }
        }
    }

    public AmbientSelection value(AmbientEnviroment env) {
        Object highest;
        if (env.muted) {
            return null;
        }
        if (this.always != null) {
            return this.always != false ? new AmbientSelection(this) : null;
        }
        if (this.volume <= 0.0) {
            return null;
        }
        if (env.night ? this.nightVolume <= 0.0 : this.dayVolume <= 0.0) {
            return null;
        }
        if (this.raining != null && this.raining != env.raining) {
            return null;
        }
        if (this.overallRaining != null && this.overallRaining != env.overallRaining) {
            return null;
        }
        if (this.snowing != null && this.snowing != env.snowing) {
            return null;
        }
        if (this.storming != null && env.thundering != this.storming) {
            return null;
        }
        AmbientSelection selection = new AmbientSelection(this);
        selection.volume = selection.volume * (env.night ? this.nightVolume : this.dayVolume);
        if (this.badRegionList != null) {
            for (AmbientRegion region : this.badRegionList) {
                if (!region.isActive()) continue;
                return null;
            }
        }
        if (this.regionList != null) {
            highest = null;
            for (AmbientRegion ambientRegion : this.regionList) {
                AmbientSelection subSelection = ambientRegion.value(env);
                if (subSelection == null) continue;
                if (highest == null) {
                    highest = subSelection.volume;
                    continue;
                }
                highest = Math.max(subSelection.volume, (Double)highest);
            }
            if (highest == null) {
                return null;
            }
            selection.volume *= ((Double)highest).doubleValue();
        }
        if (this.biomes != null || this.badBiomes != null) {
            highest = null;
            for (Map.Entry entry : env.biome.biomes.entrySet()) {
                if (this.biomes != null && !((BiomeEnviroment.BiomeArea)entry.getKey()).checkBiome(this.biomes)) continue;
                if (this.badBiomes != null && ((BiomeEnviroment.BiomeArea)entry.getKey()).checkBiome(this.badBiomes)) {
                    return null;
                }
                if (highest != null && !(((Float)highest.getValue()).floatValue() < ((Float)entry.getValue()).floatValue())) continue;
                highest = entry;
            }
            if (highest == null && this.biomes != null) {
                return null;
            }
            if (highest != null) {
                selection.volume *= (double)((Float)highest.getValue()).floatValue();
            }
        }
        if (this.underwater != null) {
            double volume = this.underwater.volume(env.underwater);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.relativeHeight != null) {
            double volume = this.relativeHeight.volume(env.relativeHeight);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.minHeightRelative != null) {
            double volume = this.minHeightRelative.volume(env.relativeMinHeight);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.maxHeightRelative != null) {
            double volume = this.maxHeightRelative.volume(env.relativeMaxHeight);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.absoluteHeight != null) {
            double volume = this.absoluteHeight.volume(env.absoluteHeight);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.light != null) {
            double volume = this.light.volume(env.terrain.airPocket.averageLight);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.skyLight != null) {
            double volume = this.skyLight.volume(env.terrain.airPocket.averageSkyLight);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.air != null) {
            double volume = this.air.volume(env.terrain.airPocket.air);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.badFeatures != null && env.terrain.airPocket.volume(this.badFeatures) > 0.0) {
            return null;
        }
        if (this.features != null) {
            double volume = env.terrain.airPocket.volume(this.features);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.temperature != null) {
            double volume = this.temperature.volume(env.temperature);
            if (volume <= 0.0) {
                return null;
            }
            selection.volume *= volume;
        }
        if (this.variants != null) {
            AmbientSelection bestCondition = null;
            for (Iterator<Object> iterator : this.variants) {
                AmbientSelection subSelection = ((AmbientCondition)((Object)iterator)).value(env);
                if (subSelection == null || bestCondition != null && !(bestCondition.volume < subSelection.volume)) continue;
                bestCondition = subSelection;
            }
            if (bestCondition == null) {
                return null;
            }
            selection.subSelection = bestCondition;
        }
        return selection;
    }

    public static class AmbientMinMaxFadeCondition
    extends AmbientMinMaxCondition {
        public Double fade;

        public double volume(double value) {
            if (!this.is(value)) {
                return 0.0;
            }
            if (this.fade == null) {
                return 1.0;
            }
            double volume = 1.0;
            if (this.min != null) {
                volume = class_3532.method_15350((double)(Math.abs(value - this.min) / this.fade), (double)0.0, (double)1.0);
            }
            if (this.max != null) {
                volume = Math.min(volume, class_3532.method_15350((double)(Math.abs(value - this.max) / this.fade), (double)0.0, (double)1.0));
            }
            return volume;
        }
    }

    public static class AmbientMinMaxCondition {
        public Double min;
        public Double max;

        public boolean is(double value) {
            if (this.min != null && value < this.min) {
                return false;
            }
            return this.max == null || !(value > this.max);
        }

        public double randomValue() {
            if (this.max == null) {
                if (this.min == null) {
                    return 0.0;
                }
                return this.min;
            }
            if (this.min == null) {
                this.min = 0.0;
            }
            double distance = this.max - this.min;
            return Math.random() * distance + this.min;
        }
    }
}

