/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate.providers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_161;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class RegistrateAdvancementProvider
implements RegistrateProvider,
Consumer<class_161> {
    private static final Logger log = LogManager.getLogger(RegistrateAdvancementProvider.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final AbstractRegistrate<?> owner;
    private final class_2403 generator;
    @Nullable
    private class_2408 cache;
    private Set<class_2960> seenAdvancements = new HashSet<class_2960>();

    public RegistrateAdvancementProvider(AbstractRegistrate<?> owner, FabricDataGenerator generatorIn) {
        this.owner = owner;
        this.generator = generatorIn;
    }

    @Override
    public EnvType getSide() {
        return EnvType.SERVER;
    }

    public class_2588 title(String category, String name, String title) {
        return this.owner.addLang("advancements", new class_2960(category, name), "title", title);
    }

    public class_2588 desc(String category, String name, String desc) {
        return this.owner.addLang("advancements", new class_2960(category, name), "description", desc);
    }

    public void method_10319(class_2408 cache) throws IOException {
        try {
            this.cache = cache;
            this.seenAdvancements.clear();
            this.owner.genData(ProviderType.ADVANCEMENT, this);
        }
        finally {
            this.cache = null;
        }
    }

    @Override
    public void accept(@Nullable class_161 t) {
        class_2408 cache = this.cache;
        if (cache == null) {
            throw new IllegalStateException("Cannot accept advancements outside of act");
        }
        Objects.requireNonNull(t, "Cannot accept a null advancement");
        Path path = this.generator.method_10313();
        if (!this.seenAdvancements.add(t.method_688())) {
            throw new IllegalStateException("Duplicate advancement " + t.method_688());
        }
        Path path1 = RegistrateAdvancementProvider.getPath(path, t);
        try {
            class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)t.method_689().method_698(), (Path)path1);
        }
        catch (IOException ioexception) {
            log.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
        }
    }

    private static Path getPath(Path pathIn, class_161 advancementIn) {
        return pathIn.resolve("data/" + advancementIn.method_688().method_12836() + "/advancements/" + advancementIn.method_688().method_12832() + ".json");
    }

    public String method_10321() {
        return "Advancements";
    }
}

