/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.registrate;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.EnchantmentBuilder;
import com.tterrag.registrate.builders.EntityBuilder;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.builders.MenuBuilder;
import com.tterrag.registrate.builders.NoConfigBuilder;
import com.tterrag.registrate.fabric.GatherDataEvent;
import com.tterrag.registrate.fabric.RegistryObject;
import com.tterrag.registrate.fabric.RegistryUtil;
import com.tterrag.registrate.fabric.SimpleFlowableFluid;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateDataProvider;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.DebugMarkers;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_437;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRegistrate<S extends AbstractRegistrate<S>> {
    private static final Logger log = LogManager.getLogger(AbstractRegistrate.class);
    private final Table<String, class_5321<? extends class_2378<?>>, Registration<?, ?>> registrations = HashBasedTable.create();
    private final Multimap<Pair<String, class_5321<? extends class_2378<?>>>, NonNullConsumer<?>> registerCallbacks = HashMultimap.create();
    private final Multimap<class_5321<? extends class_2378<?>>, Runnable> afterRegisterCallbacks = HashMultimap.create();
    private final Set<class_5321<class_2378<?>>> completedRegistrations = new HashSet();
    private final Table<Pair<String, class_5321<? extends class_2378<?>>>, ProviderType<?>, Consumer<? extends RegistrateProvider>> datagensByEntry = HashBasedTable.create();
    private final ListMultimap<ProviderType<?>, @NonnullType NonNullConsumer<? extends RegistrateProvider>> datagens = ArrayListMultimap.create();
    private final NonNullSupplier<Boolean> doDatagen = NonNullSupplier.lazy(() -> FabricDataGenHelper.ENABLED);
    private final String modid;
    @Nullable
    private String currentName;
    private @Nullable Supplier<? extends @NonnullType class_1761> currentTab;
    private boolean skipErrors;
    @Nullable
    private RegistrateDataProvider provider;
    private final NonNullSupplier<List<Pair<String, String>>> extraLang = NonNullSupplier.lazy(() -> {
        ArrayList ret = new ArrayList();
        this.addDataGenerator(ProviderType.LANG, prov -> ret.forEach(p -> prov.add((String)p.getKey(), (String)p.getValue())));
        return ret;
    });

    public static boolean isDevEnvironment() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    protected AbstractRegistrate(String modid) {
        this.modid = modid;
        GatherDataEvent.EVENT.register(this::onInitializeDataGenerator);
    }

    protected S self() {
        return (S)this;
    }

    @Deprecated
    public <R> class_5321<class_2378<R>> getRegistryKeyByClass(Class<? super R> cls) {
        return RegistryUtil.getRegistry(cls).method_30517();
    }

    public void register() {
        RegistryUtil.forAllRegistries(registry -> {
            this.onRegister((class_2378<?>)registry);
            this.onRegisterLate((class_2378<?>)registry);
        });
    }

    protected void onRegister(class_2378<?> registry) {
        Map registrationsForType;
        class_5321 type = registry.method_30517();
        class_2960 registryId = type.method_29177();
        if (!this.registerCallbacks.isEmpty()) {
            this.registerCallbacks.asMap().forEach((k, v) -> log.warn("Found {} unused register callback(s) for entry {} [{}]. Was the entry ever registered?", (Object)v.size(), k.getLeft(), (Object)((class_5321)k.getRight()).method_29177()));
            this.registerCallbacks.clear();
            if (AbstractRegistrate.isDevEnvironment()) {
                throw new IllegalStateException("Found unused register callbacks, see logs");
            }
        }
        if ((registrationsForType = this.registrations.column((Object)type)).size() > 0) {
            log.debug(DebugMarkers.REGISTER, "Registering {} known objects of type {}", (Object)registrationsForType.size(), (Object)type.method_29177());
            for (Map.Entry e : registrationsForType.entrySet()) {
                try {
                    ((Registration)e.getValue()).register(registry);
                    log.debug(DebugMarkers.REGISTER, "Registered {} to registry {}", (Object)((Registration)e.getValue()).getName(), (Object)registryId);
                }
                catch (Exception ex) {
                    String err = "Unexpected error while registering entry " + ((Registration)e.getValue()).getName() + " to registry " + registryId;
                    if (this.skipErrors) {
                        log.error(DebugMarkers.REGISTER, err);
                        continue;
                    }
                    throw new RuntimeException(err, ex);
                }
            }
        }
    }

    protected void onRegisterLate(class_2378<?> event) {
        class_5321 type = event.method_30517();
        Collection callbacks = this.afterRegisterCallbacks.get((Object)type);
        callbacks.forEach(Runnable::run);
        callbacks.clear();
        this.completedRegistrations.add(type);
    }

    public void onInitializeDataGenerator(FabricDataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.provider = new RegistrateDataProvider(this, this.modid, generator, existingFileHelper);
        generator.method_10314((class_2405)this.provider);
    }

    protected String currentName() {
        String name = this.currentName;
        Objects.requireNonNull(name, "Current name not set");
        return name;
    }

    @Deprecated
    public <R, T extends R> RegistryEntry<T> get(Class<? super R> type) {
        return this.get(this.currentName(), type);
    }

    public <R, T extends R> RegistryEntry<T> get(class_5321<? extends class_2378<R>> type) {
        return this.get(this.currentName(), type);
    }

    @Deprecated
    public <R, T extends R> RegistryEntry<T> get(String name, Class<? super R> type) {
        return this.getRegistration(name, this.getRegistryKeyByClass(type)).getDelegate();
    }

    public <R, T extends R> RegistryEntry<T> get(String name, class_5321<? extends class_2378<R>> type) {
        return this.getRegistration(name, type).getDelegate();
    }

    @Deprecated
    @Beta
    public <R, T extends R> RegistryEntry<T> getOptional(String name, Class<? super R> type) {
        return this.getOptional(name, this.getRegistryKeyByClass(type));
    }

    @Beta
    public <R, T extends R> RegistryEntry<T> getOptional(String name, class_5321<? extends class_2378<R>> type) {
        Registration<R, T> reg = this.getRegistrationUnchecked(name, type);
        return reg == null ? RegistryEntry.empty() : reg.getDelegate();
    }

    @Nullable
    private <R, T extends R> Registration<R, T> getRegistrationUnchecked(String name, class_5321<? extends class_2378<R>> type) {
        return (Registration)this.registrations.get((Object)name, type);
    }

    private <R, T extends R> Registration<R, T> getRegistration(String name, class_5321<? extends class_2378<R>> type) {
        Registration<R, T> reg = this.getRegistrationUnchecked(name, type);
        if (reg != null) {
            return reg;
        }
        throw new IllegalArgumentException("Unknown registration " + name + " for type " + type);
    }

    @Deprecated
    public <R> Collection<RegistryEntry<R>> getAll(Class<? super R> type) {
        return this.getAll(this.getRegistryKeyByClass(type));
    }

    public <R> Collection<RegistryEntry<R>> getAll(class_5321<? extends class_2378<R>> type) {
        return this.registrations.column(type).values().stream().map(r -> r.getDelegate()).collect(Collectors.toList());
    }

    @Deprecated
    public <R, T extends R> S addRegisterCallback(String name, Class<? super R> registryType, NonNullConsumer<? super T> callback) {
        return this.addRegisterCallback(name, this.getRegistryKeyByClass(registryType), callback);
    }

    public <R, T extends R> S addRegisterCallback(String name, class_5321<? extends class_2378<R>> registryType, NonNullConsumer<? super T> callback) {
        Registration<R, ? super T> reg = this.getRegistrationUnchecked(name, registryType);
        if (reg == null) {
            this.registerCallbacks.put((Object)Pair.of((Object)name, registryType), callback);
        } else {
            reg.addRegisterCallback(callback);
        }
        return this.self();
    }

    @Deprecated
    public <R> S addRegisterCallback(Class<? super R> registryType, Runnable callback) {
        return this.addRegisterCallback(this.getRegistryKeyByClass(registryType), callback);
    }

    public <R> S addRegisterCallback(class_5321<? extends class_2378<R>> registryType, Runnable callback) {
        this.afterRegisterCallbacks.put(registryType, (Object)callback);
        return this.self();
    }

    @Deprecated
    public <R> boolean isRegistered(Class<? super R> registryType) {
        return this.isRegistered(this.getRegistryKeyByClass(registryType));
    }

    public <R> boolean isRegistered(class_5321<? extends class_2378<R>> registryType) {
        return this.completedRegistrations.contains(registryType);
    }

    public <P extends RegistrateProvider> Optional<P> getDataProvider(ProviderType<P> type) {
        RegistrateDataProvider provider = this.provider;
        if (provider != null) {
            return provider.getSubProvider(type);
        }
        throw new IllegalStateException("Cannot get data provider before datagen is started");
    }

    public <P extends RegistrateProvider, R> S setDataGenerator(Builder<R, ?, ?, ?> builder, ProviderType<P> type, NonNullConsumer<? extends P> cons) {
        return this.setDataGenerator(builder.getName(), builder.getRegistryKey(), type, cons);
    }

    @Deprecated
    public <P extends RegistrateProvider, R> S setDataGenerator(String entry, Class<? super R> registryType, ProviderType<P> type, NonNullConsumer<? extends P> cons) {
        return this.setDataGenerator(entry, this.getRegistryKeyByClass(registryType), type, cons);
    }

    public <P extends RegistrateProvider, R> S setDataGenerator(String entry, class_5321<? extends class_2378<R>> registryType, ProviderType<P> type, NonNullConsumer<? extends P> cons) {
        if (!((Boolean)this.doDatagen.get()).booleanValue()) {
            return this.self();
        }
        Consumer existing = (Consumer)this.datagensByEntry.put((Object)Pair.of((Object)entry, registryType), type, cons);
        if (existing != null) {
            this.datagens.remove(type, (Object)existing);
        }
        return this.addDataGenerator(type, cons);
    }

    public <T extends RegistrateProvider> S addDataGenerator(ProviderType<? extends T> type, NonNullConsumer<? extends T> cons) {
        if (((Boolean)this.doDatagen.get()).booleanValue()) {
            this.datagens.put(type, cons);
        }
        return this.self();
    }

    @Deprecated
    public class_2588 addLang(String key, String value) {
        String prefixedKey = this.getModid() + "." + key;
        this.addDataGenerator(ProviderType.LANG, p -> p.add(prefixedKey, value));
        return new class_2588(prefixedKey);
    }

    public class_2588 addLang(String type, class_2960 id, String localizedName) {
        return this.addRawLang(class_156.method_646((String)type, (class_2960)id), localizedName);
    }

    public class_2588 addLang(String type, class_2960 id, String suffix, String localizedName) {
        return this.addRawLang(class_156.method_646((String)type, (class_2960)id) + "." + suffix, localizedName);
    }

    public class_2588 addRawLang(String key, String value) {
        if (((Boolean)this.doDatagen.get()).booleanValue()) {
            ((List)this.extraLang.get()).add(Pair.of((Object)key, (Object)value));
        }
        return new class_2588(key);
    }

    private Optional<Pair<String, class_5321<? extends class_2378<?>>>> getEntryForGenerator(ProviderType<?> type, NonNullConsumer<? extends RegistrateProvider> generator) {
        for (Map.Entry e : this.datagensByEntry.column(type).entrySet()) {
            if (e.getValue() != generator) continue;
            return Optional.of((Pair)e.getKey());
        }
        return Optional.empty();
    }

    public <T extends RegistrateProvider> void genData(ProviderType<? extends T> type, T gen) {
        if (!((Boolean)this.doDatagen.get()).booleanValue()) {
            return;
        }
        this.datagens.get(type).forEach(cons -> {
            Optional<Pair<String, class_5321<class_2378<?>>>> entry = null;
            if (log.isEnabled(Level.DEBUG, DebugMarkers.DATA)) {
                entry = this.getEntryForGenerator(type, (NonNullConsumer<? extends RegistrateProvider>)cons);
                if (entry.isPresent()) {
                    log.debug(DebugMarkers.DATA, "Generating data of type {} for entry {} [{}]", (Object)RegistrateDataProvider.getTypeName(type), entry.get().getLeft(), (Object)((class_5321)entry.get().getRight()).method_29177());
                } else {
                    log.debug(DebugMarkers.DATA, "Generating unassociated data of type {} ({})", (Object)RegistrateDataProvider.getTypeName(type), (Object)type);
                }
            }
            try {
                cons.accept(gen);
            }
            catch (Exception e) {
                if (entry == null) {
                    entry = this.getEntryForGenerator(type, (NonNullConsumer<? extends RegistrateProvider>)cons);
                }
                Message err = entry.isPresent() ? log.getMessageFactory().newMessage("Unexpected error while running data generator of type {} for entry {} [{}]", new Object[]{RegistrateDataProvider.getTypeName(type), entry.get().getLeft(), ((class_5321)entry.get().getRight()).method_29177()}) : log.getMessageFactory().newMessage("Unexpected error while running unassociated data generator of type {} ({})", new Object[]{RegistrateDataProvider.getTypeName(type), type});
                if (this.skipErrors) {
                    log.error(err);
                }
                throw new RuntimeException(err.getFormattedMessage(), e);
            }
        });
    }

    public S skipErrors(boolean skipErrors) {
        if (skipErrors && !AbstractRegistrate.isDevEnvironment()) {
            log.error("Ignoring skipErrors(true) as this is not a development environment!");
        } else {
            this.skipErrors = skipErrors;
        }
        return this.self();
    }

    public S object(String name) {
        this.currentName = name;
        return this.self();
    }

    public S creativeModeTab(NonNullSupplier<? extends class_1761> tab) {
        this.currentTab = Suppliers.memoize(tab::get);
        return this.self();
    }

    public S creativeModeTab(NonNullSupplier<? extends class_1761> tab, String localizedName) {
        this.addDataGenerator(ProviderType.LANG, prov -> prov.add((class_1761)tab.get(), localizedName));
        return this.creativeModeTab(tab);
    }

    public S transform(NonNullUnaryOperator<S> func) {
        return (S)((AbstractRegistrate)func.apply(this.self()));
    }

    public <R, T extends R, P, S2 extends Builder<R, T, P, S2>> S2 transform(NonNullFunction<S, S2> func) {
        return (S2)((Builder)func.apply(this.self()));
    }

    public <R, T extends R, P, S2 extends Builder<R, T, P, S2>> S2 entry(NonNullBiFunction<String, BuilderCallback, S2> factory) {
        return (S2)this.entry(this.currentName(), callback -> (Builder)factory.apply(this.currentName(), (BuilderCallback)callback));
    }

    public <R, T extends R, P, S2 extends Builder<R, T, P, S2>> S2 entry(String name, NonNullFunction<BuilderCallback.NewBuilderCallback, S2> factory) {
        return (S2)((Builder)factory.apply(this::accept));
    }

    @Deprecated
    protected <R, T extends R> RegistryEntry<T> accept(String name, Class<? super R> type, Builder<R, T, ?, ?> builder, NonNullSupplier<? extends T> creator, NonNullFunction<RegistryObject<T>, ? extends RegistryEntry<T>> entryFactory) {
        return this.accept(name, this.getRegistryKeyByClass(type), builder, creator, entryFactory);
    }

    protected <R, T extends R> RegistryEntry<T> accept(String name, class_5321<? extends class_2378<R>> type, Builder<R, T, ?, ?> builder, NonNullSupplier<? extends T> creator, NonNullFunction<RegistryObject<T>, ? extends RegistryEntry<T>> entryFactory) {
        Registration reg = new Registration(new class_2960(this.modid, name), type, creator, entryFactory);
        log.debug(DebugMarkers.REGISTER, "Captured registration for entry {} of type {}", (Object)name, (Object)type.method_29177());
        this.registerCallbacks.removeAll((Object)Pair.of((Object)name, type)).forEach(callback -> {
            NonNullConsumer unsafeCallback = callback;
            reg.addRegisterCallback(unsafeCallback);
        });
        this.registrations.put((Object)name, type, reg);
        return reg.getDelegate();
    }

    public <R, T extends R> RegistryEntry<T> simple(class_5321<? extends class_2378<R>> registryType, NonNullSupplier<T> factory) {
        return this.simple((Object)this.currentName(), registryType, factory);
    }

    public <R, T extends R> RegistryEntry<T> simple(String name, class_5321<? extends class_2378<R>> registryType, NonNullSupplier<T> factory) {
        return this.simple(this, name, registryType, factory);
    }

    public <R, T extends R, P> RegistryEntry<T> simple(P parent, class_5321<? extends class_2378<R>> registryType, NonNullSupplier<T> factory) {
        return this.simple(parent, this.currentName(), registryType, factory);
    }

    public <R, T extends R, P> RegistryEntry<T> simple(P parent, String name, class_5321<? extends class_2378<R>> registryType, NonNullSupplier<T> factory) {
        return this.entry(name, callback -> new NoConfigBuilder(this, parent, name, (BuilderCallback)callback, registryType, factory)).register();
    }

    @Deprecated
    public <R, T extends R> RegistryEntry<T> simple(Class<? super R> registryType, NonNullSupplier<T> factory) {
        return this.simple((Object)this.currentName(), registryType, factory);
    }

    @Deprecated
    public <R, T extends R> RegistryEntry<T> simple(String name, Class<? super R> registryType, NonNullSupplier<T> factory) {
        return this.simple(this, name, registryType, factory);
    }

    @Deprecated
    public <R, T extends R, P> RegistryEntry<T> simple(P parent, Class<? super R> registryType, NonNullSupplier<T> factory) {
        return this.simple(parent, this.currentName(), registryType, factory);
    }

    @Deprecated
    public <R, T extends R, P> RegistryEntry<T> simple(P parent, String name, Class<? super R> registryType, NonNullSupplier<T> factory) {
        return this.entry(name, callback -> new NoConfigBuilder(this, parent, name, (BuilderCallback)callback, registryType, factory)).register();
    }

    public <T extends class_1792> ItemBuilder<T, S> item(NonNullFunction<class_1792.class_1793, T> factory) {
        return this.item(this.self(), factory);
    }

    public <T extends class_1792> ItemBuilder<T, S> item(String name, NonNullFunction<class_1792.class_1793, T> factory) {
        return this.item(this.self(), name, factory);
    }

    public <T extends class_1792, P> ItemBuilder<T, P> item(P parent, NonNullFunction<class_1792.class_1793, T> factory) {
        return this.item(parent, this.currentName(), factory);
    }

    public <T extends class_1792, P> ItemBuilder<T, P> item(P parent, String name, NonNullFunction<class_1792.class_1793, T> factory) {
        Supplier<? extends @NonnullType class_1761> currentTab = this.currentTab;
        return this.entry(name, callback -> ItemBuilder.create(this, parent, name, callback, factory, currentTab == null ? null : ((Supplier)currentTab)::get));
    }

    public <T extends class_2248> BlockBuilder<T, S> block(NonNullFunction<class_4970.class_2251, T> factory) {
        return this.block(this.self(), factory);
    }

    public <T extends class_2248> BlockBuilder<T, S> block(String name, NonNullFunction<class_4970.class_2251, T> factory) {
        return this.block(this.self(), name, factory);
    }

    public <T extends class_2248, P> BlockBuilder<T, P> block(P parent, NonNullFunction<class_4970.class_2251, T> factory) {
        return this.block(parent, this.currentName(), factory);
    }

    public <T extends class_2248, P> BlockBuilder<T, P> block(P parent, String name, NonNullFunction<class_4970.class_2251, T> factory) {
        return this.block(parent, name, class_3614.field_15914, factory);
    }

    public <T extends class_2248> BlockBuilder<T, S> block(class_3614 material, NonNullFunction<class_4970.class_2251, T> factory) {
        return this.block(this.self(), material, factory);
    }

    public <T extends class_2248> BlockBuilder<T, S> block(String name, class_3614 material, NonNullFunction<class_4970.class_2251, T> factory) {
        return this.block(this.self(), name, material, factory);
    }

    public <T extends class_2248, P> BlockBuilder<T, P> block(P parent, class_3614 material, NonNullFunction<class_4970.class_2251, T> factory) {
        return this.block(parent, this.currentName(), material, factory);
    }

    public <T extends class_2248, P> BlockBuilder<T, P> block(P parent, String name, class_3614 material, NonNullFunction<class_4970.class_2251, T> factory) {
        return this.entry(name, callback -> BlockBuilder.create(this, parent, name, callback, factory, material));
    }

    public <T extends class_1297> EntityBuilder<T, S> entity(class_1299.class_4049<T> factory, class_1311 classification) {
        return this.entity(this.self(), factory, classification);
    }

    public <T extends class_1297> EntityBuilder<T, S> entity(String name, class_1299.class_4049<T> factory, class_1311 classification) {
        return this.entity(this.self(), name, factory, classification);
    }

    public <T extends class_1297, P> EntityBuilder<T, P> entity(P parent, class_1299.class_4049<T> factory, class_1311 classification) {
        return this.entity(parent, this.currentName(), factory, classification);
    }

    public <T extends class_1297, P> EntityBuilder<T, P> entity(P parent, String name, class_1299.class_4049<T> factory, class_1311 classification) {
        return this.entry(name, callback -> EntityBuilder.create(this, parent, name, callback, factory, classification));
    }

    public <T extends class_2586> BlockEntityBuilder<T, S> blockEntity(BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return this.blockEntity(this.self(), factory);
    }

    public <T extends class_2586> BlockEntityBuilder<T, S> blockEntity(String name, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return this.blockEntity(this.self(), name, factory);
    }

    public <T extends class_2586, P> BlockEntityBuilder<T, P> blockEntity(P parent, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return this.blockEntity(parent, this.currentName(), factory);
    }

    public <T extends class_2586, P> BlockEntityBuilder<T, P> blockEntity(P parent, String name, BlockEntityBuilder.BlockEntityFactory<T> factory) {
        return this.entry(name, callback -> BlockEntityBuilder.create(this, parent, name, callback, factory));
    }

    public FluidBuilder<SimpleFlowableFluid.Flowing, S> fluid() {
        return this.fluid(this.self());
    }

    public FluidBuilder<SimpleFlowableFluid.Flowing, S> fluid(class_2960 stillTexture, class_2960 flowingTexture) {
        return this.fluid(this.self(), stillTexture, flowingTexture);
    }

    public <T extends SimpleFlowableFluid> FluidBuilder<T, S> fluid(class_2960 stillTexture, class_2960 flowingTexture, NonNullFunction<SimpleFlowableFluid.Properties, T> factory) {
        return this.fluid(this.self(), stillTexture, flowingTexture, factory);
    }

    public FluidBuilder<SimpleFlowableFluid.Flowing, S> fluid(String name) {
        return this.fluid(this.self(), name);
    }

    public FluidBuilder<SimpleFlowableFluid.Flowing, S> fluid(String name, class_2960 stillTexture, class_2960 flowingTexture) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture);
    }

    public <T extends SimpleFlowableFluid> FluidBuilder<T, S> fluid(String name, class_2960 stillTexture, class_2960 flowingTexture, NonNullFunction<SimpleFlowableFluid.Properties, T> factory) {
        return this.fluid(this.self(), name, stillTexture, flowingTexture, factory);
    }

    public <P> FluidBuilder<SimpleFlowableFluid.Flowing, P> fluid(P parent) {
        return this.fluid(parent, this.currentName());
    }

    public <P> FluidBuilder<SimpleFlowableFluid.Flowing, P> fluid(P parent, class_2960 stillTexture, class_2960 flowingTexture) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture);
    }

    public <T extends SimpleFlowableFluid, P> FluidBuilder<T, P> fluid(P parent, class_2960 stillTexture, class_2960 flowingTexture, NonNullFunction<SimpleFlowableFluid.Properties, T> factory) {
        return this.fluid(parent, this.currentName(), stillTexture, flowingTexture, factory);
    }

    public <P> FluidBuilder<SimpleFlowableFluid.Flowing, P> fluid(P parent, String name) {
        return this.fluid(parent, name, new class_2960(this.getModid(), "block/" + this.currentName() + "_still"), new class_2960(this.getModid(), "block/" + this.currentName() + "_flow"));
    }

    public <P> FluidBuilder<SimpleFlowableFluid.Flowing, P> fluid(P parent, String name, class_2960 stillTexture, class_2960 flowingTexture) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture));
    }

    public <T extends SimpleFlowableFluid, P> FluidBuilder<T, P> fluid(P parent, String name, class_2960 stillTexture, class_2960 flowingTexture, NonNullFunction<SimpleFlowableFluid.Properties, T> factory) {
        return this.entry(name, callback -> FluidBuilder.create(this, parent, name, callback, stillTexture, flowingTexture, factory));
    }

    public <T extends class_1703, SC extends class_437> MenuBuilder<T, SC, S> menu(MenuBuilder.MenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu((Object)this.currentName(), factory, screenFactory);
    }

    public <T extends class_1703, SC extends class_437> MenuBuilder<T, SC, S> menu(String name, MenuBuilder.MenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu(this.self(), name, factory, screenFactory);
    }

    public <T extends class_1703, SC extends class_437, P> MenuBuilder<T, SC, P> menu(P parent, MenuBuilder.MenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu(parent, this.currentName(), factory, screenFactory);
    }

    public <T extends class_1703, SC extends class_437, P> MenuBuilder<T, SC, P> menu(P parent, String name, MenuBuilder.MenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.entry(name, callback -> new MenuBuilder(this, parent, name, (BuilderCallback)callback, factory, screenFactory));
    }

    public <T extends class_1703, SC extends class_437> MenuBuilder<T, SC, S> menu(MenuBuilder.ForgeMenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu((Object)this.currentName(), factory, screenFactory);
    }

    public <T extends class_1703, SC extends class_437> MenuBuilder<T, SC, S> menu(String name, MenuBuilder.ForgeMenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu(this.self(), name, factory, screenFactory);
    }

    public <T extends class_1703, SC extends class_437, P> MenuBuilder<T, SC, P> menu(P parent, MenuBuilder.ForgeMenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.menu(parent, this.currentName(), factory, screenFactory);
    }

    public <T extends class_1703, SC extends class_437, P> MenuBuilder<T, SC, P> menu(P parent, String name, MenuBuilder.ForgeMenuFactory<T> factory, NonNullSupplier<MenuBuilder.ScreenFactory<T, SC>> screenFactory) {
        return this.entry(name, callback -> new MenuBuilder(this, parent, name, (BuilderCallback)callback, factory, screenFactory));
    }

    public <T extends class_1887> EnchantmentBuilder<T, S> enchantment(class_1886 type, EnchantmentBuilder.EnchantmentFactory<T> factory) {
        return this.enchantment(this.self(), type, factory);
    }

    public <T extends class_1887> EnchantmentBuilder<T, S> enchantment(String name, class_1886 type, EnchantmentBuilder.EnchantmentFactory<T> factory) {
        return this.enchantment(this.self(), name, type, factory);
    }

    public <T extends class_1887, P> EnchantmentBuilder<T, P> enchantment(P parent, class_1886 type, EnchantmentBuilder.EnchantmentFactory<T> factory) {
        return this.enchantment(parent, this.currentName(), type, factory);
    }

    public <T extends class_1887, P> EnchantmentBuilder<T, P> enchantment(P parent, String name, class_1886 type, EnchantmentBuilder.EnchantmentFactory<T> factory) {
        return this.entry(name, callback -> EnchantmentBuilder.create(this, parent, name, callback, type, factory));
    }

    public String getModid() {
        return this.modid;
    }

    private final class Registration<R, T extends R> {
        private final class_2960 name;
        private final class_5321<? extends class_2378<R>> type;
        private final NonNullSupplier<? extends T> creator;
        private final RegistryEntry<T> delegate;
        private final List<NonNullConsumer<? super T>> callbacks = new ArrayList<NonNullConsumer<? super T>>();

        Registration(class_2960 name, class_5321<? extends class_2378<R>> type, NonNullSupplier<? extends T> creator, NonNullFunction<RegistryObject<T>, ? extends RegistryEntry<T>> entryFactory) {
            this.name = name;
            this.type = type;
            this.creator = creator.lazy();
            this.delegate = entryFactory.apply(RegistryObject.of(name, type.method_29177(), AbstractRegistrate.this.getModid()));
        }

        void register(class_2378<R> registry) {
            Object entry = this.creator.get();
            class_2378.method_10230(registry, (class_2960)this.name, entry);
            this.delegate.updateReference(registry);
            this.callbacks.forEach(c -> c.accept(entry));
            this.callbacks.clear();
        }

        void addRegisterCallback(NonNullConsumer<? super T> callback) {
            Preconditions.checkNotNull(callback, (Object)"Callback must not be null");
            this.callbacks.add(callback);
        }

        public class_2960 getName() {
            return this.name;
        }

        public class_5321<? extends class_2378<R>> getType() {
            return this.type;
        }

        public NonNullSupplier<? extends T> getCreator() {
            return this.creator;
        }

        public RegistryEntry<T> getDelegate() {
            return this.delegate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Registration)) {
                return false;
            }
            Registration other = (Registration)o;
            class_2960 this$name = this.getName();
            class_2960 other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            class_5321<class_2378<R>> this$type = this.getType();
            class_5321<class_2378<R>> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            NonNullSupplier<T> this$creator = this.getCreator();
            NonNullSupplier<T> other$creator = other.getCreator();
            if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
                return false;
            }
            RegistryEntry<T> this$delegate = this.getDelegate();
            RegistryEntry<T> other$delegate = other.getDelegate();
            if (this$delegate == null ? other$delegate != null : !((Object)this$delegate).equals(other$delegate)) {
                return false;
            }
            List<NonNullConsumer<T>> this$callbacks = this.callbacks;
            List<NonNullConsumer<? super T>> other$callbacks = other.callbacks;
            return !(this$callbacks == null ? other$callbacks != null : !((Object)this$callbacks).equals(other$callbacks));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            class_2960 $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            class_5321<class_2378<R>> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            NonNullSupplier<T> $creator = this.getCreator();
            result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
            RegistryEntry<T> $delegate = this.getDelegate();
            result = result * 59 + ($delegate == null ? 43 : ((Object)$delegate).hashCode());
            List<NonNullConsumer<T>> $callbacks = this.callbacks;
            result = result * 59 + ($callbacks == null ? 43 : ((Object)$callbacks).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractRegistrate.Registration(name=" + this.getName() + ", type=" + this.getType() + ", creator=" + this.getCreator() + ", delegate=" + this.getDelegate() + ", callbacks=" + this.callbacks + ")";
        }
    }
}

