/*
 * Decompiled with CFR 0.152.
 */
package subaraki.paintings.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.class_2960;
import subaraki.paintings.Paintings;
import subaraki.paintings.utils.PaintingEntry;

public class PaintingPackReader {
    public static final ArrayList<PaintingEntry> addedPaintings = new ArrayList();
    private static final Gson gson = new GsonBuilder().create();

    public void init() {
        Paintings.LOGGER.info("loading json file and contents for paintings.");
        this.duplicateBaseToFolder();
        this.scanPacks();
    }

    private void makeEntriesFromPath(Path jsonPaintingFile) throws IOException {
        Paintings.LOGGER.info(String.format("resolving %s ...", jsonPaintingFile.getFileName().toString()));
        if (Files.isRegularFile(jsonPaintingFile, new LinkOption[0]) && jsonPaintingFile.toString().endsWith(".json")) {
            InputStream stream = Files.newInputStream(jsonPaintingFile, new OpenOption[0]);
            this.makeEntriesFromStream(stream);
        }
    }

    private void makeEntriesFromStream(InputStream stream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
        JsonObject json = je.getAsJsonObject();
        JsonArray array = json.getAsJsonArray("paintings");
        for (int index = 0; index < array.size(); ++index) {
            JsonObject jsonObject = array.get(index).getAsJsonObject();
            String textureName = jsonObject.get("name").getAsString();
            if (!class_2960.method_20207((String)textureName)) {
                Paintings.LOGGER.error("Non [a-z0-9/._-] character in path of location: " + textureName);
                continue;
            }
            int sizeX = 0;
            int sizeY = 0;
            int animY = 0;
            if (jsonObject.has("x")) {
                sizeX = jsonObject.get("x").getAsInt();
            }
            if (jsonObject.has("y")) {
                sizeY = jsonObject.get("y").getAsInt();
            }
            if (jsonObject.has("square")) {
                sizeX = sizeY = jsonObject.get("square").getAsInt();
            }
            animY = sizeY;
            if (jsonObject.has("anim")) {
                animY = jsonObject.get("anim").getAsInt();
            }
            if (sizeX == 0 || sizeY == 0) {
                Paintings.LOGGER.error("Tried loading a painting where one of the sides was 0 ! ");
                Paintings.LOGGER.error("Painting name is : " + textureName);
                Paintings.LOGGER.error("Skipping...");
                continue;
            }
            if (sizeX % 16 != 0 || sizeY % 16 != 0) {
                Paintings.LOGGER.error("Tried loading a painting with a size that is not a multiple of 16 !! ");
                Paintings.LOGGER.error("Painting name is : " + textureName);
                Paintings.LOGGER.error("Skipping...");
                continue;
            }
            PaintingEntry entry = new PaintingEntry(textureName, sizeX, sizeY, animY);
            Paintings.LOGGER.info(String.format("Loaded json painting %s , %d x %d", entry.getRefName(), entry.getSizeX(), entry.getSizeY()));
            addedPaintings.add(entry);
        }
    }

    private void scanPacks() {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get("./resourcepacks", new String[0]));){
            Paintings.LOGGER.info("Reading out ResourcePacks to find painting related json files");
            for (Path resourcePackPath : directoryStream) {
                Paintings.LOGGER.info("Reading `{}`", (Object)resourcePackPath.getFileName().toString());
                try {
                    URI jarUri = new URI("jar:%s".formatted(resourcePackPath.toUri().getScheme()), resourcePackPath.toUri().getPath(), null);
                    try {
                        FileSystem system = this.initFileSystem(jarUri);
                        try {
                            Iterator resourcePacks = Files.walk(system.getPath("/", new String[0]), new FileVisitOption[0]).iterator();
                            while (resourcePacks.hasNext()) {
                                boolean copyOver = false;
                                Path next = (Path)resourcePacks.next();
                                if (Files.isRegularFile(next, new LinkOption[0]) && next.toString().endsWith("json")) {
                                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(next, new OpenOption[0])));){
                                        Gson gson = new GsonBuilder().create();
                                        JsonElement je = (JsonElement)gson.fromJson((Reader)reader, JsonElement.class);
                                        JsonObject json = je.getAsJsonObject();
                                        if (json.has("paintings")) {
                                            copyOver = true;
                                            Paintings.LOGGER.info("Validated: {}", (Object)next.getFileName().toString());
                                        }
                                    }
                                    catch (Exception e) {
                                        Paintings.LOGGER.warn("************************************");
                                        Paintings.LOGGER.error("`{}` Errored. Skipping.", (Object)next.getFileName().toString());
                                        Paintings.LOGGER.error(e.getMessage());
                                        Paintings.LOGGER.warn("************************************");
                                    }
                                }
                                if (!copyOver) continue;
                                try {
                                    this.makeEntriesFromPath(next);
                                }
                                catch (IOException e) {
                                    Paintings.LOGGER.warn("************************************");
                                    Paintings.LOGGER.warn(String.format("json file %s could not parse.", next.getFileName()));
                                    Paintings.LOGGER.warn("************************************");
                                    e.printStackTrace();
                                }
                            }
                        }
                        finally {
                            if (system == null) continue;
                            system.close();
                        }
                    }
                    catch (Exception e) {
                        Paintings.LOGGER.warn("************************************");
                        Paintings.LOGGER.error("Invalid ResourcePack  {}", (Object)resourcePackPath.getFileName().toString());
                        Paintings.LOGGER.error(e.getMessage());
                        Paintings.LOGGER.warn("************************************");
                    }
                }
                catch (URISyntaxException e) {
                    Paintings.LOGGER.warn("************************************");
                    Paintings.LOGGER.error("Error Detected in ResourcePack `{}` ", (Object)resourcePackPath.getFileName().toString());
                    Paintings.LOGGER.warn((Object)e);
                    Paintings.LOGGER.warn("************************************");
                }
            }
        }
        catch (IOException e) {
            Paintings.LOGGER.warn("************************************");
            Paintings.LOGGER.warn("!*!*!*!*!");
            Paintings.LOGGER.error("A fatal error occurred reading the resource pack directory");
            Paintings.LOGGER.error("SKIPPING ENTIRE PROCESS");
            Paintings.LOGGER.warn("!*!*!*!*!");
            Paintings.LOGGER.warn("************************************");
            Paintings.LOGGER.warn((Object)e);
        }
    }

    private FileSystem initFileSystem(URI uri) throws IOException {
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            return FileSystems.newFileSystem(uri, env);
        }
    }

    private void duplicateBaseToFolder() {
        try {
            Path base;
            Path dir = Paths.get("./paintings", new String[0]);
            if (!Files.exists(dir, new LinkOption[0])) {
                Paintings.LOGGER.info("Copying Over Base Template to /paintings");
                Files.createDirectory(dir, new FileAttribute[0]);
                Files.copy(this.getClass().getResourceAsStream("/assets/paintings/paintings.json"), dir.resolve("paintings.json"), new CopyOption[0]);
            }
            if (Files.exists(base = Path.of("./paintings/paintings.json", new String[0]), new LinkOption[0]) && Files.isRegularFile(base, new LinkOption[0]) && base.toString().endsWith(".json")) {
                Paintings.LOGGER.info("Adding base paintings");
                this.makeEntriesFromPath(base);
            }
        }
        catch (IOException | NullPointerException e) {
            Paintings.LOGGER.warn("************************************");
            Paintings.LOGGER.warn("!*!*!*!*!");
            Paintings.LOGGER.error("Copying Base Template Failed");
            Paintings.LOGGER.error(e.getMessage());
            Paintings.LOGGER.warn("!*!*!*!*!");
            Paintings.LOGGER.warn("************************************");
        }
    }

    private void loadFromJson() {
    }
}

