/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.resource.loader;

import com.google.common.base.Charsets;
import com.mojang.bridge.game.GameVersion;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.resource.ModResourcePack;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.impl.resource.loader.ModNioResourcePack;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_155;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3286;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_5359;
import net.minecraft.class_5455;
import net.minecraft.class_6861;
import net.minecraft.class_6903;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class ModResourcePackUtil {
    private ModResourcePackUtil() {
    }

    public static void appendModResourcePacks(List<ModResourcePack> packs, class_3264 type, @Nullable String subPath) {
        for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
            ModNioResourcePack pack;
            if (container.getMetadata().getType().equals("builtin") || (pack = ModNioResourcePack.create(ModResourcePackUtil.getName(container.getMetadata()), container, null, type, ResourcePackActivationType.ALWAYS_ENABLED)) == null) continue;
            packs.add(pack);
        }
    }

    public static boolean containsDefault(ModMetadata info, String filename) {
        return "pack.mcmeta".equals(filename);
    }

    public static InputStream openDefault(ModMetadata info, class_3264 type, String filename) {
        switch (filename) {
            case "pack.mcmeta": {
                String description = info.getName();
                description = description == null ? "" : description.replaceAll("\"", "\\\"");
                String pack = String.format("{\"pack\":{\"pack_format\":" + type.method_31438((GameVersion)class_155.method_16673()) + ",\"description\":\"%s\"}}", description);
                return IOUtils.toInputStream((String)pack, (Charset)Charsets.UTF_8);
            }
        }
        return null;
    }

    public static String getName(ModMetadata info) {
        if (info.getName() != null) {
            return info.getName();
        }
        return "Fabric Mod \"" + info.getId() + "\"";
    }

    public static class_5359 createDefaultDataPackSettings() {
        ModResourcePackCreator modResourcePackCreator = new ModResourcePackCreator(class_3264.field_14190);
        ArrayList moddedResourcePacks = new ArrayList();
        modResourcePackCreator.register(moddedResourcePacks::add);
        ArrayList<String> enabled = new ArrayList<String>(class_5359.field_25393.method_29547());
        ArrayList<String> disabled = new ArrayList<String>(class_5359.field_25393.method_29550());
        for (class_3288 profile : moddedResourcePacks) {
            class_3262 pack = profile.method_14458();
            if (pack instanceof ModNioResourcePack && ((ModNioResourcePack)pack).getActivationType().isEnabledByDefault()) {
                enabled.add(profile.method_14463());
                continue;
            }
            disabled.add(profile.method_14463());
        }
        return new class_5359(enabled, disabled);
    }

    public static void loadDynamicRegistry(class_5455.class_6893 dynamicRegistryManager) {
        try (class_3283 resourcePackManager = new class_3283(class_3264.field_14190, new class_3285[]{new class_3286(), new ModResourcePackCreator(class_3264.field_14190)});
             class_6861 resourceManager = new class_6861(class_3264.field_14190, resourcePackManager.method_29211());){
            class_6903.method_40412((DynamicOps)JsonOps.INSTANCE, (class_5455.class_6893)dynamicRegistryManager, (class_3300)resourceManager);
        }
    }
}

