--[[FMPM package metadata:
info = "Default router firmware"
location = "/etc/router-firmware.lua"
]]

local FIRMWARE = payload
local routes = {}
local newroutes = {}
local hostname = "router-"..computer.address():sub(1,8)

function handleSignal(name, localAddress, remoteAddress, port, dist, data1, data2, ...)
    if name ~= "modem_message" or type(data1) ~= "string" then return end
    local headers = unserialize(data1)
    if type(headers) ~= "table" then return end
    if headers.type == "discover" then
        local ret = {}
        for host, route in pairs(routes) do
            ret[host] = route.hops
        end
        modem.send(remoteAddress, 65535,
                    serialize{type="routes"},
                    serialize(ret))
    elseif headers.type == "routes" and type(data2) == "string" then
        if type(data2) ~= "string" then return end
        local payload = unserialize(data2)
        if type(payload) ~= "table" then return end
        for host, hops in pairs(payload) do
            if (newroutes[host] == nil or newroutes[host].hops > hops + 1) and hops <= 32 then
                newroutes[host] = {["hops"] = hops + 1, ["addr"] = remoteAddress}
            end
        end
    elseif headers.type == "update" then
        modem.broadcast(65535, "{type=\"update\"}")
        computer.shutdown(true)
    elseif headers.type == "request-router-firmware" then
        modem.send(remoteAddress, 65535, serialize({type="response-router-firmware"}), FIRMWARE)
    elseif headers.type == "IP" and headers.destHost ~= nil and type(data2) == "string" then
        local route = routes[headers.destHost]
        local subheaders
        if type(data2) == "string" then
            subheaders = unserialize(data2)
        end
        if headers.type == "IP" and headers.destHost == hostname then
            if type(subheaders) == "table" and subheaders.type == "ICMP" and subheaders.id == "ping" then
                handleSignal("modem_message", localAddress, remoteAddress, port, dist,
                            serialize{type="IP", srcHost = hostname, destHost = headers.srcHost, srcPort = headers.destPort, destPort = headers.srcPort, ttl=32},
                            serialize{type="ICMP", id="pong"},
                            ...)
            end
        elseif (type(headers.ttl) ~= "number" or headers.ttl < 0) and (type(subheaders) ~= "table" or subheaders.type ~= "ICMP" or subheaders.error ~= true) then
            handleSignal("modem_message", localAddress, remoteAddress, port, dist,
                        serialize{type="IP", srcHost = hostname, destHost = headers.srcHost, srcPort = headers.destPort, destPort = headers.srcPort, ttl=32},
                        serialize{type="ICMP", id="TtlExpired"})
        elseif type(headers.ttl) ~= "number" or headers.ttl < 0 then
            -- DROP
        elseif route == nil and type(headers.srcPort) == "number" and (type(subheaders) ~= "table" or subheaders.type ~= "ICMP")  then
            handleSignal("modem_message", localAddress, remoteAddress, port, dist,
                        serialize{type="IP", srcHost = hostname, destHost = headers.srcHost, srcPort = headers.destPort, destPort = headers.srcPort, ttl=32},
                        serialize{type="ICMP", id="HostUnreachable"})
        elseif route ~= nil and route.hops <= 1 and type(headers.destPort) == "number" then
            headers.ttl = headers.ttl - 1
            modem.send(route.addr, headers.destPort, serialize(headers), data2, ...)
        elseif route ~= nil and route.hops > 1 then
            headers.ttl = headers.ttl - 1
            modem.send(route.addr, 65535, serialize(headers), data2, ...)
        end
    end
end

modem.setWakeMessage("{type=\"update\"}")
if modem.isWireless() then
    modem.setStrength(30)
end

while true do
    routes = newroutes
    newroutes = {[hostname] = {["hops"] = 0, ["addr"] = modem.address}}
    modem.broadcast(65535, serialize{type="discover"})
    
    local timeout = computer.uptime() + 1
    while computer.uptime() < timeout do
        signal = handleSignal(computer.pullSignal(timeout - computer.uptime()))
    end
end
