--[[FMPM package metadata:
info = "Traces routing to given hostname."
location = "/usr/bin/traceroute.lua"
]]

local component = require "component"
local serialization = require "serialization"
local event = require "event"
local shell = require "shell"
local ip = require "ip"
local computer = require "computer"

local args, options = shell.parse(...)
local rawArgs = {...}

if options.h or options.help or args[1] == nil then
    print("Usage:")
    print("\ttraceroute <hostname>")
    return
end

local config = ip.getConfig()

if not component.modem.isOpen(65535) then
    error("IP daemon is down!")
    return
end

print("traceroute to " .. args[1])

local ttl = 0

while true do
    component.modem.send(config.gateway, 65535,
        serialization.serialize{type = "IP", ttl = ttl - 1,
            srcPort = 65535, destPort = 65535,
            destHost = args[1], srcHost = config.hostname},
        serialization.serialize{type = "ICMP", id = "ping"})
    
    ttl = ttl + 1
    local time = computer.uptime()

    local timeout = computer.uptime() + 3
    while computer.uptime() < timeout do
        local name, localAddress, remoteAddress, port, dist, headers, subheaders = event.pull(timeout - computer.uptime())
        if name == "interrupted" then
            print("^C")
            return
        end
        if name == "modem_message" and port == 65535 and type(headers) == "string" and type(subheaders) == "string" then
            headers = serialization.unserialize(headers)
            subheaders = serialization.unserialize(subheaders)
            if type(headers) == "table" and type(subheaders) == "table" and headers.type == "IP" and subheaders.type == "ICMP" then
                if subheaders.id == "TtlExpired" then
                    print(ttl .. "\t" .. math.floor((computer.uptime() - time) * 1000) .. " ms\t" .. headers.srcHost .. headers.ttl)
                    break
                elseif subheaders.id == "pong" then
                    print(ttl .. "\t" .. math.floor((computer.uptime() - time) * 1000) .. " ms\t" .. headers.srcHost .. headers.ttl)
                    return
                elseif subheaders.id == "HostUnreachable" then
                    print("Host Unreachable")
                    break
                end
            end
        end
        if name == nil then
            print(ttl .. "\t*\t*")
        end
    end
end
